/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.spark.ChangelogIterator;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;

public class RemoveNetCarryoverIterator
extends ChangelogIterator {
    private final int[] indicesToIdentifySameRow = this.generateIndicesToIdentifySameRow();
    private Row cachedNextRow;
    private Row cachedRow;
    private long cachedRowCount;

    protected RemoveNetCarryoverIterator(Iterator<Row> rowIterator, StructType rowType) {
        super(rowIterator, rowType);
    }

    @Override
    public boolean hasNext() {
        if (this.cachedRowCount > 0L) {
            return true;
        }
        if (this.cachedNextRow != null) {
            return true;
        }
        return this.rowIterator().hasNext();
    }

    @Override
    public Row next() {
        if (this.cachedRowCount > 0L) {
            --this.cachedRowCount;
            return this.cachedRow;
        }
        this.cachedRow = this.getCurrentRow();
        if (!this.rowIterator().hasNext()) {
            return this.cachedRow;
        }
        this.cachedRowCount = 1L;
        this.cachedNextRow = this.rowIterator().next();
        while (this.isSameRecord(this.cachedRow, this.cachedNextRow, this.indicesToIdentifySameRow)) {
            this.cachedRowCount = this.oppositeChangeType(this.cachedRow, this.cachedNextRow) ? --this.cachedRowCount : ++this.cachedRowCount;
            if (this.cachedRowCount <= 0L || !this.rowIterator().hasNext()) {
                this.cachedNextRow = null;
                break;
            }
            this.cachedNextRow = this.rowIterator().next();
        }
        return null;
    }

    private Row getCurrentRow() {
        Row currentRow;
        if (this.cachedNextRow != null) {
            currentRow = this.cachedNextRow;
            this.cachedNextRow = null;
        } else {
            currentRow = this.rowIterator().next();
        }
        return currentRow;
    }

    private boolean oppositeChangeType(Row currentRow, Row nextRow) {
        return this.changeType(nextRow).equals(INSERT) && this.changeType(currentRow).equals(DELETE) || this.changeType(nextRow).equals(DELETE) && this.changeType(currentRow).equals(INSERT);
    }

    private int[] generateIndicesToIdentifySameRow() {
        HashSet metadataColumnIndices = Sets.newHashSet((Object[])new Integer[]{this.rowType().fieldIndex(MetadataColumns.CHANGE_ORDINAL.name()), this.rowType().fieldIndex(MetadataColumns.COMMIT_SNAPSHOT_ID.name()), this.changeTypeIndex()});
        return RemoveNetCarryoverIterator.generateIndicesToIdentifySameRow(this.rowType().size(), metadataColumnIndices);
    }
}

