/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.iceberg.FieldMetrics;
import org.apache.iceberg.orc.OrcValueWriter;
import org.apache.iceberg.spark.data.SparkOrcWriter;
import org.apache.iceberg.util.UUIDUtil;
import org.apache.orc.TypeDescription;
import org.apache.orc.storage.common.type.HiveDecimal;
import org.apache.orc.storage.ql.exec.vector.BytesColumnVector;
import org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.orc.storage.ql.exec.vector.DecimalColumnVector;
import org.apache.orc.storage.ql.exec.vector.ListColumnVector;
import org.apache.orc.storage.ql.exec.vector.MapColumnVector;
import org.apache.orc.storage.ql.exec.vector.TimestampColumnVector;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.types.UTF8String;

class SparkOrcValueWriters {
    private SparkOrcValueWriters() {
    }

    static OrcValueWriter<?> strings() {
        return StringWriter.INSTANCE;
    }

    static OrcValueWriter<?> uuids() {
        return UUIDWriter.INSTANCE;
    }

    static OrcValueWriter<?> timestampTz() {
        return TimestampTzWriter.INSTANCE;
    }

    static OrcValueWriter<?> decimal(int precision, int scale) {
        if (precision <= 18) {
            return new Decimal18Writer(scale);
        }
        return new Decimal38Writer();
    }

    static OrcValueWriter<?> list(OrcValueWriter<?> element, List<TypeDescription> orcType) {
        return new ListWriter(element, orcType);
    }

    static OrcValueWriter<?> map(OrcValueWriter<?> keyWriter, OrcValueWriter<?> valueWriter, List<TypeDescription> orcTypes) {
        return new MapWriter(keyWriter, valueWriter, orcTypes);
    }

    private static void growColumnVector(ColumnVector cv, int requestedSize) {
        if (cv.isNull.length < requestedSize) {
            cv.ensureSize(requestedSize * 3, true);
        }
    }

    private static class MapWriter<K, V>
    implements OrcValueWriter<MapData> {
        private final OrcValueWriter<K> keyWriter;
        private final OrcValueWriter<V> valueWriter;
        private final SparkOrcWriter.FieldGetter<K> keyFieldGetter;
        private final SparkOrcWriter.FieldGetter<V> valueFieldGetter;

        MapWriter(OrcValueWriter<K> keyWriter, OrcValueWriter<V> valueWriter, List<TypeDescription> orcTypes) {
            if (orcTypes.size() != 2) {
                throw new IllegalArgumentException("Expected two ORC type descriptions for a map, got: " + orcTypes);
            }
            this.keyWriter = keyWriter;
            this.valueWriter = valueWriter;
            this.keyFieldGetter = SparkOrcWriter.createFieldGetter(orcTypes.get(0));
            this.valueFieldGetter = SparkOrcWriter.createFieldGetter(orcTypes.get(1));
        }

        public void nonNullWrite(int rowId, MapData map, ColumnVector output) {
            ArrayData key = map.keyArray();
            ArrayData value = map.valueArray();
            MapColumnVector cv = (MapColumnVector)output;
            cv.lengths[rowId] = value.numElements();
            cv.offsets[rowId] = cv.childCount;
            cv.childCount = (int)((long)cv.childCount + cv.lengths[rowId]);
            SparkOrcValueWriters.growColumnVector(cv.keys, cv.childCount);
            SparkOrcValueWriters.growColumnVector(cv.values, cv.childCount);
            int e = 0;
            while ((long)e < cv.lengths[rowId]) {
                int pos = (int)((long)e + cv.offsets[rowId]);
                this.keyWriter.write(pos, this.keyFieldGetter.getFieldOrNull((SpecializedGetters)key, e), cv.keys);
                this.valueWriter.write(pos, this.valueFieldGetter.getFieldOrNull((SpecializedGetters)value, e), cv.values);
                ++e;
            }
        }

        public Stream<FieldMetrics<?>> metrics() {
            return Stream.concat(this.keyWriter.metrics(), this.valueWriter.metrics());
        }
    }

    private static class ListWriter<T>
    implements OrcValueWriter<ArrayData> {
        private final OrcValueWriter<T> writer;
        private final SparkOrcWriter.FieldGetter<T> fieldGetter;

        ListWriter(OrcValueWriter<T> writer, List<TypeDescription> orcTypes) {
            if (orcTypes.size() != 1) {
                throw new IllegalArgumentException("Expected one (and same) ORC type for list elements, got: " + orcTypes);
            }
            this.writer = writer;
            this.fieldGetter = SparkOrcWriter.createFieldGetter(orcTypes.get(0));
        }

        public void nonNullWrite(int rowId, ArrayData value, ColumnVector output) {
            ListColumnVector cv = (ListColumnVector)output;
            cv.lengths[rowId] = value.numElements();
            cv.offsets[rowId] = cv.childCount;
            cv.childCount = (int)((long)cv.childCount + cv.lengths[rowId]);
            SparkOrcValueWriters.growColumnVector(cv.child, cv.childCount);
            int e = 0;
            while ((long)e < cv.lengths[rowId]) {
                this.writer.write((int)((long)e + cv.offsets[rowId]), this.fieldGetter.getFieldOrNull((SpecializedGetters)value, e), cv.child);
                ++e;
            }
        }

        public Stream<FieldMetrics<?>> metrics() {
            return this.writer.metrics();
        }
    }

    private static class Decimal38Writer
    implements OrcValueWriter<Decimal> {
        private Decimal38Writer() {
        }

        public void nonNullWrite(int rowId, Decimal decimal, ColumnVector output) {
            ((DecimalColumnVector)output).vector[rowId].set(HiveDecimal.create((BigDecimal)decimal.toJavaBigDecimal()));
        }
    }

    private static class Decimal18Writer
    implements OrcValueWriter<Decimal> {
        private final int scale;

        Decimal18Writer(int scale) {
            this.scale = scale;
        }

        public void nonNullWrite(int rowId, Decimal decimal, ColumnVector output) {
            ((DecimalColumnVector)output).vector[rowId].setFromLongAndScale(decimal.toUnscaledLong(), this.scale);
        }
    }

    private static class TimestampTzWriter
    implements OrcValueWriter<Long> {
        private static final TimestampTzWriter INSTANCE = new TimestampTzWriter();

        private TimestampTzWriter() {
        }

        public void nonNullWrite(int rowId, Long micros, ColumnVector output) {
            TimestampColumnVector cv = (TimestampColumnVector)output;
            cv.time[rowId] = Math.floorDiv((long)micros, 1000L);
            cv.nanos[rowId] = (int)Math.floorMod((long)micros, 1000000L) * 1000;
        }
    }

    private static class UUIDWriter
    implements OrcValueWriter<UTF8String> {
        private static final UUIDWriter INSTANCE = new UUIDWriter();

        private UUIDWriter() {
        }

        public void nonNullWrite(int rowId, UTF8String data, ColumnVector output) {
            ByteBuffer buffer = UUIDUtil.convertToByteBuffer((UUID)UUID.fromString(data.toString()));
            ((BytesColumnVector)output).setRef(rowId, buffer.array(), 0, buffer.array().length);
        }
    }

    private static class StringWriter
    implements OrcValueWriter<UTF8String> {
        private static final StringWriter INSTANCE = new StringWriter();

        private StringWriter() {
        }

        public void nonNullWrite(int rowId, UTF8String data, ColumnVector output) {
            byte[] value = data.getBytes();
            ((BytesColumnVector)output).setRef(rowId, value, 0, value.length);
        }
    }
}

