/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data.vectorized;

import org.apache.iceberg.arrow.vectorized.ArrowVectorAccessor;
import org.apache.iceberg.arrow.vectorized.NullabilityHolder;
import org.apache.iceberg.arrow.vectorized.VectorHolder;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.data.vectorized.ArrowVectorAccessors;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.vectorized.ArrowColumnVector;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.unsafe.types.UTF8String;

public class IcebergArrowColumnVector
extends ColumnVector {
    private final ArrowVectorAccessor<Decimal, UTF8String, ColumnarArray, ArrowColumnVector> accessor;
    private final NullabilityHolder nullabilityHolder;

    public IcebergArrowColumnVector(VectorHolder holder) {
        super(SparkSchemaUtil.convert(holder.icebergType()));
        this.nullabilityHolder = holder.nullabilityHolder();
        this.accessor = ArrowVectorAccessors.getVectorAccessor(holder);
    }

    protected ArrowVectorAccessor<Decimal, UTF8String, ColumnarArray, ArrowColumnVector> accessor() {
        return this.accessor;
    }

    protected NullabilityHolder nullabilityHolder() {
        return this.nullabilityHolder;
    }

    public void close() {
        this.accessor.close();
    }

    public boolean hasNull() {
        return this.nullabilityHolder.hasNulls();
    }

    public int numNulls() {
        return this.nullabilityHolder.numNulls();
    }

    public boolean isNullAt(int rowId) {
        return this.nullabilityHolder.isNullAt(rowId) == 1;
    }

    public boolean getBoolean(int rowId) {
        return this.accessor.getBoolean(rowId);
    }

    public byte getByte(int rowId) {
        throw new UnsupportedOperationException("Unsupported type - byte");
    }

    public short getShort(int rowId) {
        throw new UnsupportedOperationException("Unsupported type - short");
    }

    public int getInt(int rowId) {
        return this.accessor.getInt(rowId);
    }

    public long getLong(int rowId) {
        return this.accessor.getLong(rowId);
    }

    public float getFloat(int rowId) {
        return this.accessor.getFloat(rowId);
    }

    public double getDouble(int rowId) {
        return this.accessor.getDouble(rowId);
    }

    public ColumnarArray getArray(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return (ColumnarArray)this.accessor.getArray(rowId);
    }

    public ColumnarMap getMap(int rowId) {
        throw new UnsupportedOperationException("Unsupported type - map");
    }

    public Decimal getDecimal(int rowId, int precision, int scale) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return (Decimal)this.accessor.getDecimal(rowId, precision, scale);
    }

    public UTF8String getUTF8String(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return (UTF8String)this.accessor.getUTF8String(rowId);
    }

    public byte[] getBinary(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return this.accessor.getBinary(rowId);
    }

    public ArrowColumnVector getChild(int ordinal) {
        return (ArrowColumnVector)this.accessor.childColumn(ordinal);
    }

    public ArrowVectorAccessor<Decimal, UTF8String, ColumnarArray, ArrowColumnVector> vectorAccessor() {
        return this.accessor;
    }
}

