/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.procedures;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.spark.ChangelogIterator;
import org.apache.iceberg.spark.procedures.BaseProcedure;
import org.apache.iceberg.spark.procedures.ProcedureInput;
import org.apache.iceberg.spark.procedures.SparkProcedures;
import org.apache.spark.api.java.function.MapPartitionsFunction;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.RowEncoder;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.iceberg.catalog.ProcedureParameter;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;

public class CreateChangelogViewProcedure
extends BaseProcedure {
    private static final ProcedureParameter TABLE_PARAM = ProcedureParameter.required("table", DataTypes.StringType);
    private static final ProcedureParameter CHANGELOG_VIEW_PARAM = ProcedureParameter.optional("changelog_view", DataTypes.StringType);
    private static final ProcedureParameter OPTIONS_PARAM = ProcedureParameter.optional("options", STRING_MAP);
    private static final ProcedureParameter COMPUTE_UPDATES_PARAM = ProcedureParameter.optional("compute_updates", DataTypes.BooleanType);
    @Deprecated
    private static final ProcedureParameter REMOVE_CARRYOVERS_PARAM = ProcedureParameter.optional("remove_carryovers", DataTypes.BooleanType);
    private static final ProcedureParameter IDENTIFIER_COLUMNS_PARAM = ProcedureParameter.optional("identifier_columns", STRING_ARRAY);
    private static final ProcedureParameter NET_CHANGES = ProcedureParameter.optional("net_changes", DataTypes.BooleanType);
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{TABLE_PARAM, CHANGELOG_VIEW_PARAM, OPTIONS_PARAM, COMPUTE_UPDATES_PARAM, REMOVE_CARRYOVERS_PARAM, IDENTIFIER_COLUMNS_PARAM, NET_CHANGES};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("changelog_view", DataTypes.StringType, false, Metadata.empty())});

    public static SparkProcedures.ProcedureBuilder builder() {
        return new BaseProcedure.Builder<CreateChangelogViewProcedure>(){

            @Override
            protected CreateChangelogViewProcedure doBuild() {
                return new CreateChangelogViewProcedure(this.tableCatalog());
            }
        };
    }

    private CreateChangelogViewProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        ProcedureInput input = new ProcedureInput(this.spark(), this.tableCatalog(), PARAMETERS, args);
        Identifier tableIdent = input.ident(TABLE_PARAM);
        Identifier changelogTableIdent = this.changelogTableIdent(tableIdent);
        Dataset<Row> df = this.loadRows(changelogTableIdent, this.options(input));
        boolean netChanges = input.asBoolean(NET_CHANGES, false);
        if (this.shouldComputeUpdateImages(input)) {
            Preconditions.checkArgument((!netChanges ? 1 : 0) != 0, (Object)"Not support net changes with update images");
            df = this.computeUpdateImages(this.identifierColumns(input, tableIdent), df);
        } else if (this.shouldRemoveCarryoverRows(input)) {
            df = this.removeCarryoverRows(df, netChanges);
        }
        String viewName = this.viewName(input, tableIdent.name());
        df.createOrReplaceTempView(viewName);
        return this.toOutputRows(viewName);
    }

    private Dataset<Row> computeUpdateImages(String[] identifierColumns, Dataset<Row> df) {
        Preconditions.checkArgument((identifierColumns.length > 0 ? 1 : 0) != 0, (Object)"Cannot compute the update images because identifier columns are not set");
        Column[] repartitionSpec = new Column[identifierColumns.length + 1];
        for (int i = 0; i < identifierColumns.length; ++i) {
            repartitionSpec[i] = df.col(identifierColumns[i]);
        }
        repartitionSpec[repartitionSpec.length - 1] = df.col(MetadataColumns.CHANGE_ORDINAL.name());
        return this.applyChangelogIterator(df, repartitionSpec);
    }

    private boolean shouldComputeUpdateImages(ProcedureInput input) {
        boolean defaultValue = input.isProvided(IDENTIFIER_COLUMNS_PARAM);
        return input.asBoolean(COMPUTE_UPDATES_PARAM, defaultValue);
    }

    private boolean shouldRemoveCarryoverRows(ProcedureInput input) {
        return input.asBoolean(REMOVE_CARRYOVERS_PARAM, true);
    }

    private Dataset<Row> removeCarryoverRows(Dataset<Row> df, boolean netChanges) {
        Predicate<String> columnsToKeep;
        if (netChanges) {
            HashSet metadataColumn = Sets.newHashSet((Object[])new String[]{MetadataColumns.CHANGE_TYPE.name(), MetadataColumns.CHANGE_ORDINAL.name(), MetadataColumns.COMMIT_SNAPSHOT_ID.name()});
            columnsToKeep = column -> !metadataColumn.contains(column);
        } else {
            columnsToKeep = column -> !column.equals(MetadataColumns.CHANGE_TYPE.name());
        }
        Column[] repartitionSpec = (Column[])Arrays.stream(df.columns()).filter(columnsToKeep).map(arg_0 -> df.col(arg_0)).toArray(Column[]::new);
        return this.applyCarryoverRemoveIterator(df, repartitionSpec, netChanges);
    }

    private String[] identifierColumns(ProcedureInput input, Identifier tableIdent) {
        if (input.isProvided(IDENTIFIER_COLUMNS_PARAM)) {
            return input.asStringArray(IDENTIFIER_COLUMNS_PARAM);
        }
        Table table = this.loadSparkTable(tableIdent).table();
        return table.schema().identifierFieldNames().toArray(new String[0]);
    }

    private Identifier changelogTableIdent(Identifier tableIdent) {
        ArrayList namespace = Lists.newArrayList();
        namespace.addAll(Arrays.asList(tableIdent.namespace()));
        namespace.add(tableIdent.name());
        return Identifier.of((String[])namespace.toArray(new String[0]), (String)"changes");
    }

    private Map<String, String> options(ProcedureInput input) {
        return input.asStringMap(OPTIONS_PARAM, (Map<String, String>)ImmutableMap.of());
    }

    private String viewName(ProcedureInput input, String tableName) {
        String defaultValue = String.format("`%s_changes`", tableName);
        return input.asString(CHANGELOG_VIEW_PARAM, defaultValue);
    }

    private Dataset<Row> applyChangelogIterator(Dataset<Row> df, Column[] repartitionSpec) {
        Column[] sortSpec = CreateChangelogViewProcedure.sortSpec(df, repartitionSpec, false);
        StructType schema = df.schema();
        String[] identifierFields = (String[])Arrays.stream(repartitionSpec).map(Column::toString).toArray(String[]::new);
        return df.repartition(repartitionSpec).sortWithinPartitions(sortSpec).mapPartitions((MapPartitionsFunction & Serializable)rowIterator -> ChangelogIterator.computeUpdates(rowIterator, schema, identifierFields), (Encoder)RowEncoder.apply((StructType)schema));
    }

    private Dataset<Row> applyCarryoverRemoveIterator(Dataset<Row> df, Column[] repartitionSpec, boolean netChanges) {
        Column[] sortSpec = CreateChangelogViewProcedure.sortSpec(df, repartitionSpec, netChanges);
        StructType schema = df.schema();
        return df.repartition(repartitionSpec).sortWithinPartitions(sortSpec).mapPartitions((MapPartitionsFunction & Serializable)rowIterator -> netChanges ? ChangelogIterator.removeNetCarryovers(rowIterator, schema) : ChangelogIterator.removeCarryovers(rowIterator, schema), (Encoder)RowEncoder.apply((StructType)schema));
    }

    private static Column[] sortSpec(Dataset<Row> df, Column[] repartitionSpec, boolean netChanges) {
        Column[] columnArray;
        Column changeType = df.col(MetadataColumns.CHANGE_TYPE.name());
        Column changeOrdinal = df.col(MetadataColumns.CHANGE_ORDINAL.name());
        if (netChanges) {
            Column[] columnArray2 = new Column[2];
            columnArray2[0] = changeOrdinal;
            columnArray = columnArray2;
            columnArray2[1] = changeType;
        } else {
            Column[] columnArray3 = new Column[1];
            columnArray = columnArray3;
            columnArray3[0] = changeType;
        }
        Column[] extraColumns = columnArray;
        Column[] sortSpec = new Column[repartitionSpec.length + extraColumns.length];
        System.arraycopy(repartitionSpec, 0, sortSpec, 0, repartitionSpec.length);
        System.arraycopy(extraColumns, 0, sortSpec, repartitionSpec.length, extraColumns.length);
        return sortSpec;
    }

    private InternalRow[] toOutputRows(String viewName) {
        InternalRow row = this.newInternalRow(UTF8String.fromString((String)viewName));
        return new InternalRow[]{row};
    }

    @Override
    public String description() {
        return "CreateChangelogViewProcedure";
    }
}

