/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Map;
import org.apache.iceberg.DistributionMode;
import org.apache.iceberg.IsolationLevel;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkDistributionAndOrderingUtil;
import org.apache.iceberg.spark.SparkFilters;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.SparkUtil;
import org.apache.iceberg.spark.SparkWriteConf;
import org.apache.iceberg.spark.source.SparkCopyOnWriteScan;
import org.apache.iceberg.spark.source.SparkWrite;
import org.apache.iceberg.types.TypeUtil;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.distributions.Distribution;
import org.apache.spark.sql.connector.distributions.Distributions;
import org.apache.spark.sql.connector.distributions.UnspecifiedDistribution;
import org.apache.spark.sql.connector.expressions.SortOrder;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.write.BatchWrite;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.RowLevelOperation;
import org.apache.spark.sql.connector.write.SupportsDynamicOverwrite;
import org.apache.spark.sql.connector.write.SupportsOverwrite;
import org.apache.spark.sql.connector.write.Write;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.connector.write.streaming.StreamingWrite;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SparkWriteBuilder
implements WriteBuilder,
SupportsDynamicOverwrite,
SupportsOverwrite {
    private static final Logger LOG = LoggerFactory.getLogger(SparkWriteBuilder.class);
    private static final SortOrder[] NO_ORDERING = new SortOrder[0];
    private final SparkSession spark;
    private final Table table;
    private final SparkWriteConf writeConf;
    private final LogicalWriteInfo writeInfo;
    private final StructType dsSchema;
    private final String overwriteMode;
    private final String rewrittenFileSetId;
    private final boolean handleTimestampWithoutZone;
    private final boolean useTableDistributionAndOrdering;
    private boolean overwriteDynamic = false;
    private boolean overwriteByFilter = false;
    private Expression overwriteExpr = null;
    private boolean overwriteFiles = false;
    private SparkCopyOnWriteScan copyOnWriteScan = null;
    private RowLevelOperation.Command copyOnWriteCommand = null;
    private IsolationLevel copyOnWriteIsolationLevel = null;

    SparkWriteBuilder(SparkSession spark, Table table, String branch, LogicalWriteInfo info) {
        this.spark = spark;
        this.table = table;
        this.writeConf = new SparkWriteConf(spark, table, branch, (Map<String, String>)info.options());
        this.writeInfo = info;
        this.dsSchema = info.schema();
        this.overwriteMode = this.writeConf.overwriteMode();
        this.rewrittenFileSetId = this.writeConf.rewrittenFileSetId();
        this.handleTimestampWithoutZone = this.writeConf.handleTimestampWithoutZone();
        this.useTableDistributionAndOrdering = this.writeConf.useTableDistributionAndOrdering();
    }

    public WriteBuilder overwriteFiles(Scan scan, RowLevelOperation.Command command, IsolationLevel isolationLevel) {
        Preconditions.checkState((!this.overwriteByFilter ? 1 : 0) != 0, (Object)"Cannot overwrite individual files and by filter");
        Preconditions.checkState((!this.overwriteDynamic ? 1 : 0) != 0, (Object)"Cannot overwrite individual files and dynamically");
        Preconditions.checkState((this.rewrittenFileSetId == null ? 1 : 0) != 0, (Object)"Cannot overwrite individual files and rewrite");
        this.overwriteFiles = true;
        this.copyOnWriteScan = (SparkCopyOnWriteScan)scan;
        this.copyOnWriteCommand = command;
        this.copyOnWriteIsolationLevel = isolationLevel;
        return this;
    }

    public WriteBuilder overwriteDynamicPartitions() {
        Preconditions.checkState((!this.overwriteByFilter ? 1 : 0) != 0, (String)"Cannot overwrite dynamically and by filter: %s", (Object)this.overwriteExpr);
        Preconditions.checkState((!this.overwriteFiles ? 1 : 0) != 0, (Object)"Cannot overwrite individual files and dynamically");
        Preconditions.checkState((this.rewrittenFileSetId == null ? 1 : 0) != 0, (Object)"Cannot overwrite dynamically and rewrite");
        this.overwriteDynamic = true;
        return this;
    }

    public WriteBuilder overwrite(Filter[] filters) {
        Preconditions.checkState((!this.overwriteFiles ? 1 : 0) != 0, (Object)"Cannot overwrite individual files and using filters");
        Preconditions.checkState((this.rewrittenFileSetId == null ? 1 : 0) != 0, (Object)"Cannot overwrite and rewrite");
        this.overwriteExpr = SparkFilters.convert(filters);
        if (this.overwriteExpr == Expressions.alwaysTrue() && "dynamic".equals(this.overwriteMode)) {
            this.overwriteDynamic = true;
        } else {
            Preconditions.checkState((!this.overwriteDynamic ? 1 : 0) != 0, (String)"Cannot overwrite dynamically and by filter: %s", (Object)this.overwriteExpr);
            this.overwriteByFilter = true;
        }
        return this;
    }

    public Write build() {
        SortOrder[] ordering;
        UnspecifiedDistribution distribution;
        Preconditions.checkArgument((this.handleTimestampWithoutZone || !SparkUtil.hasTimestampWithoutZone(this.table.schema()) ? 1 : 0) != 0, (Object)SparkUtil.TIMESTAMP_WITHOUT_TIMEZONE_ERROR);
        Schema writeSchema = SparkWriteBuilder.validateOrMergeWriteSchema(this.table, this.dsSchema, this.writeConf);
        SparkUtil.validatePartitionTransforms(this.table.spec());
        String appId = this.spark.sparkContext().applicationId();
        if (this.useTableDistributionAndOrdering) {
            if (Spark3Util.extensionsEnabled(this.spark) || this.allIdentityTransforms(this.table.spec())) {
                distribution = this.buildRequiredDistribution();
                ordering = this.buildRequiredOrdering((Distribution)distribution);
            } else {
                LOG.warn("Skipping distribution/ordering: extensions are disabled and spec contains unsupported transforms");
                distribution = Distributions.unspecified();
                ordering = NO_ORDERING;
            }
        } else {
            LOG.info("Skipping distribution/ordering: disabled per job configuration");
            distribution = Distributions.unspecified();
            ordering = NO_ORDERING;
        }
        return new SparkWrite(this.spark, this.table, this.writeConf, this.writeInfo, appId, writeSchema, this.dsSchema, (Distribution)distribution, ordering){

            public BatchWrite toBatch() {
                if (SparkWriteBuilder.this.rewrittenFileSetId != null) {
                    return this.asRewrite(SparkWriteBuilder.this.rewrittenFileSetId);
                }
                if (SparkWriteBuilder.this.overwriteByFilter) {
                    return this.asOverwriteByFilter(SparkWriteBuilder.this.overwriteExpr);
                }
                if (SparkWriteBuilder.this.overwriteDynamic) {
                    return this.asDynamicOverwrite();
                }
                if (SparkWriteBuilder.this.overwriteFiles) {
                    return this.asCopyOnWriteOperation(SparkWriteBuilder.this.copyOnWriteScan, SparkWriteBuilder.this.copyOnWriteIsolationLevel);
                }
                return this.asBatchAppend();
            }

            public StreamingWrite toStreaming() {
                Preconditions.checkState((!SparkWriteBuilder.this.overwriteDynamic ? 1 : 0) != 0, (Object)"Unsupported streaming operation: dynamic partition overwrite");
                Preconditions.checkState((!SparkWriteBuilder.this.overwriteByFilter || SparkWriteBuilder.this.overwriteExpr == Expressions.alwaysTrue() ? 1 : 0) != 0, (String)"Unsupported streaming operation: overwrite by filter: %s", (Object)SparkWriteBuilder.this.overwriteExpr);
                Preconditions.checkState((SparkWriteBuilder.this.rewrittenFileSetId == null ? 1 : 0) != 0, (Object)"Unsupported streaming operation: rewrite");
                if (SparkWriteBuilder.this.overwriteByFilter) {
                    return this.asStreamingOverwrite();
                }
                return this.asStreamingAppend();
            }
        };
    }

    private Distribution buildRequiredDistribution() {
        if (this.overwriteFiles) {
            DistributionMode distributionMode = this.copyOnWriteDistributionMode();
            return SparkDistributionAndOrderingUtil.buildCopyOnWriteDistribution(this.table, this.copyOnWriteCommand, distributionMode);
        }
        DistributionMode distributionMode = this.writeConf.distributionMode();
        return SparkDistributionAndOrderingUtil.buildRequiredDistribution(this.table, distributionMode);
    }

    private DistributionMode copyOnWriteDistributionMode() {
        switch (this.copyOnWriteCommand) {
            case DELETE: {
                return this.writeConf.deleteDistributionMode();
            }
            case UPDATE: {
                return this.writeConf.updateDistributionMode();
            }
            case MERGE: {
                return this.writeConf.copyOnWriteMergeDistributionMode();
            }
        }
        throw new IllegalArgumentException("Unexpected command: " + this.copyOnWriteCommand);
    }

    private SortOrder[] buildRequiredOrdering(Distribution requiredDistribution) {
        if (this.overwriteFiles) {
            return SparkDistributionAndOrderingUtil.buildCopyOnWriteOrdering(this.table, this.copyOnWriteCommand, requiredDistribution);
        }
        return SparkDistributionAndOrderingUtil.buildRequiredOrdering(this.table, requiredDistribution);
    }

    private boolean allIdentityTransforms(PartitionSpec spec) {
        return spec.fields().stream().allMatch(field -> field.transform().isIdentity());
    }

    private static Schema validateOrMergeWriteSchema(Table table, StructType dsSchema, SparkWriteConf writeConf) {
        Schema writeSchema;
        boolean caseSensitive = writeConf.caseSensitive();
        if (writeConf.mergeSchema()) {
            Schema newSchema = SparkSchemaUtil.convertWithFreshIds(table.schema(), dsSchema, caseSensitive);
            UpdateSchema update = table.updateSchema().caseSensitive(caseSensitive).unionByNameWith(newSchema);
            Schema mergedSchema = (Schema)update.apply();
            writeSchema = SparkSchemaUtil.convert(mergedSchema, dsSchema, caseSensitive);
            TypeUtil.validateWriteSchema((Schema)mergedSchema, (Schema)writeSchema, (Boolean)writeConf.checkNullability(), (Boolean)writeConf.checkOrdering());
            update.commit();
        } else {
            writeSchema = SparkSchemaUtil.convert(table.schema(), dsSchema, caseSensitive);
            TypeUtil.validateWriteSchema((Schema)table.schema(), (Schema)writeSchema, (Boolean)writeConf.checkNullability(), (Boolean)writeConf.checkOrdering());
        }
        return writeSchema;
    }
}

