/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.api.config;

import java.io.File;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import org.apache.amoro.api.config.Configurations;
import org.apache.amoro.api.config.StructuredOptionsSplitter;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;

public class ConfigHelpers {
    private static final String[] EMPTY = new String[0];

    private ConfigHelpers() {
    }

    @Nonnull
    public static Configurations createConfiguration(Properties properties) {
        Configurations configuration = new Configurations();
        Set<String> propertyNames = properties.stringPropertyNames();
        for (String propertyName : propertyNames) {
            configuration.setString(propertyName, properties.getProperty(propertyName));
        }
        return configuration;
    }

    @Nonnull
    public static String[] splitPaths(@Nonnull String separatedPaths) {
        return separatedPaths.length() > 0 ? separatedPaths.split(",|" + File.pathSeparator) : EMPTY;
    }

    private static void checkConfigContains(Map<String, String> configs, String key) {
        Preconditions.checkArgument((boolean)configs.containsKey(key), (String)"Key %s is missing present from dynamic configs.", (Object)key);
    }

    public static <T> T convertValue(Object rawValue, Class<?> clazz) {
        if (Integer.class.equals(clazz)) {
            return (T)ConfigHelpers.convertToInt(rawValue);
        }
        if (Long.class.equals(clazz)) {
            return (T)ConfigHelpers.convertToLong(rawValue);
        }
        if (Boolean.class.equals(clazz)) {
            return (T)ConfigHelpers.convertToBoolean(rawValue);
        }
        if (Float.class.equals(clazz)) {
            return (T)ConfigHelpers.convertToFloat(rawValue);
        }
        if (Double.class.equals(clazz)) {
            return (T)ConfigHelpers.convertToDouble(rawValue);
        }
        if (String.class.equals(clazz)) {
            return (T)ConfigHelpers.convertToString(rawValue);
        }
        if (clazz.isEnum()) {
            return (T)ConfigHelpers.convertToEnum(rawValue, clazz);
        }
        if (clazz == Duration.class) {
            return (T)ConfigHelpers.convertToDuration(rawValue);
        }
        if (clazz == Map.class) {
            return (T)ConfigHelpers.convertToProperties(rawValue);
        }
        throw new IllegalArgumentException("Unsupported type: " + clazz);
    }

    public static <T> T convertToList(Object rawValue, Class<?> atomicClass) {
        if (rawValue instanceof List) {
            return (T)rawValue;
        }
        return (T)StructuredOptionsSplitter.splitEscaped(rawValue.toString(), ';').stream().map(s -> ConfigHelpers.convertValue(s, atomicClass)).collect(Collectors.toList());
    }

    public static Map<String, String> convertToProperties(Object o) {
        if (o instanceof Map) {
            return (Map)o;
        }
        List<String> listOfRawProperties = StructuredOptionsSplitter.splitEscaped(o.toString(), ',');
        return listOfRawProperties.stream().map(s -> StructuredOptionsSplitter.splitEscaped(s, ':')).peek(pair -> {
            if (pair.size() != 2) {
                throw new IllegalArgumentException("Could not parse pair in the map " + pair);
            }
        }).collect(Collectors.toMap(a -> (String)a.get(0), a -> (String)a.get(1)));
    }

    public static Map<String, Object> convertConfigurationKeys(String prefix, Map<String, String> values) {
        return values.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(prefix)).collect(Collectors.toMap(entry -> ((String)entry.getKey()).replaceFirst(prefix + "_", "").toLowerCase().replaceAll("(_{2,})", "-").replace("_", "."), Map.Entry::getValue));
    }

    public static <E extends Enum<?>> E convertToEnum(Object o, Class<E> clazz) {
        if (o.getClass().equals(clazz)) {
            return (E)((Enum)o);
        }
        return (E)Arrays.stream(clazz.getEnumConstants()).filter(e -> e.toString().toUpperCase(Locale.ROOT).equals(o.toString().toUpperCase(Locale.ROOT))).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("Could not parse value for enum %s. Expected one of: [%s]", clazz, Arrays.toString(clazz.getEnumConstants()))));
    }

    public static Duration convertToDuration(Object o) {
        if (o.getClass() == Duration.class) {
            return (Duration)o;
        }
        return TimeUtils.parseDuration(o.toString());
    }

    public static String convertToString(Object o) {
        if (o.getClass() == String.class) {
            return (String)o;
        }
        if (o.getClass() == Duration.class) {
            Duration duration = (Duration)o;
            return String.format("%d ns", duration.toNanos());
        }
        if (o instanceof List) {
            return ((List)o).stream().map(e -> StructuredOptionsSplitter.escapeWithSingleQuote(ConfigHelpers.convertToString(e), ";")).collect(Collectors.joining(";"));
        }
        if (o instanceof Map) {
            return ((Map)o).entrySet().stream().map(e -> {
                String escapedKey = StructuredOptionsSplitter.escapeWithSingleQuote(e.getKey().toString(), ":");
                String escapedValue = StructuredOptionsSplitter.escapeWithSingleQuote(e.getValue().toString(), ":");
                return StructuredOptionsSplitter.escapeWithSingleQuote(escapedKey + ":" + escapedValue, ",");
            }).collect(Collectors.joining(","));
        }
        return o.toString();
    }

    static Integer convertToInt(Object o) {
        if (o.getClass() == Integer.class) {
            return (Integer)o;
        }
        if (o.getClass() == Long.class) {
            long value = (Long)o;
            if (value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE) {
                return (int)value;
            }
            throw new IllegalArgumentException(String.format("Configuration value %s overflows/underflows the integer type.", value));
        }
        return Integer.parseInt(o.toString());
    }

    static Long convertToLong(Object o) {
        if (o.getClass() == Long.class) {
            return (Long)o;
        }
        if (o.getClass() == Integer.class) {
            return ((Integer)o).longValue();
        }
        return Long.parseLong(o.toString());
    }

    static Boolean convertToBoolean(Object o) {
        if (o.getClass() == Boolean.class) {
            return (Boolean)o;
        }
        switch (o.toString().toUpperCase()) {
            case "TRUE": {
                return true;
            }
            case "FALSE": {
                return false;
            }
        }
        throw new IllegalArgumentException(String.format("Unrecognized option for boolean: %s. Expected either true or false(case insensitive)", o));
    }

    static Float convertToFloat(Object o) {
        if (o.getClass() == Float.class) {
            return (Float)o;
        }
        if (o.getClass() == Double.class) {
            double value = (Double)o;
            if (value == 0.0 || value >= (double)1.4E-45f && value <= 3.4028234663852886E38 || value >= -3.4028234663852886E38 && value <= (double)-1.4E-45f) {
                return Float.valueOf((float)value);
            }
            throw new IllegalArgumentException(String.format("Configuration value %s overflows/underflows the float type.", value));
        }
        return Float.valueOf(Float.parseFloat(o.toString()));
    }

    static Double convertToDouble(Object o) {
        if (o.getClass() == Double.class) {
            return (Double)o;
        }
        if (o.getClass() == Float.class) {
            return ((Float)o).doubleValue();
        }
        return Double.parseDouble(o.toString());
    }

    public static class TimeUtils {
        private static final Map<String, ChronoUnit> LABEL_TO_UNIT_MAP = Collections.unmodifiableMap(TimeUtils.initMap());

        public static Duration parseDuration(String text) {
            long value;
            char current;
            int pos;
            Preconditions.checkNotNull((Object)text);
            String trimmed = text.trim();
            Preconditions.checkArgument((!trimmed.isEmpty() ? 1 : 0) != 0, (Object)"argument is an empty- or whitespace-only string");
            int len = trimmed.length();
            for (pos = 0; pos < len && (current = trimmed.charAt(pos)) >= '0' && current <= '9'; ++pos) {
            }
            String number = trimmed.substring(0, pos);
            String unitLabel = trimmed.substring(pos).trim().toLowerCase(Locale.US);
            if (number.isEmpty()) {
                throw new NumberFormatException("text does not start with a number");
            }
            try {
                value = Long.parseLong(number);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("The value '" + number + "' cannot be re represented as 64bit number (numeric overflow).");
            }
            if (unitLabel.isEmpty()) {
                return Duration.of(value, ChronoUnit.MILLIS);
            }
            ChronoUnit unit = LABEL_TO_UNIT_MAP.get(unitLabel);
            if (unit != null) {
                return Duration.of(value, unit);
            }
            throw new IllegalArgumentException("Time interval unit label '" + unitLabel + "' does not match any of the recognized units: " + TimeUnit.getAllUnits());
        }

        private static Map<String, ChronoUnit> initMap() {
            HashMap<String, ChronoUnit> labelToUnit = new HashMap<String, ChronoUnit>();
            for (TimeUnit timeUnit : TimeUnit.values()) {
                for (String label : timeUnit.getLabels()) {
                    labelToUnit.put(label, timeUnit.getUnit());
                }
            }
            return labelToUnit;
        }

        public static String getStringInMillis(Duration duration) {
            return duration.toMillis() + (String)TimeUnit.MILLISECONDS.labels.get(0);
        }

        public static String formatWithHighestUnit(Duration duration) {
            long nanos = duration.toNanos();
            List<TimeUnit> orderedUnits = Arrays.asList(TimeUnit.NANOSECONDS, TimeUnit.MICROSECONDS, TimeUnit.MILLISECONDS, TimeUnit.SECONDS, TimeUnit.MINUTES, TimeUnit.HOURS, TimeUnit.DAYS);
            TimeUnit highestIntegerUnit = IntStream.range(0, orderedUnits.size()).sequential().filter(idx -> nanos % ((TimeUnit)((Object)((Object)orderedUnits.get(idx)))).unit.getDuration().toNanos() != 0L).boxed().findFirst().map(idx -> {
                if (idx == 0) {
                    return (TimeUnit)((Object)((Object)orderedUnits.get(0)));
                }
                return (TimeUnit)((Object)((Object)orderedUnits.get(idx - 1)));
            }).orElse(TimeUnit.MILLISECONDS);
            return String.format("%d %s", nanos / highestIntegerUnit.unit.getDuration().toNanos(), highestIntegerUnit.getLabels().get(0));
        }

        private static ChronoUnit toChronoUnit(java.util.concurrent.TimeUnit timeUnit) {
            switch (timeUnit) {
                case NANOSECONDS: {
                    return ChronoUnit.NANOS;
                }
                case MICROSECONDS: {
                    return ChronoUnit.MICROS;
                }
                case MILLISECONDS: {
                    return ChronoUnit.MILLIS;
                }
                case SECONDS: {
                    return ChronoUnit.SECONDS;
                }
                case MINUTES: {
                    return ChronoUnit.MINUTES;
                }
                case HOURS: {
                    return ChronoUnit.HOURS;
                }
                case DAYS: {
                    return ChronoUnit.DAYS;
                }
            }
            throw new IllegalArgumentException(String.format("Unsupported time unit %s.", new Object[]{timeUnit}));
        }

        private static enum TimeUnit {
            DAYS(ChronoUnit.DAYS, TimeUnit.singular("d"), TimeUnit.plural("day")),
            HOURS(ChronoUnit.HOURS, TimeUnit.singular("h"), TimeUnit.plural("hour")),
            MINUTES(ChronoUnit.MINUTES, TimeUnit.singular("min"), TimeUnit.plural("minute")),
            SECONDS(ChronoUnit.SECONDS, TimeUnit.singular("s"), TimeUnit.plural("sec"), TimeUnit.plural("second")),
            MILLISECONDS(ChronoUnit.MILLIS, TimeUnit.singular("ms"), TimeUnit.plural("milli"), TimeUnit.plural("millisecond")),
            MICROSECONDS(ChronoUnit.MICROS, TimeUnit.singular("\u00b5s"), TimeUnit.plural("micro"), TimeUnit.plural("microsecond")),
            NANOSECONDS(ChronoUnit.NANOS, TimeUnit.singular("ns"), TimeUnit.plural("nano"), TimeUnit.plural("nanosecond"));

            private static final String PLURAL_SUFFIX = "s";
            private final List<String> labels;
            private final ChronoUnit unit;

            private TimeUnit(ChronoUnit unit, String[] ... labels) {
                this.unit = unit;
                this.labels = Arrays.stream(labels).flatMap(Arrays::stream).collect(Collectors.toList());
            }

            private static String[] singular(String label) {
                return new String[]{label};
            }

            private static String[] plural(String label) {
                return new String[]{label, label + PLURAL_SUFFIX};
            }

            public static String getAllUnits() {
                return Arrays.stream(TimeUnit.values()).map(TimeUnit::createTimeUnitString).collect(Collectors.joining(", "));
            }

            private static String createTimeUnitString(TimeUnit timeUnit) {
                return timeUnit.name() + ": (" + String.join((CharSequence)" | ", timeUnit.getLabels()) + ")";
            }

            public List<String> getLabels() {
                return this.labels;
            }

            public ChronoUnit getUnit() {
                return this.unit;
            }
        }
    }
}

