/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.api.config;

import java.util.Map;
import java.util.Optional;
import org.apache.amoro.api.config.DataExpirationConfig;
import org.apache.amoro.api.config.OptimizingConfig;
import org.apache.amoro.api.config.TagConfiguration;
import org.apache.amoro.shade.guava32.com.google.common.base.Objects;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.amoro.utils.CompatiblePropertyUtil;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TableConfiguration {
    private boolean expireSnapshotEnabled;
    private long snapshotTTLMinutes;
    private long changeDataTTLMinutes;
    private boolean cleanOrphanEnabled;
    private long orphanExistingMinutes;
    private boolean deleteDanglingDeleteFilesEnabled;
    private OptimizingConfig optimizingConfig;
    private DataExpirationConfig expiringDataConfig;
    private TagConfiguration tagConfiguration;

    public boolean isExpireSnapshotEnabled() {
        return this.expireSnapshotEnabled;
    }

    public long getSnapshotTTLMinutes() {
        return this.snapshotTTLMinutes;
    }

    public long getChangeDataTTLMinutes() {
        return this.changeDataTTLMinutes;
    }

    public boolean isCleanOrphanEnabled() {
        return this.cleanOrphanEnabled;
    }

    public long getOrphanExistingMinutes() {
        return this.orphanExistingMinutes;
    }

    public OptimizingConfig getOptimizingConfig() {
        return this.optimizingConfig;
    }

    public TableConfiguration setOptimizingConfig(OptimizingConfig optimizingConfig) {
        this.optimizingConfig = optimizingConfig;
        return this;
    }

    public TableConfiguration setExpireSnapshotEnabled(boolean expireSnapshotEnabled) {
        this.expireSnapshotEnabled = expireSnapshotEnabled;
        return this;
    }

    public TableConfiguration setSnapshotTTLMinutes(long snapshotTTLMinutes) {
        this.snapshotTTLMinutes = snapshotTTLMinutes;
        return this;
    }

    public TableConfiguration setChangeDataTTLMinutes(long changeDataTTLMinutes) {
        this.changeDataTTLMinutes = changeDataTTLMinutes;
        return this;
    }

    public TableConfiguration setCleanOrphanEnabled(boolean cleanOrphanEnabled) {
        this.cleanOrphanEnabled = cleanOrphanEnabled;
        return this;
    }

    public TableConfiguration setOrphanExistingMinutes(long orphanExistingMinutes) {
        this.orphanExistingMinutes = orphanExistingMinutes;
        return this;
    }

    public boolean isDeleteDanglingDeleteFilesEnabled() {
        return this.deleteDanglingDeleteFilesEnabled;
    }

    public TableConfiguration setDeleteDanglingDeleteFilesEnabled(boolean deleteDanglingDeleteFilesEnabled) {
        this.deleteDanglingDeleteFilesEnabled = deleteDanglingDeleteFilesEnabled;
        return this;
    }

    public DataExpirationConfig getExpiringDataConfig() {
        return Optional.ofNullable(this.expiringDataConfig).orElse(new DataExpirationConfig());
    }

    public TableConfiguration setExpiringDataConfig(DataExpirationConfig expiringDataConfig) {
        this.expiringDataConfig = expiringDataConfig;
        return this;
    }

    public TagConfiguration getTagConfiguration() {
        return Optional.ofNullable(this.tagConfiguration).orElse(new TagConfiguration());
    }

    public TableConfiguration setTagConfiguration(TagConfiguration tagConfiguration) {
        this.tagConfiguration = tagConfiguration;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableConfiguration that = (TableConfiguration)o;
        return this.expireSnapshotEnabled == that.expireSnapshotEnabled && this.snapshotTTLMinutes == that.snapshotTTLMinutes && this.changeDataTTLMinutes == that.changeDataTTLMinutes && this.cleanOrphanEnabled == that.cleanOrphanEnabled && this.orphanExistingMinutes == that.orphanExistingMinutes && this.deleteDanglingDeleteFilesEnabled == that.deleteDanglingDeleteFilesEnabled && Objects.equal((Object)this.optimizingConfig, (Object)that.optimizingConfig) && Objects.equal((Object)this.expiringDataConfig, (Object)that.expiringDataConfig) && Objects.equal((Object)this.tagConfiguration, (Object)that.tagConfiguration);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.expireSnapshotEnabled, this.snapshotTTLMinutes, this.changeDataTTLMinutes, this.cleanOrphanEnabled, this.orphanExistingMinutes, this.deleteDanglingDeleteFilesEnabled, this.optimizingConfig, this.expiringDataConfig, this.tagConfiguration});
    }

    public static TableConfiguration parseConfig(Map<String, String> properties) {
        boolean gcEnabled = CompatiblePropertyUtil.propertyAsBoolean(properties, (String)"gc.enabled", (boolean)true);
        return new TableConfiguration().setExpireSnapshotEnabled(gcEnabled && CompatiblePropertyUtil.propertyAsBoolean(properties, (String)"table-expire.enabled", (boolean)true)).setSnapshotTTLMinutes(CompatiblePropertyUtil.propertyAsLong(properties, (String)"snapshot.base.keep.minutes", (long)720L)).setChangeDataTTLMinutes(CompatiblePropertyUtil.propertyAsLong(properties, (String)"change.data.ttl.minutes", (long)10080L)).setCleanOrphanEnabled(gcEnabled && CompatiblePropertyUtil.propertyAsBoolean(properties, (String)"clean-orphan-file.enabled", (boolean)false)).setOrphanExistingMinutes(CompatiblePropertyUtil.propertyAsLong(properties, (String)"clean-orphan-file.min-existing-time-minutes", (long)2880L)).setDeleteDanglingDeleteFilesEnabled(gcEnabled && CompatiblePropertyUtil.propertyAsBoolean(properties, (String)"clean-dangling-delete-files.enabled", (boolean)true)).setOptimizingConfig(OptimizingConfig.parse(properties)).setExpiringDataConfig(DataExpirationConfig.parse(properties)).setTagConfiguration(TagConfiguration.parse(properties));
    }
}

