/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kyuubi.jdbc.hive.JdbcConnectionParams;
import org.apache.kyuubi.jdbc.hive.ZooKeeperHiveClientException;
import org.apache.kyuubi.shade.org.apache.curator.framework.CuratorFramework;
import org.apache.kyuubi.shade.org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.kyuubi.shade.org.apache.curator.retry.ExponentialBackoffRetry;

class ZooKeeperHiveClientHelper {
    private static final Pattern kvPattern = Pattern.compile("([^=;]*)=([^;]*);?");

    ZooKeeperHiveClientHelper() {
    }

    private static String getZooKeeperNamespace(JdbcConnectionParams connParams) {
        String zooKeeperNamespace = connParams.getSessionVars().get("zooKeeperNamespace");
        if (zooKeeperNamespace == null || zooKeeperNamespace.isEmpty()) {
            zooKeeperNamespace = "hiveserver2";
        }
        return zooKeeperNamespace;
    }

    public static boolean isZkDynamicDiscoveryMode(Map<String, String> sessionConf) {
        String discoveryMode = sessionConf.get("serviceDiscoveryMode");
        return "zooKeeper".equalsIgnoreCase(discoveryMode);
    }

    private static CuratorFramework getZkClient(JdbcConnectionParams connParams) {
        String zooKeeperEnsemble = connParams.getZooKeeperEnsemble();
        CuratorFramework zooKeeperClient = CuratorFrameworkFactory.builder().connectString(zooKeeperEnsemble).retryPolicy(new ExponentialBackoffRetry(1000, 3)).build();
        zooKeeperClient.start();
        return zooKeeperClient;
    }

    private static List<String> getServerHosts(JdbcConnectionParams connParams, CuratorFramework zooKeeperClient) throws Exception {
        List serverHosts = (List)zooKeeperClient.getChildren().forPath("/" + ZooKeeperHiveClientHelper.getZooKeeperNamespace(connParams));
        serverHosts.removeAll(connParams.getRejectedHostZnodePaths());
        if (serverHosts.isEmpty()) {
            throw new ZooKeeperHiveClientException("Tried all existing HiveServer2 uris from ZooKeeper.");
        }
        return serverHosts;
    }

    private static void updateParamsWithZKServerNode(JdbcConnectionParams connParams, CuratorFramework zooKeeperClient, String serverNode) throws Exception {
        String zooKeeperNamespace = ZooKeeperHiveClientHelper.getZooKeeperNamespace(connParams);
        connParams.setCurrentHostZnodePath(serverNode);
        String dataStr = new String((byte[])zooKeeperClient.getData().forPath("/" + zooKeeperNamespace + "/" + serverNode), StandardCharsets.UTF_8);
        Matcher matcher = kvPattern.matcher(dataStr);
        if (!matcher.find()) {
            String[] split = dataStr.split(":");
            if (split.length != 2) {
                throw new ZooKeeperHiveClientException("Unable to read HiveServer2 uri from ZooKeeper: " + dataStr);
            }
            connParams.setHost(split[0]);
            connParams.setPort(Integer.parseInt(split[1]));
        } else {
            ZooKeeperHiveClientHelper.applyConfs(dataStr, connParams);
        }
    }

    static void configureConnParams(JdbcConnectionParams connParams) throws ZooKeeperHiveClientException {
        try (CuratorFramework zooKeeperClient = ZooKeeperHiveClientHelper.getZkClient(connParams);){
            List<String> serverHosts = ZooKeeperHiveClientHelper.getServerHosts(connParams, zooKeeperClient);
            String serverNode = serverHosts.get(new Random().nextInt(serverHosts.size()));
            ZooKeeperHiveClientHelper.updateParamsWithZKServerNode(connParams, zooKeeperClient, serverNode);
        }
        catch (Exception e) {
            throw new ZooKeeperHiveClientException("Unable to read HiveServer2 configs from ZooKeeper", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<JdbcConnectionParams> getDirectParamsList(JdbcConnectionParams connParams) throws ZooKeeperHiveClientException {
        try (CuratorFramework zooKeeperClient = ZooKeeperHiveClientHelper.getZkClient(connParams);){
            List<String> serverHosts = ZooKeeperHiveClientHelper.getServerHosts(connParams, zooKeeperClient);
            ArrayList<JdbcConnectionParams> directParamsList = new ArrayList<JdbcConnectionParams>();
            for (String serverNode : serverHosts) {
                JdbcConnectionParams directConnParams = new JdbcConnectionParams(connParams);
                directParamsList.add(directConnParams);
                ZooKeeperHiveClientHelper.updateParamsWithZKServerNode(directConnParams, zooKeeperClient, serverNode);
            }
            ArrayList<JdbcConnectionParams> arrayList = directParamsList;
            return arrayList;
        }
        catch (Exception e) {
            throw new ZooKeeperHiveClientException("Unable to read HiveServer2 configs from ZooKeeper", e);
        }
    }

    private static void applyConfs(String serverConfStr, JdbcConnectionParams connParams) throws Exception {
        Matcher matcher = kvPattern.matcher(serverConfStr);
        while (matcher.find()) {
            if (matcher.group(1) == null) continue;
            if (matcher.group(2) == null) {
                throw new Exception("Null config value for: " + matcher.group(1) + " published by the server.");
            }
            if (matcher.group(1).equals("hive.server2.thrift.bind.host")) {
                connParams.setHost(matcher.group(2));
            }
            if (matcher.group(1).equals("hive.server2.transport.mode") && !connParams.getSessionVars().containsKey("transportMode")) {
                connParams.getSessionVars().put("transportMode", matcher.group(2));
            }
            if (matcher.group(1).equals("hive.server2.thrift.port")) {
                connParams.setPort(Integer.parseInt(matcher.group(2)));
            }
            if (matcher.group(1).equals("hive.server2.thrift.http.port") && connParams.getPort() <= 0) {
                connParams.setPort(Integer.parseInt(matcher.group(2)));
            }
            if (matcher.group(1).equals("hive.server2.thrift.sasl.qop") && !connParams.getSessionVars().containsKey("saslQop")) {
                connParams.getSessionVars().put("saslQop", matcher.group(2));
            }
            if (matcher.group(1).equals("hive.server2.thrift.http.path") && !connParams.getSessionVars().containsKey("httpPath")) {
                connParams.getSessionVars().put("httpPath", matcher.group(2));
            }
            if (matcher.group(1) != null && matcher.group(1).equals("hive.server2.use.SSL") && !connParams.getSessionVars().containsKey("ssl")) {
                connParams.getSessionVars().put("ssl", matcher.group(2));
            }
            if (matcher.group(1).equals("hive.server2.authentication") && matcher.group(2).equalsIgnoreCase("NOSASL") && (!connParams.getSessionVars().containsKey("auth") || !connParams.getSessionVars().get("auth").equalsIgnoreCase("noSasl"))) {
                connParams.getSessionVars().put("auth", "noSasl");
            }
            if (!matcher.group(1).equalsIgnoreCase("hive.server2.authentication.kerberos.principal") || connParams.getSessionVars().containsKey("principal")) continue;
            connParams.getSessionVars().put("principal", matcher.group(2));
        }
    }
}

