/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.DoubleByteHashMap;
import com.carrotsearch.hppc.HashOrderMixing;

public class DoubleByteScatterMap
extends DoubleByteHashMap {
    public DoubleByteScatterMap() {
        this(4);
    }

    public DoubleByteScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public DoubleByteScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(double key) {
        return BitMixer.mixPhi(key);
    }

    public static DoubleByteScatterMap from(double[] keys, byte[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        DoubleByteScatterMap map = new DoubleByteScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

