/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.actions.RewriteStrategy;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.FluentIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.math.LongMath;
import org.apache.iceberg.util.BinPacking;
import org.apache.iceberg.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class BinPackStrategy
implements RewriteStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(BinPackStrategy.class);
    public static final String MIN_INPUT_FILES = "min-input-files";
    public static final int MIN_INPUT_FILES_DEFAULT = 5;
    public static final String MIN_FILE_SIZE_BYTES = "min-file-size-bytes";
    public static final double MIN_FILE_SIZE_DEFAULT_RATIO = 0.75;
    public static final String MAX_FILE_SIZE_BYTES = "max-file-size-bytes";
    public static final double MAX_FILE_SIZE_DEFAULT_RATIO = 1.8;
    public static final String DELETE_FILE_THRESHOLD = "delete-file-threshold";
    public static final int DELETE_FILE_THRESHOLD_DEFAULT = Integer.MAX_VALUE;
    static final long SPLIT_OVERHEAD = 5120L;
    public static final String REWRITE_ALL = "rewrite-all";
    public static final boolean REWRITE_ALL_DEFAULT = false;
    private int minInputFiles;
    private int deleteFileThreshold;
    private long minFileSize;
    private long maxFileSize;
    private long targetFileSize;
    private long maxGroupSize;
    private boolean rewriteAll;

    @Override
    public String name() {
        return "BINPACK";
    }

    @Override
    public Set<String> validOptions() {
        return ImmutableSet.of((Object)MIN_INPUT_FILES, (Object)DELETE_FILE_THRESHOLD, (Object)MIN_FILE_SIZE_BYTES, (Object)MAX_FILE_SIZE_BYTES, (Object)REWRITE_ALL);
    }

    @Override
    public RewriteStrategy options(Map<String, String> options) {
        this.targetFileSize = PropertyUtil.propertyAsLong(options, "target-file-size-bytes", PropertyUtil.propertyAsLong(this.table().properties(), "write.target-file-size-bytes", 0x20000000L));
        this.minFileSize = PropertyUtil.propertyAsLong(options, MIN_FILE_SIZE_BYTES, (long)((double)this.targetFileSize * 0.75));
        this.maxFileSize = PropertyUtil.propertyAsLong(options, MAX_FILE_SIZE_BYTES, (long)((double)this.targetFileSize * 1.8));
        this.maxGroupSize = PropertyUtil.propertyAsLong(options, "max-file-group-size-bytes", 0x1900000000L);
        this.minInputFiles = PropertyUtil.propertyAsInt(options, MIN_INPUT_FILES, 5);
        this.deleteFileThreshold = PropertyUtil.propertyAsInt(options, DELETE_FILE_THRESHOLD, Integer.MAX_VALUE);
        this.rewriteAll = PropertyUtil.propertyAsBoolean(options, REWRITE_ALL, false);
        this.validateOptions();
        return this;
    }

    @Override
    public Iterable<FileScanTask> selectFilesToRewrite(Iterable<FileScanTask> dataFiles) {
        if (this.rewriteAll) {
            LOG.info("Table {} set to rewrite all data files", (Object)this.table().name());
            return dataFiles;
        }
        return FluentIterable.from(dataFiles).filter(scanTask -> scanTask.length() < this.minFileSize || scanTask.length() > this.maxFileSize || this.taskHasTooManyDeletes((FileScanTask)scanTask));
    }

    @Override
    public Iterable<List<FileScanTask>> planFileGroups(Iterable<FileScanTask> dataFiles) {
        BinPacking.ListPacker<FileScanTask> packer = new BinPacking.ListPacker<FileScanTask>(this.maxGroupSize, 1, false);
        List<List<FileScanTask>> potentialGroups = packer.pack(dataFiles, ContentScanTask::length);
        if (this.rewriteAll) {
            return potentialGroups;
        }
        return potentialGroups.stream().filter(group -> group.size() >= this.minInputFiles && group.size() > 1 || this.sizeOfInputFiles((List<FileScanTask>)group) > this.targetFileSize && group.size() > 1 || this.sizeOfInputFiles((List<FileScanTask>)group) > this.maxFileSize || group.stream().anyMatch(this::taskHasTooManyDeletes)).collect(Collectors.toList());
    }

    protected long targetFileSize() {
        return this.targetFileSize;
    }

    protected long numOutputFiles(long totalSizeInBytes) {
        if (totalSizeInBytes < this.targetFileSize) {
            return 1L;
        }
        long fileCountWithRemainder = LongMath.divide((long)totalSizeInBytes, (long)this.targetFileSize, (RoundingMode)RoundingMode.CEILING);
        if (LongMath.mod((long)totalSizeInBytes, (long)this.targetFileSize) > this.minFileSize) {
            return fileCountWithRemainder;
        }
        long fileCountWithoutRemainder = LongMath.divide((long)totalSizeInBytes, (long)this.targetFileSize, (RoundingMode)RoundingMode.FLOOR);
        long avgFileSizeWithoutRemainder = totalSizeInBytes / fileCountWithoutRemainder;
        if ((double)avgFileSizeWithoutRemainder < Math.min(1.1 * (double)this.targetFileSize, (double)this.writeMaxFileSize())) {
            return fileCountWithoutRemainder;
        }
        return fileCountWithRemainder;
    }

    protected long splitSize(long totalSizeInBytes) {
        long estimatedSplitSize = totalSizeInBytes / this.numOutputFiles(totalSizeInBytes) + 5120L;
        return Math.min(estimatedSplitSize, this.writeMaxFileSize());
    }

    protected long inputFileSize(List<FileScanTask> fileToRewrite) {
        return fileToRewrite.stream().mapToLong(ContentScanTask::length).sum();
    }

    protected long writeMaxFileSize() {
        return (long)((double)this.targetFileSize + (double)(this.maxFileSize - this.targetFileSize) * 0.5);
    }

    private long sizeOfInputFiles(List<FileScanTask> group) {
        return group.stream().mapToLong(ContentScanTask::length).sum();
    }

    private boolean taskHasTooManyDeletes(FileScanTask task) {
        return task.deletes() != null && task.deletes().size() >= this.deleteFileThreshold;
    }

    private void validateOptions() {
        Preconditions.checkArgument((this.minFileSize >= 0L ? 1 : 0) != 0, (String)"Cannot set %s to a negative number, %s < 0", (Object)MIN_FILE_SIZE_BYTES, (long)this.minFileSize);
        Preconditions.checkArgument((this.maxFileSize > this.minFileSize ? 1 : 0) != 0, (String)"Cannot set %s greater than or equal to %s, %s >= %s", (Object)MIN_FILE_SIZE_BYTES, (Object)MAX_FILE_SIZE_BYTES, (Object)this.minFileSize, (Object)this.maxFileSize);
        Preconditions.checkArgument((this.targetFileSize > this.minFileSize ? 1 : 0) != 0, (String)"Cannot set %s greater than or equal to %s, all files written will be smaller than the threshold, %s >= %s", (Object)MIN_FILE_SIZE_BYTES, (Object)"target-file-size-bytes", (Object)this.minFileSize, (Object)this.targetFileSize);
        Preconditions.checkArgument((this.targetFileSize < this.maxFileSize ? 1 : 0) != 0, (String)"Cannot set %s is greater than or equal to %s, all files written will be larger than the threshold, %s >= %s", (Object)"target-file-size-bytes", (Object)MAX_FILE_SIZE_BYTES, (Object)this.targetFileSize, (Object)this.maxFileSize);
        Preconditions.checkArgument((this.minInputFiles > 0 ? 1 : 0) != 0, (String)"Cannot set %s is less than 1. All values less than 1 have the same effect as 1. %s < 1", (Object)MIN_INPUT_FILES, (int)this.minInputFiles);
        Preconditions.checkArgument((this.deleteFileThreshold > 0 ? 1 : 0) != 0, (String)"Cannot set %s is less than 1. All values less than 1 have the same effect as 1. %s < 1", (Object)DELETE_FILE_THRESHOLD, (int)this.deleteFileThreshold);
    }
}

