/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.requests;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.util.JsonUtil;

@Deprecated
public class UpdateRequirementParser {
    private static final String TYPE = "type";
    static final String ASSERT_TABLE_UUID = "assert-table-uuid";
    static final String ASSERT_TABLE_DOES_NOT_EXIST = "assert-create";
    static final String ASSERT_REF_SNAPSHOT_ID = "assert-ref-snapshot-id";
    static final String ASSERT_LAST_ASSIGNED_FIELD_ID = "assert-last-assigned-field-id";
    static final String ASSERT_CURRENT_SCHEMA_ID = "assert-current-schema-id";
    static final String ASSERT_LAST_ASSIGNED_PARTITION_ID = "assert-last-assigned-partition-id";
    static final String ASSERT_DEFAULT_SPEC_ID = "assert-default-spec-id";
    static final String ASSERT_DEFAULT_SORT_ORDER_ID = "assert-default-sort-order-id";
    private static final String UUID = "uuid";
    private static final String NAME = "ref";
    private static final String SNAPSHOT_ID = "snapshot-id";
    private static final String LAST_ASSIGNED_FIELD_ID = "last-assigned-field-id";
    private static final String SCHEMA_ID = "current-schema-id";
    private static final String LAST_ASSIGNED_PARTITION_ID = "last-assigned-partition-id";
    private static final String SPEC_ID = "default-spec-id";
    private static final String SORT_ORDER_ID = "default-sort-order-id";
    private static final Map<Class<? extends UpdateTableRequest.UpdateRequirement>, String> TYPES = ImmutableMap.builder().put(UpdateTableRequest.UpdateRequirement.AssertTableUUID.class, (Object)"assert-table-uuid").put(UpdateTableRequest.UpdateRequirement.AssertTableDoesNotExist.class, (Object)"assert-create").put(UpdateTableRequest.UpdateRequirement.AssertRefSnapshotID.class, (Object)"assert-ref-snapshot-id").put(UpdateTableRequest.UpdateRequirement.AssertLastAssignedFieldId.class, (Object)"assert-last-assigned-field-id").put(UpdateTableRequest.UpdateRequirement.AssertCurrentSchemaID.class, (Object)"assert-current-schema-id").put(UpdateTableRequest.UpdateRequirement.AssertLastAssignedPartitionId.class, (Object)"assert-last-assigned-partition-id").put(UpdateTableRequest.UpdateRequirement.AssertDefaultSpecID.class, (Object)"assert-default-spec-id").put(UpdateTableRequest.UpdateRequirement.AssertDefaultSortOrderID.class, (Object)"assert-default-sort-order-id").buildOrThrow();

    private UpdateRequirementParser() {
    }

    public static String toJson(UpdateTableRequest.UpdateRequirement updateRequirement) {
        return UpdateRequirementParser.toJson(updateRequirement, false);
    }

    public static String toJson(UpdateTableRequest.UpdateRequirement updateRequirement, boolean pretty) {
        return JsonUtil.generate(gen -> UpdateRequirementParser.toJson(updateRequirement, gen), pretty);
    }

    public static void toJson(UpdateTableRequest.UpdateRequirement updateRequirement, JsonGenerator generator) throws IOException {
        String requirementType = TYPES.get(updateRequirement.getClass());
        generator.writeStartObject();
        generator.writeStringField(TYPE, requirementType);
        switch (requirementType) {
            case "assert-create": {
                break;
            }
            case "assert-table-uuid": {
                UpdateRequirementParser.writeAssertTableUUID((UpdateTableRequest.UpdateRequirement.AssertTableUUID)updateRequirement, generator);
                break;
            }
            case "assert-ref-snapshot-id": {
                UpdateRequirementParser.writeAssertRefSnapshotId((UpdateTableRequest.UpdateRequirement.AssertRefSnapshotID)updateRequirement, generator);
                break;
            }
            case "assert-last-assigned-field-id": {
                UpdateRequirementParser.writeAssertLastAssignedFieldId((UpdateTableRequest.UpdateRequirement.AssertLastAssignedFieldId)updateRequirement, generator);
                break;
            }
            case "assert-last-assigned-partition-id": {
                UpdateRequirementParser.writeAssertLastAssignedPartitionId((UpdateTableRequest.UpdateRequirement.AssertLastAssignedPartitionId)updateRequirement, generator);
                break;
            }
            case "assert-current-schema-id": {
                UpdateRequirementParser.writeAssertCurrentSchemaId((UpdateTableRequest.UpdateRequirement.AssertCurrentSchemaID)updateRequirement, generator);
                break;
            }
            case "assert-default-spec-id": {
                UpdateRequirementParser.writeAssertDefaultSpecId((UpdateTableRequest.UpdateRequirement.AssertDefaultSpecID)updateRequirement, generator);
                break;
            }
            case "assert-default-sort-order-id": {
                UpdateRequirementParser.writeAssertDefaultSortOrderId((UpdateTableRequest.UpdateRequirement.AssertDefaultSortOrderID)updateRequirement, generator);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Cannot convert update requirement to json. Unrecognized type: %s", requirementType));
            }
        }
        generator.writeEndObject();
    }

    public static UpdateTableRequest.UpdateRequirement fromJson(String json) {
        return JsonUtil.parse(json, UpdateRequirementParser::fromJson);
    }

    public static UpdateTableRequest.UpdateRequirement fromJson(JsonNode jsonNode) {
        String type;
        Preconditions.checkArgument((jsonNode != null && jsonNode.isObject() ? 1 : 0) != 0, (String)"Cannot parse update requirement from non-object value: %s", (Object)jsonNode);
        Preconditions.checkArgument((boolean)jsonNode.hasNonNull(TYPE), (Object)"Cannot parse update requirement. Missing field: type");
        switch (type = JsonUtil.getString(TYPE, jsonNode).toLowerCase(Locale.ROOT)) {
            case "assert-create": {
                return UpdateRequirementParser.readAssertTableDoesNotExist(jsonNode);
            }
            case "assert-table-uuid": {
                return UpdateRequirementParser.readAssertTableUUID(jsonNode);
            }
            case "assert-ref-snapshot-id": {
                return UpdateRequirementParser.readAssertRefSnapshotId(jsonNode);
            }
            case "assert-last-assigned-field-id": {
                return UpdateRequirementParser.readAssertLastAssignedFieldId(jsonNode);
            }
            case "assert-last-assigned-partition-id": {
                return UpdateRequirementParser.readAssertLastAssignedPartitionId(jsonNode);
            }
            case "assert-current-schema-id": {
                return UpdateRequirementParser.readAssertCurrentSchemaId(jsonNode);
            }
            case "assert-default-spec-id": {
                return UpdateRequirementParser.readAssertDefaultSpecId(jsonNode);
            }
            case "assert-default-sort-order-id": {
                return UpdateRequirementParser.readAssertDefaultSortOrderId(jsonNode);
            }
        }
        throw new UnsupportedOperationException(String.format("Unrecognized update requirement. Cannot convert to json: %s", type));
    }

    private static void writeAssertTableUUID(UpdateTableRequest.UpdateRequirement.AssertTableUUID requirement, JsonGenerator gen) throws IOException {
        gen.writeStringField(UUID, requirement.uuid());
    }

    private static void writeAssertRefSnapshotId(UpdateTableRequest.UpdateRequirement.AssertRefSnapshotID requirement, JsonGenerator gen) throws IOException {
        gen.writeStringField(NAME, requirement.refName());
        if (requirement.snapshotId() != null) {
            gen.writeNumberField(SNAPSHOT_ID, requirement.snapshotId().longValue());
        } else {
            gen.writeNullField(SNAPSHOT_ID);
        }
    }

    private static void writeAssertLastAssignedFieldId(UpdateTableRequest.UpdateRequirement.AssertLastAssignedFieldId requirement, JsonGenerator gen) throws IOException {
        gen.writeNumberField(LAST_ASSIGNED_FIELD_ID, requirement.lastAssignedFieldId());
    }

    private static void writeAssertLastAssignedPartitionId(UpdateTableRequest.UpdateRequirement.AssertLastAssignedPartitionId requirement, JsonGenerator gen) throws IOException {
        gen.writeNumberField(LAST_ASSIGNED_PARTITION_ID, requirement.lastAssignedPartitionId());
    }

    private static void writeAssertCurrentSchemaId(UpdateTableRequest.UpdateRequirement.AssertCurrentSchemaID requirement, JsonGenerator gen) throws IOException {
        gen.writeNumberField(SCHEMA_ID, requirement.schemaId());
    }

    private static void writeAssertDefaultSpecId(UpdateTableRequest.UpdateRequirement.AssertDefaultSpecID requirement, JsonGenerator gen) throws IOException {
        gen.writeNumberField(SPEC_ID, requirement.specId());
    }

    private static void writeAssertDefaultSortOrderId(UpdateTableRequest.UpdateRequirement.AssertDefaultSortOrderID requirement, JsonGenerator gen) throws IOException {
        gen.writeNumberField(SORT_ORDER_ID, requirement.sortOrderId());
    }

    private static UpdateTableRequest.UpdateRequirement readAssertTableDoesNotExist(JsonNode node) {
        return new UpdateTableRequest.UpdateRequirement.AssertTableDoesNotExist();
    }

    private static UpdateTableRequest.UpdateRequirement readAssertTableUUID(JsonNode node) {
        String uuid = JsonUtil.getString(UUID, node);
        return new UpdateTableRequest.UpdateRequirement.AssertTableUUID(uuid);
    }

    private static UpdateTableRequest.UpdateRequirement readAssertRefSnapshotId(JsonNode node) {
        String name = JsonUtil.getString(NAME, node);
        Long snapshotId = JsonUtil.getLongOrNull(SNAPSHOT_ID, node);
        return new UpdateTableRequest.UpdateRequirement.AssertRefSnapshotID(name, snapshotId);
    }

    private static UpdateTableRequest.UpdateRequirement readAssertLastAssignedFieldId(JsonNode node) {
        int lastAssignedFieldId = JsonUtil.getInt(LAST_ASSIGNED_FIELD_ID, node);
        return new UpdateTableRequest.UpdateRequirement.AssertLastAssignedFieldId(lastAssignedFieldId);
    }

    private static UpdateTableRequest.UpdateRequirement readAssertCurrentSchemaId(JsonNode node) {
        int schemaId = JsonUtil.getInt(SCHEMA_ID, node);
        return new UpdateTableRequest.UpdateRequirement.AssertCurrentSchemaID(schemaId);
    }

    private static UpdateTableRequest.UpdateRequirement readAssertLastAssignedPartitionId(JsonNode node) {
        int lastAssignedPartitionId = JsonUtil.getInt(LAST_ASSIGNED_PARTITION_ID, node);
        return new UpdateTableRequest.UpdateRequirement.AssertLastAssignedPartitionId(lastAssignedPartitionId);
    }

    private static UpdateTableRequest.UpdateRequirement readAssertDefaultSpecId(JsonNode node) {
        int specId = JsonUtil.getInt(SPEC_ID, node);
        return new UpdateTableRequest.UpdateRequirement.AssertDefaultSpecID(specId);
    }

    private static UpdateTableRequest.UpdateRequirement readAssertDefaultSortOrderId(JsonNode node) {
        int sortOrderId = JsonUtil.getInt(SORT_ORDER_ID, node);
        return new UpdateTableRequest.UpdateRequirement.AssertDefaultSortOrderID(sortOrderId);
    }
}

