/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark.reader;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.spark.reader.KeyedSparkBatchScan;
import org.apache.amoro.spark.reader.UnkeyedSparkBatchScan;
import org.apache.amoro.spark.table.SupportsExtendIdentColumns;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.UnkeyedTable;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.spark.SparkFilters;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.read.SupportsPushDownFilters;
import org.apache.spark.sql.connector.read.SupportsPushDownRequiredColumns;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class SparkScanBuilder
implements ScanBuilder,
SupportsExtendIdentColumns,
SupportsPushDownFilters,
SupportsPushDownRequiredColumns {
    private static final Filter[] NO_FILTERS = new Filter[0];
    private final MixedTable table;
    private final CaseInsensitiveStringMap options;
    private final List<String> metaColumns = Lists.newArrayList();
    private Schema schema = null;
    private StructType requestedProjection;
    private final boolean caseSensitive;
    private List<Expression> filterExpressions = Lists.newArrayList();
    private Filter[] pushedFilters = NO_FILTERS;

    public SparkScanBuilder(SparkSession spark, MixedTable table, CaseInsensitiveStringMap options) {
        this.table = table;
        this.options = options;
        this.caseSensitive = Boolean.parseBoolean(spark.conf().get("spark.sql.caseSensitive"));
    }

    public SparkScanBuilder(SparkSession spark, MixedTable table, CaseInsensitiveStringMap options, Schema schema) {
        this.table = table;
        this.options = options;
        this.schema = schema;
        this.caseSensitive = Boolean.parseBoolean(spark.conf().get("spark.sql.caseSensitive"));
    }

    private Schema lazySchemaWithRowIdent() {
        if (this.schema == null) {
            this.schema = this.requestedProjection != null ? SparkSchemaUtil.prune((Schema)this.table.schema(), (StructType)this.requestedProjection, (Expression)this.filterExpression(), (boolean)this.caseSensitive) : this.table.schema();
        }
        Object icebergTable = this.table.isUnkeyedTable() ? this.table.asUnkeyedTable() : this.table.asKeyedTable().baseTable();
        List fields = this.metaColumns.stream().distinct().map(arg_0 -> SparkScanBuilder.lambda$lazySchemaWithRowIdent$0((UnkeyedTable)icebergTable, arg_0)).collect(Collectors.toList());
        if (fields.size() == 1) {
            return this.schema;
        }
        Schema meta = new Schema(fields);
        return TypeUtil.join((Schema)this.schema, (Schema)meta);
    }

    private Expression filterExpression() {
        if (!this.filterExpressions.isEmpty()) {
            return (Expression)this.filterExpressions.stream().reduce(Expressions.alwaysTrue(), Expressions::and);
        }
        return Expressions.alwaysTrue();
    }

    public Filter[] pushFilters(Filter[] filters) {
        ArrayList expressions = Lists.newArrayListWithExpectedSize((int)filters.length);
        ArrayList pushed = Lists.newArrayListWithExpectedSize((int)filters.length);
        for (Filter filter : filters) {
            Expression expr = SparkFilters.convert((Filter)filter);
            if (expr == null) continue;
            try {
                Binder.bind((Types.StructType)this.table.schema().asStruct(), (Expression)expr, (boolean)this.caseSensitive);
                expressions.add(expr);
                pushed.add(filter);
            }
            catch (ValidationException validationException) {
                // empty catch block
            }
        }
        this.filterExpressions = expressions;
        this.pushedFilters = pushed.toArray(new Filter[0]);
        return filters;
    }

    public Filter[] pushedFilters() {
        return this.pushedFilters;
    }

    public void pruneColumns(StructType requestedSchema) {
        this.requestedProjection = requestedSchema;
    }

    public Scan build() {
        Preconditions.checkArgument((this.table.isKeyedTable() || this.table.isUnkeyedTable() ? 1 : 0) != 0, (Object)("Unable to build scan for table: " + this.table.id().toString() + ", unknown table type"));
        if (this.table.isKeyedTable()) {
            return new KeyedSparkBatchScan(this.table.asKeyedTable(), this.caseSensitive, this.lazySchemaWithRowIdent(), this.filterExpressions, this.options);
        }
        if (this.table.isUnkeyedTable()) {
            return new UnkeyedSparkBatchScan(this.table.asUnkeyedTable(), this.caseSensitive, this.lazySchemaWithRowIdent(), this.filterExpressions, this.options);
        }
        return null;
    }

    @Override
    public SupportsExtendIdentColumns withIdentifierColumns() {
        if (this.table.isUnkeyedTable()) {
            this.metaColumns.addAll(UnkeyedSparkBatchScan.ROW_ID_COLUMNS);
        } else if (this.table.isKeyedTable()) {
            this.metaColumns.addAll(this.table.asKeyedTable().primaryKeySpec().fieldNames());
        }
        return this;
    }

    private static /* synthetic */ Types.NestedField lambda$lazySchemaWithRowIdent$0(UnkeyedTable icebergTable, String column) {
        return MetadataColumns.metadataColumn((Table)icebergTable, (String)column);
    }
}

