/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.RootPaths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RootPathsFluent<A extends RootPathsFluent<A>>
extends BaseFluent<A> {
    private List<String> paths = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public RootPathsFluent() {
    }

    public RootPathsFluent(RootPaths instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RootPaths instance) {
        RootPaths rootPaths = instance = instance != null ? instance : new RootPaths();
        if (instance != null) {
            this.withPaths(instance.getPaths());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToPaths(int index, String item) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        this.paths.add(index, item);
        return (A)((Object)this);
    }

    public A setToPaths(int index, String item) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        this.paths.set(index, item);
        return (A)((Object)this);
    }

    public A addToPaths(String ... items) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        for (String item : items) {
            this.paths.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToPaths(Collection<String> items) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        for (String item : items) {
            this.paths.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromPaths(String ... items) {
        if (this.paths == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.paths.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPaths(Collection<String> items) {
        if (this.paths == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.paths.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public String getPath(int index) {
        return this.paths.get(index);
    }

    public String getFirstPath() {
        return this.paths.get(0);
    }

    public String getLastPath() {
        return this.paths.get(this.paths.size() - 1);
    }

    public String getMatchingPath(Predicate<String> predicate) {
        for (String item : this.paths) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPath(Predicate<String> predicate) {
        for (String item : this.paths) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPaths(List<String> paths) {
        if (paths != null) {
            this.paths = new ArrayList<String>();
            for (String item : paths) {
                this.addToPaths(item);
            }
        } else {
            this.paths = null;
        }
        return (A)((Object)this);
    }

    public A withPaths(String ... paths) {
        if (this.paths != null) {
            this.paths.clear();
            this._visitables.remove((Object)"paths");
        }
        if (paths != null) {
            for (String item : paths) {
                this.addToPaths(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPaths() {
        return this.paths != null && !this.paths.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RootPathsFluent that = (RootPathsFluent)((Object)o);
        if (!Objects.equals(this.paths, that.paths)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.paths, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.paths != null && !this.paths.isEmpty()) {
            sb.append("paths:");
            sb.append(this.paths + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

