/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.plans.physical.Distribution;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.SortExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function1;
import scala.PartialFunction;
import scala.Serializable;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class RemoveRedundantSorts$
extends Rule<SparkPlan> {
    public static RemoveRedundantSorts$ MODULE$;

    static {
        new RemoveRedundantSorts$();
    }

    public SparkPlan apply(SparkPlan plan) {
        return !BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(SQLConf$.MODULE$.REMOVE_REDUNDANT_SORTS_ENABLED())) ? plan : this.removeSorts(plan);
    }

    private SparkPlan removeSorts(SparkPlan plan) {
        return (SparkPlan)plan.transform((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                void var3_9;
                A1 A1 = x1;
                if (A1 instanceof SortExec) {
                    SortExec sortExec = (SortExec)A1;
                    Seq<SortOrder> orders = sortExec.sortOrder();
                    SparkPlan child = sortExec.child();
                    if (SortOrder$.MODULE$.orderingSatisfies(child.outputOrdering(), orders) && child.outputPartitioning().satisfies((Distribution)sortExec.requiredChildDistribution().head())) {
                        SparkPlan sparkPlan = child;
                        return var3_9;
                    }
                }
                Object object = function1.apply(x1);
                return var3_9;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                if (!(sparkPlan instanceof SortExec)) return false;
                SortExec sortExec = (SortExec)sparkPlan;
                Seq<SortOrder> orders = sortExec.sortOrder();
                SparkPlan child = sortExec.child();
                if (!SortOrder$.MODULE$.orderingSatisfies(child.outputOrdering(), orders)) return false;
                if (!child.outputPartitioning().satisfies((Distribution)sortExec.requiredChildDistribution().head())) return false;
                return true;
            }
        });
    }

    private RemoveRedundantSorts$() {
        MODULE$ = this;
    }
}

