/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data;

import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.memory.MemorySegment;

public abstract class AbstractPagedInputView
implements DataInputView {
    private MemorySegment currentSegment;
    private int positionInSegment;
    private int limitInSegment;
    private byte[] utfByteBuffer;
    private char[] utfCharBuffer;

    protected AbstractPagedInputView(MemorySegment initialSegment, int initialLimit) {
        this.positionInSegment = 0;
        this.seekInput(initialSegment, 0, initialLimit);
    }

    protected AbstractPagedInputView() {
    }

    public MemorySegment getCurrentSegment() {
        return this.currentSegment;
    }

    public int getCurrentPositionInSegment() {
        return this.positionInSegment;
    }

    public int getCurrentSegmentLimit() {
        return this.limitInSegment;
    }

    protected abstract MemorySegment nextSegment(MemorySegment var1) throws EOFException, IOException;

    protected abstract int getLimitForSegment(MemorySegment var1);

    public void advance() throws IOException {
        this.doAdvance();
    }

    protected void doAdvance() throws IOException {
        this.currentSegment = this.nextSegment(this.currentSegment);
        this.limitInSegment = this.getLimitForSegment(this.currentSegment);
        this.positionInSegment = 0;
    }

    protected void seekInput(MemorySegment segment, int positionInSegment, int limitInSegment) {
        this.currentSegment = segment;
        this.positionInSegment = positionInSegment;
        this.limitInSegment = limitInSegment;
    }

    protected void clear() {
        this.currentSegment = null;
        this.positionInSegment = 0;
        this.limitInSegment = 0;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int toRead;
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        int remaining = this.limitInSegment - this.positionInSegment;
        if (remaining >= len) {
            this.currentSegment.get(this.positionInSegment, b, off, len);
            this.positionInSegment += len;
            return len;
        }
        if (remaining == 0) {
            try {
                this.advance();
            }
            catch (EOFException eof) {
                return -1;
            }
            remaining = this.limitInSegment - this.positionInSegment;
        }
        int bytesRead = 0;
        while (true) {
            toRead = Math.min(remaining, len - bytesRead);
            this.currentSegment.get(this.positionInSegment, b, off, toRead);
            off += toRead;
            if (len <= (bytesRead += toRead)) break;
            try {
                this.advance();
            }
            catch (EOFException eof) {
                this.positionInSegment += toRead;
                return bytesRead;
            }
            remaining = this.limitInSegment - this.positionInSegment;
        }
        this.positionInSegment += toRead;
        return len;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.read(b, off, len);
        if (bytesRead < len) {
            throw new EOFException("There is no enough data left in the DataInputView.");
        }
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() == 1;
    }

    @Override
    public byte readByte() throws IOException {
        if (this.positionInSegment < this.limitInSegment) {
            return this.currentSegment.get(this.positionInSegment++);
        }
        this.advance();
        return this.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        if (this.positionInSegment < this.limitInSegment - 1) {
            short v = this.currentSegment.getShortBigEndian(this.positionInSegment);
            this.positionInSegment += 2;
            return v;
        }
        if (this.positionInSegment == this.limitInSegment) {
            this.advance();
            return this.readShort();
        }
        return (short)(this.readUnsignedByte() << 8 | this.readUnsignedByte());
    }

    @Override
    public int readUnsignedShort() throws IOException {
        if (this.positionInSegment < this.limitInSegment - 1) {
            int v = this.currentSegment.getShortBigEndian(this.positionInSegment) & 0xFFFF;
            this.positionInSegment += 2;
            return v;
        }
        if (this.positionInSegment == this.limitInSegment) {
            this.advance();
            return this.readUnsignedShort();
        }
        return this.readUnsignedByte() << 8 | this.readUnsignedByte();
    }

    @Override
    public char readChar() throws IOException {
        if (this.positionInSegment < this.limitInSegment - 1) {
            char v = this.currentSegment.getCharBigEndian(this.positionInSegment);
            this.positionInSegment += 2;
            return v;
        }
        if (this.positionInSegment == this.limitInSegment) {
            this.advance();
            return this.readChar();
        }
        return (char)(this.readUnsignedByte() << 8 | this.readUnsignedByte());
    }

    @Override
    public int readInt() throws IOException {
        if (this.positionInSegment < this.limitInSegment - 3) {
            int v = this.currentSegment.getIntBigEndian(this.positionInSegment);
            this.positionInSegment += 4;
            return v;
        }
        if (this.positionInSegment == this.limitInSegment) {
            this.advance();
            return this.readInt();
        }
        return this.readUnsignedByte() << 24 | this.readUnsignedByte() << 16 | this.readUnsignedByte() << 8 | this.readUnsignedByte();
    }

    @Override
    public long readLong() throws IOException {
        if (this.positionInSegment < this.limitInSegment - 7) {
            long v = this.currentSegment.getLongBigEndian(this.positionInSegment);
            this.positionInSegment += 8;
            return v;
        }
        if (this.positionInSegment == this.limitInSegment) {
            this.advance();
            return this.readLong();
        }
        long l = 0L;
        l |= (long)this.readUnsignedByte() << 56;
        l |= (long)this.readUnsignedByte() << 48;
        l |= (long)this.readUnsignedByte() << 40;
        l |= (long)this.readUnsignedByte() << 32;
        l |= (long)this.readUnsignedByte() << 24;
        l |= (long)this.readUnsignedByte() << 16;
        l |= (long)this.readUnsignedByte() << 8;
        return l |= (long)this.readUnsignedByte();
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() throws IOException {
        StringBuilder bld = new StringBuilder(32);
        try {
            int b;
            while ((b = this.readUnsignedByte()) != 10) {
                if (b == 13) continue;
                bld.append((char)b);
            }
        }
        catch (EOFException b) {
            // empty catch block
        }
        if (bld.length() == 0) {
            return null;
        }
        int len = bld.length();
        if (len > 0 && bld.charAt(len - 1) == '\r') {
            bld.setLength(len - 1);
        }
        return bld.toString();
    }

    @Override
    public String readUTF() throws IOException {
        int c;
        int count;
        char[] chararr;
        byte[] bytearr;
        int utflen = this.readUnsignedShort();
        if (this.utfByteBuffer == null || this.utfByteBuffer.length < utflen) {
            bytearr = new byte[utflen];
            this.utfByteBuffer = bytearr;
        } else {
            bytearr = this.utfByteBuffer;
        }
        if (this.utfCharBuffer == null || this.utfCharBuffer.length < utflen) {
            chararr = new char[utflen];
            this.utfCharBuffer = chararr;
        } else {
            chararr = this.utfCharBuffer;
        }
        int chararrCount = 0;
        this.readFully(bytearr, 0, utflen);
        for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararrCount++] = (char)c;
        }
        block6: while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararrCount++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararrCount++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararrCount++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
        return new String(chararr, 0, chararrCount);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int toSkip;
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int remaining = this.limitInSegment - this.positionInSegment;
        if (remaining >= n) {
            this.positionInSegment += n;
            return n;
        }
        if (remaining == 0) {
            try {
                this.advance();
            }
            catch (EOFException eofex) {
                return 0;
            }
            remaining = this.limitInSegment - this.positionInSegment;
        }
        int skipped = 0;
        while (true) {
            toSkip = Math.min(remaining, n);
            skipped += toSkip;
            if ((n -= toSkip) <= 0) break;
            try {
                this.advance();
            }
            catch (EOFException eofex) {
                return skipped;
            }
            remaining = this.limitInSegment - this.positionInSegment;
        }
        this.positionInSegment += toSkip;
        return skipped;
    }

    @Override
    public void skipBytesToRead(int numBytes) throws IOException {
        if (numBytes < 0) {
            throw new IllegalArgumentException();
        }
        int remaining = this.limitInSegment - this.positionInSegment;
        if (remaining >= numBytes) {
            this.positionInSegment += numBytes;
        } else {
            if (remaining == 0) {
                this.advance();
                remaining = this.limitInSegment - this.positionInSegment;
            }
            while (numBytes > remaining) {
                numBytes -= remaining;
                this.advance();
                remaining = this.limitInSegment - this.positionInSegment;
            }
            this.positionInSegment += numBytes;
        }
    }
}

