/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.serializer;

import java.io.IOException;
import java.math.BigDecimal;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.serializer.BinarySerializer;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataOutputView;

public final class DecimalSerializer
implements Serializer<Decimal> {
    private static final long serialVersionUID = 1L;
    private final int precision;
    private final int scale;

    public DecimalSerializer(int precision, int scale) {
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public Decimal copy(Decimal from) {
        return from.copy();
    }

    @Override
    public void serialize(Decimal record, DataOutputView target) throws IOException {
        if (Decimal.isCompact(this.precision)) {
            assert (record.isCompact());
            target.writeLong(record.toUnscaledLong());
        } else {
            byte[] bytes = record.toUnscaledBytes();
            BinarySerializer.INSTANCE.serialize(bytes, target);
        }
    }

    @Override
    public Decimal deserialize(DataInputView source) throws IOException {
        if (Decimal.isCompact(this.precision)) {
            long longVal = source.readLong();
            return Decimal.fromUnscaledLong(longVal, this.precision, this.scale);
        }
        byte[] bytes = BinarySerializer.INSTANCE.deserialize(source);
        return Decimal.fromUnscaledBytes(bytes, this.precision, this.scale);
    }

    @Override
    public String serializeToString(Decimal record) {
        return record.toString();
    }

    @Override
    public Decimal deserializeFromString(String s) {
        return Decimal.fromBigDecimal(new BigDecimal(s), this.precision, this.scale);
    }

    public DecimalSerializer duplicate() {
        return new DecimalSerializer(this.precision, this.scale);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecimalSerializer that = (DecimalSerializer)o;
        return this.precision == that.precision && this.scale == that.scale;
    }

    public int hashCode() {
        int result = this.precision;
        result = 31 * result + this.scale;
        return result;
    }
}

