/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.DataGetters;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.mergetree.compact.MergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.mergetree.compact.aggregate.FieldAggregator;
import org.apache.paimon.options.Options;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeDefaultVisitor;
import org.apache.paimon.types.DateType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.FloatType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.utils.InternalRowUtils;
import org.apache.paimon.utils.Projection;

public class PartialUpdateMergeFunction
implements MergeFunction<KeyValue> {
    public static final String SEQUENCE_GROUP = "sequence-group";
    private final InternalRow.FieldGetter[] getters;
    private final Map<Integer, SequenceGenerator> fieldSequences;
    private final boolean fieldSequenceEnabled;
    private final Map<Integer, FieldAggregator> fieldAggregators;
    private InternalRow currentKey;
    private long latestSequenceNumber;
    private GenericRow row;
    private KeyValue reused;

    protected PartialUpdateMergeFunction(InternalRow.FieldGetter[] getters, Map<Integer, SequenceGenerator> fieldSequences, Map<Integer, FieldAggregator> fieldAggregators, boolean fieldSequenceEnabled) {
        this.getters = getters;
        this.fieldSequences = fieldSequences;
        this.fieldAggregators = fieldAggregators;
        this.fieldSequenceEnabled = fieldSequenceEnabled;
    }

    @Override
    public void reset() {
        this.currentKey = null;
        this.row = new GenericRow(this.getters.length);
        this.fieldAggregators.values().forEach(FieldAggregator::reset);
    }

    @Override
    public void add(KeyValue kv) {
        this.currentKey = kv.key();
        if (kv.valueKind().isRetract()) {
            if (this.fieldSequenceEnabled) {
                this.retractWithSequenceGroup(kv);
                return;
            }
            String msg = String.join((CharSequence)"\n", "By default, Partial update can not accept delete records, you can choose one of the following solutions:", "1. Configure 'ignore-delete' to ignore delete records.", "2. Configure 'sequence-group's to retract partial columns.");
            throw new IllegalArgumentException(msg);
        }
        this.latestSequenceNumber = kv.sequenceNumber();
        if (this.fieldSequences.isEmpty()) {
            this.updateNonNullFields(kv);
        } else {
            this.updateWithSequenceGroup(kv);
        }
    }

    private void updateNonNullFields(KeyValue kv) {
        for (int i = 0; i < this.getters.length; ++i) {
            Object field = this.getters[i].getFieldOrNull(kv.value());
            if (field == null) continue;
            this.row.setField(i, field);
        }
    }

    private void updateWithSequenceGroup(KeyValue kv) {
        for (int i = 0; i < this.getters.length; ++i) {
            Object field = this.getters[i].getFieldOrNull(kv.value());
            SequenceGenerator sequenceGen = this.fieldSequences.get(i);
            FieldAggregator aggregator = this.fieldAggregators.get(i);
            Object accumulator = this.getters[i].getFieldOrNull(this.row);
            if (sequenceGen == null) {
                if (aggregator != null) {
                    this.row.setField(i, aggregator.agg(accumulator, field));
                    continue;
                }
                if (field == null) continue;
                this.row.setField(i, field);
                continue;
            }
            Long currentSeq = sequenceGen.generate(kv.value());
            if (currentSeq == null) continue;
            Long previousSeq = sequenceGen.generate(this.row);
            if (previousSeq == null || currentSeq >= previousSeq) {
                this.row.setField(i, aggregator == null ? field : aggregator.agg(accumulator, field));
                continue;
            }
            if (aggregator == null) continue;
            this.row.setField(i, aggregator.agg(field, accumulator));
        }
    }

    private void retractWithSequenceGroup(KeyValue kv) {
        for (int i = 0; i < this.getters.length; ++i) {
            Object accumulator;
            Long currentSeq;
            SequenceGenerator sequenceGen = this.fieldSequences.get(i);
            if (sequenceGen == null || (currentSeq = sequenceGen.generate(kv.value())) == null) continue;
            Long previousSeq = sequenceGen.generate(this.row);
            FieldAggregator aggregator = this.fieldAggregators.get(i);
            if (previousSeq == null || currentSeq >= previousSeq) {
                if (sequenceGen.index() == i) {
                    this.row.setField(i, this.getters[i].getFieldOrNull(kv.value()));
                    continue;
                }
                if (aggregator == null) {
                    this.row.setField(i, null);
                    continue;
                }
                accumulator = this.getters[i].getFieldOrNull(this.row);
                this.row.setField(i, aggregator.retract(accumulator, this.getters[i].getFieldOrNull(kv.value())));
                continue;
            }
            if (aggregator == null) continue;
            accumulator = this.getters[i].getFieldOrNull(this.row);
            this.row.setField(i, aggregator.retract(accumulator, this.getters[i].getFieldOrNull(kv.value())));
        }
    }

    @Override
    public KeyValue getResult() {
        if (this.reused == null) {
            this.reused = new KeyValue();
        }
        return this.reused.replace(this.currentKey, this.latestSequenceNumber, RowKind.INSERT, this.row);
    }

    public static MergeFunctionFactory<KeyValue> factory(Options options, RowType rowType, List<String> primaryKeys) {
        return new Factory(options, rowType, primaryKeys);
    }

    private static class SequenceGenerator {
        private final int index;
        private final Generator generator;
        private final DataType fieldType;

        private SequenceGenerator(String field, RowType rowType) {
            this.index = rowType.getFieldNames().indexOf(field);
            if (this.index == -1) {
                throw new RuntimeException(String.format("Can not find sequence field %s in table schema: %s", field, rowType));
            }
            this.fieldType = rowType.getTypeAt(this.index);
            this.generator = this.fieldType.accept(new SequenceGeneratorVisitor());
        }

        public SequenceGenerator(int index, DataType dataType) {
            this.index = index;
            this.fieldType = dataType;
            if (index == -1) {
                throw new RuntimeException(String.format("Index : %s is invalid", index));
            }
            this.generator = this.fieldType.accept(new SequenceGeneratorVisitor());
        }

        public int index() {
            return this.index;
        }

        public DataType fieldType() {
            return this.fieldType;
        }

        @Nullable
        public Long generate(InternalRow row) {
            return this.generator.generateNullable(row, this.index);
        }

        private static class SequenceGeneratorVisitor
        extends DataTypeDefaultVisitor<Generator> {
            private SequenceGeneratorVisitor() {
            }

            @Override
            public Generator visit(CharType charType) {
                return this.stringGenerator();
            }

            @Override
            public Generator visit(VarCharType varCharType) {
                return this.stringGenerator();
            }

            private Generator stringGenerator() {
                return (row, i) -> Long.parseLong(row.getString(i).toString());
            }

            @Override
            public Generator visit(DecimalType decimalType) {
                return (row, i) -> InternalRowUtils.castToIntegral(row.getDecimal(i, decimalType.getPrecision(), decimalType.getScale()));
            }

            @Override
            public Generator visit(TinyIntType tinyIntType) {
                return DataGetters::getByte;
            }

            @Override
            public Generator visit(SmallIntType smallIntType) {
                return DataGetters::getShort;
            }

            @Override
            public Generator visit(IntType intType) {
                return DataGetters::getInt;
            }

            @Override
            public Generator visit(BigIntType bigIntType) {
                return DataGetters::getLong;
            }

            @Override
            public Generator visit(FloatType floatType) {
                return (row, i) -> (long)row.getFloat(i);
            }

            @Override
            public Generator visit(DoubleType doubleType) {
                return (row, i) -> (long)row.getDouble(i);
            }

            @Override
            public Generator visit(DateType dateType) {
                return DataGetters::getInt;
            }

            @Override
            public Generator visit(TimestampType timestampType) {
                return (row, i) -> row.getTimestamp(i, timestampType.getPrecision()).getMillisecond();
            }

            @Override
            public Generator visit(LocalZonedTimestampType localZonedTimestampType) {
                return (row, i) -> row.getTimestamp(i, localZonedTimestampType.getPrecision()).getMillisecond();
            }

            @Override
            protected Generator defaultMethod(DataType dataType) {
                throw new UnsupportedOperationException("Unsupported type: " + dataType);
            }
        }

        private static interface Generator {
            public long generate(InternalRow var1, int var2);

            @Nullable
            default public Long generateNullable(InternalRow row, int i) {
                if (row.isNullAt(i)) {
                    return null;
                }
                return this.generate(row, i);
            }
        }
    }

    private static class Factory
    implements MergeFunctionFactory<KeyValue> {
        private static final long serialVersionUID = 1L;
        private final List<DataType> tableTypes;
        private final Map<Integer, SequenceGenerator> fieldSequences;
        private final Map<Integer, FieldAggregator> fieldAggregators;

        private Factory(Options options, RowType rowType, List<String> primaryKeys) {
            this.tableTypes = rowType.getFieldTypes();
            List<String> fieldNames = rowType.getFieldNames();
            this.fieldSequences = new HashMap<Integer, SequenceGenerator>();
            for (Map.Entry<String, String> entry : options.toMap().entrySet()) {
                String k = entry.getKey();
                String v = entry.getValue();
                if (!k.startsWith("fields") || !k.endsWith(PartialUpdateMergeFunction.SEQUENCE_GROUP)) continue;
                String sequenceFieldName = k.substring("fields".length() + 1, k.length() - PartialUpdateMergeFunction.SEQUENCE_GROUP.length() - 1);
                SequenceGenerator sequenceGen = new SequenceGenerator(sequenceFieldName, rowType);
                Arrays.stream(v.split(",")).map(fieldName -> {
                    int field = fieldNames.indexOf(fieldName);
                    if (field == -1) {
                        throw new IllegalArgumentException(String.format("Field %s can not be found in table schema", fieldName));
                    }
                    return field;
                }).forEach(field -> {
                    if (this.fieldSequences.containsKey(field)) {
                        throw new IllegalArgumentException(String.format("Field %s is defined repeatedly by multiple groups: %s", fieldNames.get((int)field), k));
                    }
                    this.fieldSequences.put((Integer)field, sequenceGen);
                });
                this.fieldSequences.put(sequenceGen.index(), sequenceGen);
            }
            this.fieldAggregators = this.createFieldAggregators(rowType, primaryKeys, new CoreOptions(options));
            if (this.fieldAggregators.size() > 0 && this.fieldSequences.isEmpty()) {
                throw new IllegalArgumentException("Must use sequence group for aggregation functions.");
            }
        }

        @Override
        public MergeFunction<KeyValue> create(@Nullable int[][] projection) {
            if (projection != null) {
                int i;
                HashMap<Integer, SequenceGenerator> projectedSequences = new HashMap<Integer, SequenceGenerator>();
                HashMap<Integer, FieldAggregator> projectedAggregators = new HashMap<Integer, FieldAggregator>();
                int[] projects = Projection.of(projection).toTopLevelIndexes();
                HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
                for (i = 0; i < projects.length; ++i) {
                    indexMap.put(projects[i], i);
                }
                this.fieldSequences.forEach((field, sequence) -> {
                    int newField = indexMap.getOrDefault(field, -1);
                    if (newField != -1) {
                        int newSequenceId = indexMap.getOrDefault(sequence.index(), -1);
                        if (newSequenceId == -1) {
                            throw new RuntimeException(String.format("Can not find new sequence field for new field. new field index is %s", newField));
                        }
                        projectedSequences.put(newField, new SequenceGenerator(newSequenceId, sequence.fieldType()));
                    }
                });
                for (i = 0; i < projects.length; ++i) {
                    if (!this.fieldAggregators.containsKey(projects[i])) continue;
                    projectedAggregators.put(i, this.fieldAggregators.get(projects[i]));
                }
                return new PartialUpdateMergeFunction(InternalRowUtils.createFieldGetters(Projection.of(projection).project(this.tableTypes)), projectedSequences, projectedAggregators, !this.fieldSequences.isEmpty());
            }
            return new PartialUpdateMergeFunction(InternalRowUtils.createFieldGetters(this.tableTypes), this.fieldSequences, this.fieldAggregators, !this.fieldSequences.isEmpty());
        }

        @Override
        public MergeFunctionFactory.AdjustedProjection adjustProjection(@Nullable int[][] projection) {
            if (this.fieldSequences.isEmpty()) {
                return new MergeFunctionFactory.AdjustedProjection(projection, null);
            }
            if (projection == null) {
                return new MergeFunctionFactory.AdjustedProjection(null, null);
            }
            LinkedHashSet<Integer> extraFields = new LinkedHashSet<Integer>();
            int[] topProjects = Projection.of(projection).toTopLevelIndexes();
            Set indexSet = Arrays.stream(topProjects).boxed().collect(Collectors.toSet());
            for (int index : topProjects) {
                SequenceGenerator generator = this.fieldSequences.get(index);
                if (generator == null || indexSet.contains(generator.index())) continue;
                extraFields.add(generator.index());
            }
            int[] allProjects = Stream.concat(Arrays.stream(topProjects).boxed(), extraFields.stream()).mapToInt(Integer::intValue).toArray();
            int[][] pushdown = Projection.of(allProjects).toNestedIndexes();
            int[][] outer = Projection.of(IntStream.range(0, topProjects.length).toArray()).toNestedIndexes();
            return new MergeFunctionFactory.AdjustedProjection(pushdown, outer);
        }

        private Map<Integer, FieldAggregator> createFieldAggregators(RowType rowType, List<String> primaryKeys, CoreOptions options) {
            List<String> fieldNames = rowType.getFieldNames();
            List<DataType> fieldTypes = rowType.getFieldTypes();
            HashMap<Integer, FieldAggregator> fieldAggregators = new HashMap<Integer, FieldAggregator>();
            for (int i = 0; i < fieldNames.size(); ++i) {
                String fieldName = fieldNames.get(i);
                DataType fieldType = fieldTypes.get(i);
                boolean isPrimaryKey = primaryKeys.contains(fieldName);
                String strAggFunc = options.fieldAggFunc(fieldName);
                boolean ignoreRetract = options.fieldAggIgnoreRetract(fieldName);
                if (strAggFunc == null) continue;
                fieldAggregators.put(i, FieldAggregator.createFieldAggregator(fieldType, strAggFunc, ignoreRetract, isPrimaryKey, options, fieldName));
            }
            return fieldAggregators;
        }
    }
}

