/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server;

import io.javalin.Javalin;
import io.javalin.http.HttpCode;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.amoro.api.AmoroTableMetastore;
import org.apache.amoro.api.OptimizingService;
import org.apache.amoro.api.config.ConfigHelpers;
import org.apache.amoro.api.config.Configurations;
import org.apache.amoro.server.AmoroManagementConf;
import org.apache.amoro.server.AmoroManagementConfValidator;
import org.apache.amoro.server.DefaultOptimizingService;
import org.apache.amoro.server.Environments;
import org.apache.amoro.server.HighAvailabilityContainer;
import org.apache.amoro.server.RestCatalogService;
import org.apache.amoro.server.TableManagementService;
import org.apache.amoro.server.dashboard.DashboardServer;
import org.apache.amoro.server.dashboard.response.ErrorResponse;
import org.apache.amoro.server.dashboard.utils.AmsUtil;
import org.apache.amoro.server.dashboard.utils.CommonUtil;
import org.apache.amoro.server.exception.AmoroRuntimeException;
import org.apache.amoro.server.manager.EventsManager;
import org.apache.amoro.server.manager.MetricManager;
import org.apache.amoro.server.persistence.SqlSessionFactoryProvider;
import org.apache.amoro.server.resource.ContainerMetadata;
import org.apache.amoro.server.resource.OptimizerManager;
import org.apache.amoro.server.resource.ResourceContainers;
import org.apache.amoro.server.table.DefaultTableService;
import org.apache.amoro.server.table.RuntimeHandlerChain;
import org.apache.amoro.server.table.TableService;
import org.apache.amoro.server.table.executor.AsyncTableExecutors;
import org.apache.amoro.server.terminal.TerminalManager;
import org.apache.amoro.server.utils.ThriftServiceProxy;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.guava32.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.amoro.shade.thrift.org.apache.thrift.TMultiplexedProcessor;
import org.apache.amoro.shade.thrift.org.apache.thrift.TProcessor;
import org.apache.amoro.shade.thrift.org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.amoro.shade.thrift.org.apache.thrift.protocol.TProtocolFactory;
import org.apache.amoro.shade.thrift.org.apache.thrift.server.TServer;
import org.apache.amoro.shade.thrift.org.apache.thrift.server.TThreadedSelectorServer;
import org.apache.amoro.shade.thrift.org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.amoro.shade.thrift.org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.amoro.shade.thrift.org.apache.thrift.transport.TTransportException;
import org.apache.amoro.shade.thrift.org.apache.thrift.transport.TTransportFactory;
import org.apache.amoro.shade.thrift.org.apache.thrift.transport.layered.TFramedTransport;
import org.apache.amoro.utils.JacksonUtil;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.server.session.SessionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class AmoroServiceContainer {
    public static final Logger LOG = LoggerFactory.getLogger(AmoroServiceContainer.class);
    public static final String SERVER_CONFIG_FILENAME = "config.yaml";
    private final HighAvailabilityContainer haContainer;
    private DefaultTableService tableService;
    private DefaultOptimizingService optimizingService;
    private TerminalManager terminalManager;
    private Configurations serviceConfig;
    private TServer tableManagementServer;
    private TServer optimizingServiceServer;
    private Javalin httpServer;

    public AmoroServiceContainer() throws Exception {
        this.initConfig();
        this.haContainer = new HighAvailabilityContainer(this.serviceConfig);
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        try {
            service = new AmoroServiceContainer();
            while (true) lbl-1000:
            // 4 sources

            {
                try {
                    service.waitLeaderShip();
                    service.startService();
                    service.waitFollowerShip();
                }
                catch (Exception e) {
                    AmoroServiceContainer.LOG.error("AMS start error", (Throwable)e);
                }
                finally {
                    service.dispose();
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            AmoroServiceContainer.LOG.error("AMS encountered an unknown exception, will exist", t);
            System.exit(1);
            return;
        }
        ** GOTO lbl-1000
    }

    public void waitLeaderShip() throws Exception {
        this.haContainer.waitLeaderShip();
    }

    public void waitFollowerShip() throws Exception {
        this.haContainer.waitFollowerShip();
    }

    public void startService() throws Exception {
        EventsManager.getInstance();
        MetricManager.getInstance();
        this.tableService = new DefaultTableService(this.serviceConfig);
        this.optimizingService = new DefaultOptimizingService(this.serviceConfig, this.tableService);
        LOG.info("Setting up AMS table executors...");
        AsyncTableExecutors.getInstance().setup(this.tableService, this.serviceConfig);
        this.addHandlerChain(this.optimizingService.getTableRuntimeHandler());
        this.addHandlerChain(AsyncTableExecutors.getInstance().getDataExpiringExecutor());
        this.addHandlerChain(AsyncTableExecutors.getInstance().getSnapshotsExpiringExecutor());
        this.addHandlerChain(AsyncTableExecutors.getInstance().getOrphanFilesCleaningExecutor());
        this.addHandlerChain(AsyncTableExecutors.getInstance().getDanglingDeleteFilesCleaningExecutor());
        this.addHandlerChain(AsyncTableExecutors.getInstance().getOptimizingCommitExecutor());
        this.addHandlerChain(AsyncTableExecutors.getInstance().getOptimizingExpiringExecutor());
        this.addHandlerChain(AsyncTableExecutors.getInstance().getBlockerExpiringExecutor());
        this.addHandlerChain(AsyncTableExecutors.getInstance().getHiveCommitSyncExecutor());
        this.addHandlerChain(AsyncTableExecutors.getInstance().getTableRefreshingExecutor());
        this.addHandlerChain(AsyncTableExecutors.getInstance().getTagsAutoCreatingExecutor());
        this.tableService.initialize();
        LOG.info("AMS table service have been initialized");
        this.terminalManager = new TerminalManager(this.serviceConfig, this.tableService);
        this.initThriftService();
        this.startThriftService();
        this.initHttpService();
        this.startHttpService();
    }

    private void addHandlerChain(RuntimeHandlerChain chain) {
        if (chain != null) {
            this.tableService.addHandlerChain(chain);
        }
    }

    public void dispose() {
        if (this.tableManagementServer != null) {
            this.tableManagementServer.stop();
        }
        if (this.optimizingServiceServer != null) {
            this.optimizingServiceServer.stop();
        }
        if (this.httpServer != null) {
            this.httpServer.stop();
        }
        if (this.tableService != null) {
            this.tableService.dispose();
            this.tableService = null;
        }
        if (this.terminalManager != null) {
            this.terminalManager.dispose();
            this.terminalManager = null;
        }
        this.optimizingService = null;
        EventsManager.dispose();
        MetricManager.dispose();
    }

    private void initConfig() throws IOException {
        LOG.info("initializing configurations...");
        new ConfigurationHelper().init();
    }

    private void startThriftService() {
        this.startThriftServer(this.tableManagementServer, "thrift-table-management-server-thread");
        this.startThriftServer(this.optimizingServiceServer, "thrift-optimizing-server-thread");
    }

    private void startThriftServer(TServer server, String threadName) {
        Thread thread = new Thread(() -> ((TServer)server).serve(), threadName);
        thread.setDaemon(true);
        thread.start();
        LOG.info("{} has been started", (Object)threadName);
    }

    private void initHttpService() {
        DashboardServer dashboardServer = new DashboardServer(this.serviceConfig, this.tableService, this.optimizingService, this.terminalManager);
        RestCatalogService restCatalogService = new RestCatalogService(this.tableService);
        this.httpServer = Javalin.create(config -> {
            config.addStaticFiles(dashboardServer.configStaticFiles());
            config.sessionHandler(SessionHandler::new);
            config.enableCorsForAllOrigins();
            config.showJavalinBanner = false;
        });
        this.httpServer.routes(() -> {
            dashboardServer.endpoints().addEndpoints();
            restCatalogService.endpoints().addEndpoints();
        });
        this.httpServer.before(ctx -> {
            String token = ctx.queryParam("token");
            if (StringUtils.isNotEmpty((CharSequence)token)) {
                CommonUtil.checkSinglePageToken(ctx);
            } else {
                dashboardServer.preHandleRequest(ctx);
            }
        });
        this.httpServer.exception(Exception.class, (e, ctx) -> {
            if (restCatalogService.needHandleException(ctx)) {
                restCatalogService.handleException(e, ctx);
            } else {
                dashboardServer.handleException(e, ctx);
            }
        });
        this.httpServer.error(HttpCode.NOT_FOUND.getStatus(), ctx -> {
            if (!restCatalogService.needHandleException(ctx)) {
                ctx.json((Object)new ErrorResponse(HttpCode.NOT_FOUND, "page not found!", ""));
            }
        });
        this.httpServer.error(HttpCode.INTERNAL_SERVER_ERROR.getStatus(), ctx -> {
            if (!restCatalogService.needHandleException(ctx)) {
                ctx.json((Object)new ErrorResponse(HttpCode.INTERNAL_SERVER_ERROR, "internal error!", ""));
            }
        });
    }

    private void startHttpService() {
        int port = this.serviceConfig.getInteger(AmoroManagementConf.HTTP_SERVER_PORT);
        this.httpServer.start(port);
        LOG.info("\n    ___     __  ___ ____   ____   ____ \n   /   |   /  |/  // __ \\ / __ \\ / __ \\\n  / /| |  / /|_/ // / / // /_/ // / / /\n / ___ | / /  / // /_/ // _, _// /_/ / \n/_/  |_|/_/  /_/ \\____//_/ |_| \\____/  \n                                       \n      https://amoro.apache.org/       \n");
        LOG.info("Http server start at {}.", (Object)port);
    }

    private void initThriftService() throws TTransportException {
        LOG.info("Initializing thrift service...");
        long maxMessageSize = this.serviceConfig.getLong(AmoroManagementConf.THRIFT_MAX_MESSAGE_SIZE);
        int selectorThreads = this.serviceConfig.getInteger(AmoroManagementConf.THRIFT_SELECTOR_THREADS);
        int workerThreads = this.serviceConfig.getInteger(AmoroManagementConf.THRIFT_WORKER_THREADS);
        int queueSizePerSelector = this.serviceConfig.getInteger(AmoroManagementConf.THRIFT_QUEUE_SIZE_PER_THREAD);
        String bindHost = this.serviceConfig.getString(AmoroManagementConf.SERVER_BIND_HOST);
        AmoroTableMetastore.Processor tableManagementProcessor = new AmoroTableMetastore.Processor((AmoroTableMetastore.Iface)ThriftServiceProxy.createProxy(AmoroTableMetastore.Iface.class, new TableManagementService(this.tableService), AmoroRuntimeException::normalizeCompatibly));
        this.tableManagementServer = this.createThriftServer((TProcessor)tableManagementProcessor, "TableMetastore", bindHost, this.serviceConfig.getInteger(AmoroManagementConf.TABLE_SERVICE_THRIFT_BIND_PORT), Executors.newFixedThreadPool(workerThreads, this.getThriftThreadFactory("TableMetastore")), selectorThreads, queueSizePerSelector, maxMessageSize);
        OptimizingService.Processor optimizingProcessor = new OptimizingService.Processor((OptimizingService.Iface)ThriftServiceProxy.createProxy(OptimizingService.Iface.class, this.optimizingService, AmoroRuntimeException::normalize));
        this.optimizingServiceServer = this.createThriftServer((TProcessor)optimizingProcessor, "OptimizeManager", bindHost, this.serviceConfig.getInteger(AmoroManagementConf.OPTIMIZING_SERVICE_THRIFT_BIND_PORT), Executors.newCachedThreadPool(this.getThriftThreadFactory("OptimizeManager")), selectorThreads, queueSizePerSelector, maxMessageSize);
    }

    private TServer createThriftServer(TProcessor processor, String processorName, String bindHost, int port, ExecutorService executorService, int selectorThreads, int queueSizePerSelector, long maxMessageSize) throws TTransportException {
        LOG.info("Initializing thrift server: {}", (Object)processorName);
        LOG.info("Starting {} thrift server on port: {}", (Object)processorName, (Object)port);
        TNonblockingServerSocket serverTransport = this.getServerSocket(bindHost, port);
        TBinaryProtocol.Factory protocolFactory = new TBinaryProtocol.Factory();
        TBinaryProtocol.Factory inputProtoFactory = new TBinaryProtocol.Factory(true, true, maxMessageSize, maxMessageSize);
        TFramedTransport.Factory transportFactory = new TFramedTransport.Factory();
        TMultiplexedProcessor multiplexedProcessor = new TMultiplexedProcessor();
        multiplexedProcessor.registerProcessor(processorName, processor);
        TThreadedSelectorServer.Args args = ((TThreadedSelectorServer.Args)((TThreadedSelectorServer.Args)((TThreadedSelectorServer.Args)((TThreadedSelectorServer.Args)new TThreadedSelectorServer.Args((TNonblockingServerTransport)serverTransport).processor((TProcessor)multiplexedProcessor)).transportFactory((TTransportFactory)transportFactory)).protocolFactory((TProtocolFactory)protocolFactory)).inputProtocolFactory((TProtocolFactory)inputProtoFactory)).executorService(executorService).selectorThreads(selectorThreads).acceptQueueSizePerThread(queueSizePerSelector);
        LOG.info("The number of selector threads for the {} thrift server is: {}", (Object)processorName, (Object)selectorThreads);
        LOG.info("The size of per-selector queue for the {} thrift server is: {}", (Object)processorName, (Object)queueSizePerSelector);
        return new TThreadedSelectorServer(args);
    }

    private ThreadFactory getThriftThreadFactory(String processorName) {
        return new ThreadFactoryBuilder().setDaemon(false).setNameFormat("thrift-server-" + String.join((CharSequence)"-", StringUtils.splitByCharacterTypeCamelCase((String)processorName)).toLowerCase(Locale.ROOT) + "-%d").build();
    }

    private TNonblockingServerSocket getServerSocket(String bindHost, int portNum) throws TTransportException {
        InetSocketAddress serverAddress = new InetSocketAddress(bindHost, portNum);
        return new TNonblockingServerSocket(serverAddress);
    }

    private void expandConfigMap(Map<String, Object> config, String prefix, Map<String, Object> result) {
        for (Map.Entry<String, Object> entry : config.entrySet()) {
            String fullKey;
            String key = entry.getKey();
            Object value = entry.getValue();
            String string = fullKey = prefix.isEmpty() ? key : prefix + "." + key;
            if (value instanceof Map) {
                Map subMap = (Map)value;
                this.expandConfigMap(subMap, fullKey, result);
                continue;
            }
            result.put(fullKey, value);
        }
    }

    @VisibleForTesting
    public TableService getTableService() {
        return this.tableService;
    }

    @VisibleForTesting
    public OptimizerManager getOptimizingService() {
        return this.optimizingService;
    }

    private class ConfigurationHelper {
        private JsonNode yamlConfig;

        private ConfigurationHelper() {
        }

        public void init() throws IOException {
            Map<String, Object> envConfig = this.initEnvConfig();
            this.initServiceConfig(envConfig);
            this.setIcebergSystemProperties();
            this.initContainerConfig();
        }

        private void initServiceConfig(Map<String, Object> envConfig) throws IOException {
            LOG.info("initializing service configuration...");
            String configPath = Environments.getConfigPath() + "/" + AmoroServiceContainer.SERVER_CONFIG_FILENAME;
            LOG.info("load config from path: {}", (Object)configPath);
            this.yamlConfig = JacksonUtil.fromObjects((Object)new Yaml().loadAs(Files.newInputStream(Paths.get(configPath, new String[0]), new OpenOption[0]), Map.class));
            Map systemConfig = JacksonUtil.getMap((JsonNode)this.yamlConfig, (String)"ams", (TypeReference)new TypeReference<Map<String, Object>>(){});
            HashMap expandedConfigurationMap = Maps.newHashMap();
            AmoroServiceContainer.this.expandConfigMap(systemConfig, "", expandedConfigurationMap);
            expandedConfigurationMap.putAll(envConfig);
            AmoroServiceContainer.this.serviceConfig = Configurations.fromObjectMap((Map)expandedConfigurationMap);
            AmoroManagementConfValidator.validateConfig(AmoroServiceContainer.this.serviceConfig);
            SqlSessionFactoryProvider.getInstance().init(AmoroServiceContainer.this.serviceConfig);
        }

        private Map<String, Object> initEnvConfig() {
            LOG.info("initializing system env configuration...");
            String prefix = "ams".toUpperCase();
            return ConfigHelpers.convertConfigurationKeys((String)prefix, System.getenv());
        }

        private void setIcebergSystemProperties() {
            int workerThreadPoolSize = Math.max(Runtime.getRuntime().availableProcessors(), AmoroServiceContainer.this.serviceConfig.getInteger(AmoroManagementConf.TABLE_MANIFEST_IO_THREAD_COUNT));
            System.setProperty("iceberg.worker.num-threads", String.valueOf(workerThreadPoolSize));
        }

        private void initContainerConfig() {
            LOG.info("initializing container configuration...");
            JsonNode containers = this.yamlConfig.get("containers");
            ArrayList<ContainerMetadata> containerList = new ArrayList<ContainerMetadata>();
            if (containers != null && containers.isArray()) {
                for (JsonNode containerConfig : containers) {
                    ContainerMetadata container = new ContainerMetadata(containerConfig.get("name").asText(), containerConfig.get("container-impl").asText());
                    HashMap<String, String> containerProperties = new HashMap<String, String>(JacksonUtil.getMap((JsonNode)containerConfig, (String)"properties", (TypeReference)new TypeReference<Map<String, String>>(){}));
                    containerProperties.put("ams-home", Environments.getHomePath());
                    containerProperties.putIfAbsent("ams-optimizing-uri", AmsUtil.getAMSThriftAddress(AmoroServiceContainer.this.serviceConfig, "OptimizeManager"));
                    container.setProperties(containerProperties);
                    containerList.add(container);
                }
            }
            ResourceContainers.init(containerList);
        }
    }
}

