/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.catalog;

import java.util.List;
import org.apache.amoro.AmoroTable;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.formats.mixed.MixedTable;
import org.apache.amoro.hive.CachedHiveClientPool;
import org.apache.amoro.hive.HMSClient;
import org.apache.amoro.hive.catalog.MixedHiveTables;
import org.apache.amoro.server.catalog.InternalCatalog;
import org.apache.amoro.server.persistence.mapper.TableMetaMapper;
import org.apache.amoro.server.table.TableMetadata;
import org.apache.amoro.server.table.internal.InternalTableCreator;
import org.apache.amoro.server.table.internal.InternalTableHandler;
import org.apache.amoro.utils.MixedCatalogUtil;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.thrift.TException;

public class MixedHiveCatalogImpl
extends InternalCatalog {
    protected MixedHiveTables tables;
    private volatile CachedHiveClientPool hiveClientPool;

    protected MixedHiveCatalogImpl(CatalogMeta catalogMeta) {
        super(catalogMeta);
        this.tables = new MixedHiveTables(catalogMeta.getCatalogProperties(), MixedCatalogUtil.buildMetaStore((CatalogMeta)catalogMeta));
        this.hiveClientPool = this.tables().getHiveClientPool();
    }

    @Override
    public void updateMetadata(CatalogMeta metadata) {
        super.updateMetadata(metadata);
        this.hiveClientPool = this.tables().getHiveClientPool();
        this.tables = new MixedHiveTables(metadata.getCatalogProperties(), MixedCatalogUtil.buildMetaStore((CatalogMeta)metadata));
    }

    @Override
    public AmoroTable<?> loadTable(String database, String tableName) {
        TableMetadata tableMetadata = this.getAs(TableMetaMapper.class, mapper -> mapper.selectTableMetaByName(this.getMetadata().getCatalogName(), database, tableName));
        if (tableMetadata == null) {
            return null;
        }
        return new MixedTable(this.tables.loadTableByMeta(tableMetadata.buildTableMeta()), TableFormat.MIXED_HIVE);
    }

    @Override
    public void createDatabase(String databaseName) {
    }

    @Override
    public void dropDatabase(String databaseName) {
    }

    @Override
    public InternalTableCreator newTableCreator(String database, String tableName, TableFormat format, CreateTableRequest creatorArguments) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <O> InternalTableHandler<O> newTableHandler(String database, String tableName) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void decreaseDatabaseTableCount(String databaseName) {
    }

    @Override
    protected void increaseDatabaseTableCount(String databaseName) {
    }

    @Override
    public boolean databaseExists(String database) {
        try {
            return (Boolean)this.hiveClientPool.run(client -> {
                try {
                    client.getDatabase(database);
                    return true;
                }
                catch (NoSuchObjectException exception) {
                    return false;
                }
            });
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException("Failed to get databases", e);
        }
    }

    @Override
    public List<String> listDatabases() {
        try {
            return (List)this.hiveClientPool.run(HMSClient::getAllDatabases);
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException("Failed to list databases", e);
        }
    }

    public CachedHiveClientPool getHiveClient() {
        return this.hiveClientPool;
    }

    private MixedHiveTables tables() {
        return this.tables;
    }
}

