/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard;

import io.javalin.apibuilder.ApiBuilder;
import io.javalin.apibuilder.EndpointGroup;
import io.javalin.core.security.BasicAuthCredentials;
import io.javalin.http.ContentType;
import io.javalin.http.Context;
import io.javalin.http.HttpCode;
import io.javalin.http.staticfiles.Location;
import io.javalin.http.staticfiles.StaticFileConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.amoro.api.config.Configurations;
import org.apache.amoro.server.AmoroManagementConf;
import org.apache.amoro.server.DefaultOptimizingService;
import org.apache.amoro.server.dashboard.APITokenManager;
import org.apache.amoro.server.dashboard.PlatformFileManager;
import org.apache.amoro.server.dashboard.ServerTableDescriptor;
import org.apache.amoro.server.dashboard.controller.CatalogController;
import org.apache.amoro.server.dashboard.controller.HealthCheckController;
import org.apache.amoro.server.dashboard.controller.LoginController;
import org.apache.amoro.server.dashboard.controller.OptimizerController;
import org.apache.amoro.server.dashboard.controller.PlatformFileInfoController;
import org.apache.amoro.server.dashboard.controller.SettingController;
import org.apache.amoro.server.dashboard.controller.TableController;
import org.apache.amoro.server.dashboard.controller.TerminalController;
import org.apache.amoro.server.dashboard.controller.VersionController;
import org.apache.amoro.server.dashboard.response.ErrorResponse;
import org.apache.amoro.server.dashboard.utils.ParamSignatureCalculator;
import org.apache.amoro.server.exception.ForbiddenException;
import org.apache.amoro.server.exception.SignatureCheckException;
import org.apache.amoro.server.table.TableService;
import org.apache.amoro.server.terminal.TerminalManager;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashboardServer {
    public static final Logger LOG = LoggerFactory.getLogger(DashboardServer.class);
    private static final String AUTH_TYPE_BASIC = "basic";
    private final CatalogController catalogController;
    private final HealthCheckController healthCheckController;
    private final LoginController loginController;
    private final OptimizerController optimizerController;
    private final PlatformFileInfoController platformFileInfoController;
    private final SettingController settingController;
    private final TableController tableController;
    private final TerminalController terminalController;
    private final VersionController versionController;
    private final String authType;
    private final String basicAuthUser;
    private final String basicAuthPassword;
    private String indexHtml = "";
    private static final String[] urlWhiteList = new String[]{"/ams/v1/versionInfo", "/ams/v1/login", "/ams/v1/health/status", "/ams/v1/login/current", "/", "/overview", "/introduce", "/tables", "/optimizers", "/login", "/terminal", "/hive-tables/upgrade", "/hive-tables", "/index.html", "/favicon.ico", "/assets/*", "/api/iceberg/rest/*"};

    public DashboardServer(Configurations serviceConfig, TableService tableService, DefaultOptimizingService optimizerManager, TerminalManager terminalManager) {
        PlatformFileManager platformFileManager = new PlatformFileManager();
        this.catalogController = new CatalogController(tableService, platformFileManager);
        this.healthCheckController = new HealthCheckController();
        this.loginController = new LoginController(serviceConfig);
        this.optimizerController = new OptimizerController(tableService, optimizerManager);
        this.platformFileInfoController = new PlatformFileInfoController(platformFileManager);
        this.settingController = new SettingController(serviceConfig, optimizerManager);
        ServerTableDescriptor tableDescriptor = new ServerTableDescriptor(tableService, serviceConfig);
        this.tableController = new TableController(tableService, tableDescriptor, serviceConfig);
        this.terminalController = new TerminalController(terminalManager);
        this.versionController = new VersionController();
        this.authType = (String)serviceConfig.get(AmoroManagementConf.HTTP_SERVER_REST_AUTH_TYPE);
        this.basicAuthUser = (String)serviceConfig.get(AmoroManagementConf.ADMIN_USERNAME);
        this.basicAuthPassword = (String)serviceConfig.get(AmoroManagementConf.ADMIN_PASSWORD);
    }

    public String getIndexFileContent() {
        try {
            if ("".equals(this.indexHtml)) {
                try (InputStream fileName = DashboardServer.class.getClassLoader().getResourceAsStream("static/index.html");){
                    Preconditions.checkNotNull((Object)fileName, (Object)"Cannot find index file.");
                    try (InputStreamReader isr = new InputStreamReader(fileName, StandardCharsets.UTF_8.newDecoder());
                         BufferedReader br = new BufferedReader(isr);){
                        String line;
                        StringBuilder sb = new StringBuilder();
                        while ((line = br.readLine()) != null) {
                            sb.append(line);
                        }
                        this.indexHtml = sb.toString();
                    }
                }
            }
            return this.indexHtml;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Load index html filed", e);
        }
    }

    public Consumer<StaticFileConfig> configStaticFiles() {
        return staticFiles -> {
            staticFiles.hostedPath = "/";
            staticFiles.directory = "/static";
            staticFiles.location = Location.CLASSPATH;
            staticFiles.precompress = false;
            staticFiles.aliasCheck = null;
            staticFiles.skipFileFunction = req -> false;
        };
    }

    public EndpointGroup endpoints() {
        return () -> {
            ApiBuilder.path((String)"", () -> {
                ApiBuilder.get((String)"/{page}", ctx -> {
                    String fileName = ctx.pathParam("page");
                    if (fileName.endsWith("ico")) {
                        ctx.contentType(ContentType.IMAGE_ICO);
                        ctx.result(Objects.requireNonNull(DashboardServer.class.getClassLoader().getResourceAsStream("static/" + fileName)));
                    } else {
                        ctx.html(this.getIndexFileContent());
                    }
                });
                ApiBuilder.get((String)"/hive-tables/upgrade", ctx -> ctx.html(this.getIndexFileContent()));
            });
            ApiBuilder.path((String)"/ams/v1", () -> {
                ApiBuilder.get((String)"/login/current", this.loginController::getCurrent);
                ApiBuilder.post((String)"/login", this.loginController::login);
                ApiBuilder.post((String)"/logout", this.loginController::logout);
            });
            ApiBuilder.path((String)"ams/v1", (EndpointGroup)this.apiGroup());
            ApiBuilder.path((String)"/api/ams/v1", (EndpointGroup)this.apiGroup());
        };
    }

    private EndpointGroup apiGroup() {
        return () -> {
            ApiBuilder.path((String)"/tables", () -> {
                ApiBuilder.get((String)"/catalogs/{catalog}/dbs/{db}/tables/{table}/details", this.tableController::getTableDetail);
                ApiBuilder.get((String)"/catalogs/{catalog}/dbs/{db}/tables/{table}/hive/details", this.tableController::getHiveTableDetail);
                ApiBuilder.post((String)"/catalogs/{catalog}/dbs/{db}/tables/{table}/upgrade", this.tableController::upgradeHiveTable);
                ApiBuilder.get((String)"/catalogs/{catalog}/dbs/{db}/tables/{table}/upgrade/status", this.tableController::getUpgradeStatus);
                ApiBuilder.get((String)"/catalogs/{catalog}/dbs/{db}/tables/{table}/optimizing-processes", this.tableController::getOptimizingProcesses);
                ApiBuilder.get((String)"/catalogs/{catalog}/dbs/{db}/tables/{table}/optimizing-processes/{processId}/tasks", this.tableController::getOptimizingProcessTasks);
                ApiBuilder.get((String)"/catalogs/{catalog}/dbs/{db}/tables/{table}/snapshots", this.tableController::getTableSnapshots);
                ApiBuilder.get((String)"/catalogs/{catalog}/dbs/{db}/tables/{table}/snapshots/{snapshotId}/detail", this.tableController::getSnapshotDetail);
                ApiBuilder.get((String)"/catalogs/{catalog}/dbs/{db}/tables/{table}/partitions", this.tableController::getTablePartitions);
                ApiBuilder.get((String)"/catalogs/{catalog}/dbs/{db}/tables/{table}/partitions/{partition}/files", this.tableController::getPartitionFileListInfo);
                ApiBuilder.get((String)"/catalogs/{catalog}/dbs/{db}/tables/{table}/operations", this.tableController::getTableOperations);
                ApiBuilder.get((String)"/catalogs/{catalog}/dbs/{db}/tables/{table}/tags", this.tableController::getTableTags);
                ApiBuilder.get((String)"/catalogs/{catalog}/dbs/{db}/tables/{table}/branches", this.tableController::getTableBranches);
                ApiBuilder.post((String)"/catalogs/{catalog}/dbs/{db}/tables/{table}/optimizing-processes/{processId}/cancel", this.tableController::cancelOptimizingProcess);
            });
            ApiBuilder.get((String)"/upgrade/properties", this.tableController::getUpgradeHiveTableProperties);
            ApiBuilder.path((String)"/catalogs", () -> {
                ApiBuilder.get((String)"/{catalog}/databases/{db}/tables", this.tableController::getTableList);
                ApiBuilder.get((String)"/{catalog}/databases", this.tableController::getDatabaseList);
                ApiBuilder.get((String)"", this.tableController::getCatalogs);
                ApiBuilder.post((String)"", this.catalogController::createCatalog);
                ApiBuilder.get((String)"metastore/types", this.catalogController::getCatalogTypeList);
                ApiBuilder.get((String)"/{catalogName}", this.catalogController::getCatalogDetail);
                ApiBuilder.delete((String)"/{catalogName}", this.catalogController::deleteCatalog);
                ApiBuilder.put((String)"/{catalogName}", this.catalogController::updateCatalog);
                ApiBuilder.get((String)"/{catalogName}/delete/check", this.catalogController::catalogDeleteCheck);
                ApiBuilder.get((String)"/{catalogName}/config/{type}/{key}", this.catalogController::getCatalogConfFileContent);
            });
            ApiBuilder.path((String)"/optimize", () -> {
                ApiBuilder.get((String)"/optimizerGroups/{optimizerGroup}/tables", this.optimizerController::getOptimizerTables);
                ApiBuilder.get((String)"/optimizerGroups/{optimizerGroup}/optimizers", this.optimizerController::getOptimizers);
                ApiBuilder.get((String)"/optimizerGroups", this.optimizerController::getOptimizerGroups);
                ApiBuilder.get((String)"/optimizerGroups/{optimizerGroup}/info", this.optimizerController::getOptimizerGroupInfo);
                ApiBuilder.delete((String)"/optimizerGroups/{optimizerGroup}/optimizers/{jobId}", this.optimizerController::releaseOptimizer);
                ApiBuilder.post((String)"/optimizerGroups/{optimizerGroup}/optimizers", this.optimizerController::scaleOutOptimizer);
                ApiBuilder.get((String)"/resourceGroups", this.optimizerController::getResourceGroup);
                ApiBuilder.post((String)"/resourceGroups", this.optimizerController::createResourceGroup);
                ApiBuilder.put((String)"/resourceGroups", this.optimizerController::updateResourceGroup);
                ApiBuilder.delete((String)"/resourceGroups/{resourceGroupName}", this.optimizerController::deleteResourceGroup);
                ApiBuilder.get((String)"/resourceGroups/{resourceGroupName}/delete/check", this.optimizerController::deleteCheckResourceGroup);
                ApiBuilder.get((String)"/containers/get", this.optimizerController::getContainers);
            });
            ApiBuilder.path((String)"/terminal", () -> {
                ApiBuilder.get((String)"/examples", this.terminalController::getExamples);
                ApiBuilder.get((String)"/examples/{exampleName}", this.terminalController::getSqlExamples);
                ApiBuilder.post((String)"/catalogs/{catalog}/execute", this.terminalController::executeScript);
                ApiBuilder.get((String)"/{sessionId}/logs", this.terminalController::getLogs);
                ApiBuilder.get((String)"/{sessionId}/result", this.terminalController::getSqlResult);
                ApiBuilder.put((String)"/{sessionId}/stop", this.terminalController::stopSql);
                ApiBuilder.get((String)"/latestInfos/", this.terminalController::getLatestInfo);
            });
            ApiBuilder.path((String)"/files", () -> {
                ApiBuilder.post((String)"", this.platformFileInfoController::uploadFile);
                ApiBuilder.get((String)"/{fileId}", this.platformFileInfoController::downloadFile);
            });
            ApiBuilder.path((String)"/settings", () -> {
                ApiBuilder.get((String)"/containers", this.settingController::getContainerSetting);
                ApiBuilder.get((String)"/system", this.settingController::getSystemSetting);
            });
            ApiBuilder.get((String)"/health/status", this.healthCheckController::healthCheck);
            ApiBuilder.get((String)"/versionInfo", this.versionController::getVersionInfo);
        };
    }

    public void preHandleRequest(Context ctx) {
        String uriPath = ctx.path();
        if (this.needApiKeyCheck(uriPath)) {
            if (AUTH_TYPE_BASIC.equalsIgnoreCase(this.authType)) {
                BasicAuthCredentials cred = ctx.basicAuthCredentials();
                if (!this.basicAuthUser.equals(cred.component1()) || !this.basicAuthPassword.equals(cred.component2())) {
                    throw new SignatureCheckException("Failed to authenticate via basic authentication for url:" + uriPath);
                }
            } else {
                this.checkApiToken(ctx.url(), ctx.queryParam("apiKey"), ctx.queryParam("signature"), ctx.queryParamMap());
            }
        } else if (DashboardServer.needLoginCheck(uriPath) && null == ctx.sessionAttribute("user")) {
            throw new ForbiddenException("User session attribute is missed for url: " + uriPath);
        }
    }

    public void handleException(Exception e, Context ctx) {
        if (e instanceof ForbiddenException) {
            if (!ctx.req.getRequestURI().startsWith("/ams")) {
                ctx.html(this.getIndexFileContent());
            } else {
                ctx.json((Object)new ErrorResponse(HttpCode.FORBIDDEN, "Please login first", ""));
            }
        } else if (e instanceof SignatureCheckException) {
            ctx.json((Object)new ErrorResponse(HttpCode.FORBIDDEN, "Signature check failed", ""));
        } else {
            ctx.json((Object)new ErrorResponse(HttpCode.INTERNAL_SERVER_ERROR, e.getMessage(), ""));
        }
        LOG.error("An error occurred while processing the url:{}", (Object)ctx.url(), (Object)e);
    }

    private static boolean needLoginCheck(String uri) {
        for (String item : urlWhiteList) {
            if (!(item.endsWith("*") ? uri.startsWith(item.substring(0, item.length() - 1)) : uri.equals(item))) continue;
            return false;
        }
        return true;
    }

    private boolean needApiKeyCheck(String uri) {
        return uri.startsWith("/api/ams");
    }

    private void checkApiToken(String requestUrl, String apiKey, String signature, Map<String, List<String>> params) {
        APITokenManager apiTokenService = new APITokenManager();
        try {
            String secret = apiTokenService.getSecretByKey(apiKey);
            if (secret == null) {
                throw new SignatureCheckException();
            }
            if (apiKey == null || signature == null) {
                throw new SignatureCheckException();
            }
            params.remove("apiKey");
            params.remove("signature");
            String paramString = ParamSignatureCalculator.generateParamStringWithValueList(params);
            String encryptString = StringUtils.isBlank((CharSequence)paramString) ? ParamSignatureCalculator.SIMPLE_DATE_FORMAT.format(new Date()) : paramString;
            String plainText = String.format("%s%s%s", apiKey, encryptString, secret);
            String signCal = ParamSignatureCalculator.getMD5(plainText);
            LOG.debug("Calculated signature for url:{}, plain text:{}, calculated signature:{}, signature in request: {}", new Object[]{requestUrl, plainText, signCal, signature});
            if (!signature.equals(signCal)) {
                throw new SignatureCheckException(String.format("Check signature for url:%s failed, calculated signature:%s, signature in request:%s", requestUrl, signCal, signature));
            }
        }
        catch (Exception e) {
            throw new SignatureCheckException("Check url signature failed", e);
        }
    }
}

