/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.amoro.AmoroTable;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.CommitMetaProducer;
import org.apache.amoro.data.DataFileType;
import org.apache.amoro.server.dashboard.FormatTableDescriptor;
import org.apache.amoro.server.dashboard.component.reverser.DDLReverser;
import org.apache.amoro.server.dashboard.component.reverser.PaimonTableMetaExtract;
import org.apache.amoro.server.dashboard.model.AMSColumnInfo;
import org.apache.amoro.server.dashboard.model.AMSPartitionField;
import org.apache.amoro.server.dashboard.model.AmoroSnapshotsOfTable;
import org.apache.amoro.server.dashboard.model.DDLInfo;
import org.apache.amoro.server.dashboard.model.OperationType;
import org.apache.amoro.server.dashboard.model.OptimizingProcessInfo;
import org.apache.amoro.server.dashboard.model.OptimizingTaskInfo;
import org.apache.amoro.server.dashboard.model.PartitionBaseInfo;
import org.apache.amoro.server.dashboard.model.PartitionFileBaseInfo;
import org.apache.amoro.server.dashboard.model.ServerTableMeta;
import org.apache.amoro.server.dashboard.model.TagOrBranchInfo;
import org.apache.amoro.server.dashboard.utils.AmsUtil;
import org.apache.amoro.server.dashboard.utils.FilesStatisticsBuilder;
import org.apache.amoro.server.optimizing.OptimizingProcess;
import org.apache.amoro.server.optimizing.OptimizingType;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableList;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.Streams;
import org.apache.amoro.table.TableIdentifier;
import org.apache.iceberg.util.Pair;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.FileStore;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.table.DataTable;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.FileStorePathFactory;
import org.jetbrains.annotations.NotNull;

public class PaimonTableDescriptor
implements FormatTableDescriptor {
    public static final String PAIMON_MAIN_BRANCH_NAME = "main";
    private final ExecutorService executor;

    public PaimonTableDescriptor(ExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public List<TableFormat> supportFormat() {
        return Lists.newArrayList((Object[])new TableFormat[]{TableFormat.PAIMON});
    }

    @Override
    public ServerTableMeta getTableDetail(AmoroTable<?> amoroTable) {
        FileStoreTable table = this.getTable(amoroTable);
        FileStore store = table.store();
        ServerTableMeta serverTableMeta = new ServerTableMeta();
        serverTableMeta.setTableIdentifier(amoroTable.id());
        serverTableMeta.setTableType(amoroTable.format().name());
        serverTableMeta.setSchema(table.rowType().getFields().stream().map(s -> new AMSColumnInfo(s.name(), s.type().asSQLString(), !s.type().isNullable(), s.description())).collect(Collectors.toList()));
        HashSet primaryKeyNames = new HashSet(table.primaryKeys());
        List<AMSColumnInfo> primaryKeys = serverTableMeta.getSchema().stream().filter(s -> primaryKeyNames.contains(s.getField())).collect(Collectors.toList());
        serverTableMeta.setPkList(primaryKeys);
        List<AMSPartitionField> partitionFields = store.partitionType().getFields().stream().map(f -> new AMSPartitionField(f.name(), null, null, f.id(), null)).collect(Collectors.toList());
        serverTableMeta.setPartitionColumnList(partitionFields);
        serverTableMeta.setProperties(table.options());
        HashMap<String, Object> tableSummary = new HashMap<String, Object>();
        HashMap<String, Object> baseMetric = new HashMap<String, Object>();
        tableSummary.put("tableFormat", AmsUtil.formatString(amoroTable.format().name()));
        Snapshot snapshot = store.snapshotManager().latestSnapshot();
        if (snapshot != null) {
            AmoroSnapshotsOfTable snapshotsOfTable = this.manifestListInfo(store, snapshot, (m, s) -> s.dataManifests(m));
            long fileSize = snapshotsOfTable.getOriginalFileSize();
            String totalSize = AmsUtil.byteToXB(fileSize);
            int fileCount = snapshotsOfTable.getFileCount();
            String averageFileSize = AmsUtil.byteToXB(fileCount == 0 ? 0L : fileSize / (long)fileCount);
            tableSummary.put("averageFile", averageFileSize);
            tableSummary.put("file", fileCount);
            tableSummary.put("size", totalSize);
            tableSummary.put("records", snapshotsOfTable.getRecords());
            baseMetric.put("totalSize", totalSize);
            baseMetric.put("fileCount", fileCount);
            baseMetric.put("averageFileSize", averageFileSize);
            baseMetric.put("lastCommitTime", snapshot.timeMillis());
            Long watermark = snapshot.watermark();
            if (watermark != null && watermark > 0L) {
                baseMetric.put("baseWatermark", watermark);
            }
        } else {
            tableSummary.put("size", 0);
            tableSummary.put("file", 0);
            tableSummary.put("averageFile", 0);
            baseMetric.put("totalSize", 0);
            baseMetric.put("fileCount", 0);
            baseMetric.put("averageFileSize", 0);
        }
        serverTableMeta.setTableSummary(tableSummary);
        serverTableMeta.setBaseMetrics(baseMetric);
        return serverTableMeta;
    }

    @Override
    public List<AmoroSnapshotsOfTable> getSnapshots(AmoroTable<?> amoroTable, String ref, OperationType operationType) {
        Predicate<Snapshot> predicate;
        Iterator<Snapshot> snapshots;
        FileStoreTable table = this.getTable(amoroTable);
        ArrayList snapshotsOfTables = new ArrayList();
        if (PAIMON_MAIN_BRANCH_NAME.equals(ref)) {
            try {
                snapshots = table.snapshotManager().snapshots();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            snapshots = Collections.singleton(table.tagManager().taggedSnapshot(ref)).iterator();
        }
        FileStore store = table.store();
        ArrayList<CompletableFuture<AmoroSnapshotsOfTable>> futures = new ArrayList<CompletableFuture<AmoroSnapshotsOfTable>>();
        Predicate<Snapshot> predicate2 = operationType == OperationType.ALL ? s -> true : (predicate = operationType == OperationType.OPTIMIZING ? s -> s.commitKind() == Snapshot.CommitKind.COMPACT : s -> s.commitKind() != Snapshot.CommitKind.COMPACT);
        while (snapshots.hasNext()) {
            Snapshot snapshot = snapshots.next();
            if (!predicate.test(snapshot)) continue;
            futures.add(CompletableFuture.supplyAsync(() -> this.getSnapshotsOfTable(store, snapshot), this.executor));
        }
        for (CompletableFuture completableFuture : futures) {
            try {
                snapshotsOfTables.add(completableFuture.get());
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return snapshotsOfTables.stream().sorted((o1, o2) -> Long.compare(o2.getCommitTime(), o1.getCommitTime())).collect(Collectors.toList());
    }

    @Override
    public List<PartitionFileBaseInfo> getSnapshotDetail(AmoroTable<?> amoroTable, long snapshotId) {
        FileStoreTable table = this.getTable(amoroTable);
        ArrayList<PartitionFileBaseInfo> amsDataFileInfos = new ArrayList<PartitionFileBaseInfo>();
        Snapshot snapshot = table.snapshotManager().snapshot(snapshotId);
        FileStore store = table.store();
        FileStorePathFactory fileStorePathFactory = store.pathFactory();
        ManifestList manifestList = store.manifestListFactory().create();
        ManifestFile manifestFile = store.manifestFileFactory().create();
        List manifestFileMetas = snapshot.deltaManifests(manifestList);
        for (ManifestFileMeta manifestFileMeta : manifestFileMetas) {
            manifestFileMeta.fileSize();
            List manifestEntries = manifestFile.read(manifestFileMeta.fileName());
            for (ManifestEntry entry : manifestEntries) {
                amsDataFileInfos.add(new PartitionFileBaseInfo(null, DataFileType.BASE_FILE, (Long)entry.file().creationTimeEpochMillis(), this.partitionString(entry.partition(), entry.bucket(), fileStorePathFactory), this.fullFilePath(store, entry), entry.file().fileSize(), entry.kind().name()));
            }
        }
        return amsDataFileInfos;
    }

    @Override
    public List<DDLInfo> getTableOperations(AmoroTable<?> amoroTable) {
        FileStoreTable table = this.getTable(amoroTable);
        PaimonTableMetaExtract extract = new PaimonTableMetaExtract();
        DDLReverser<DataTable> ddlReverser = new DDLReverser<DataTable>(extract);
        return ddlReverser.reverse((DataTable)table, amoroTable.id());
    }

    @Override
    public List<PartitionBaseInfo> getTablePartitions(AmoroTable<?> amoroTable) {
        FileStoreTable table = this.getTable(amoroTable);
        FileStore store = table.store();
        FileStorePathFactory fileStorePathFactory = store.pathFactory();
        List files = store.newScan().plan().files(FileKind.ADD);
        Map groupByPartFiles = FileStoreScan.Plan.groupByPartFiles((List)files);
        ArrayList<PartitionBaseInfo> partitionBaseInfoList = new ArrayList<PartitionBaseInfo>();
        for (Map.Entry groupByPartitionEntry : groupByPartFiles.entrySet()) {
            for (Map.Entry groupByBucketEntry : ((Map)groupByPartitionEntry.getValue()).entrySet()) {
                String partitionSt = this.partitionString((BinaryRow)groupByPartitionEntry.getKey(), (Integer)groupByBucketEntry.getKey(), fileStorePathFactory);
                int fileCount = 0;
                long fileSize = 0L;
                long lastCommitTime = 0L;
                for (DataFileMeta dataFileMeta : (List)groupByBucketEntry.getValue()) {
                    ++fileCount;
                    fileSize += dataFileMeta.fileSize();
                    lastCommitTime = Math.max(lastCommitTime, dataFileMeta.creationTimeEpochMillis());
                }
                partitionBaseInfoList.add(new PartitionBaseInfo(partitionSt, 0, fileCount, fileSize, lastCommitTime));
            }
        }
        return partitionBaseInfoList;
    }

    @Override
    public List<PartitionFileBaseInfo> getTableFiles(AmoroTable<?> amoroTable, String partition, Integer specId) {
        Iterator snapshots;
        FileStoreTable table = this.getTable(amoroTable);
        FileStore store = table.store();
        ConcurrentHashMap fileSnapshotIdMap = new ConcurrentHashMap();
        ManifestList manifestList = store.manifestListFactory().create();
        ManifestFile manifestFile = store.manifestFileFactory().create();
        try {
            snapshots = store.snapshotManager().snapshots();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        while (snapshots.hasNext()) {
            Snapshot snapshot = (Snapshot)snapshots.next();
            futures.add(CompletableFuture.runAsync(() -> {
                List deltaManifests = snapshot.deltaManifests(manifestList);
                for (ManifestFileMeta manifestFileMeta : deltaManifests) {
                    List manifestEntries = manifestFile.read(manifestFileMeta.fileName());
                    for (ManifestEntry manifestEntry : manifestEntries) {
                        fileSnapshotIdMap.put(manifestEntry.file(), snapshot.id());
                    }
                }
            }, this.executor));
        }
        try {
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get();
        }
        catch (InterruptedException snapshot) {
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        FileStorePathFactory fileStorePathFactory = store.pathFactory();
        List files = store.newScan().plan().files(FileKind.ADD);
        ArrayList<PartitionFileBaseInfo> partitionFileBases = new ArrayList<PartitionFileBaseInfo>();
        for (ManifestEntry manifestEntry : files) {
            String partitionSt = this.partitionString(manifestEntry.partition(), manifestEntry.bucket(), fileStorePathFactory);
            if (partition != null && !table.partitionKeys().isEmpty() && !partition.equals(partitionSt)) continue;
            Long snapshotId = (Long)fileSnapshotIdMap.get(manifestEntry.file());
            partitionFileBases.add(new PartitionFileBaseInfo(snapshotId == null ? null : snapshotId.toString(), DataFileType.INSERT_FILE, (Long)manifestEntry.file().creationTimeEpochMillis(), partitionSt, 0, this.fullFilePath(store, manifestEntry), manifestEntry.file().fileSize()));
        }
        return partitionFileBases;
    }

    @Override
    public Pair<List<OptimizingProcessInfo>, Integer> getOptimizingProcessesInfo(AmoroTable<?> amoroTable, int limit, int offset) {
        int total;
        List<Object> processInfoList = new ArrayList();
        TableIdentifier tableIdentifier = amoroTable.id();
        FileStoreTable fileStoreTable = (FileStoreTable)amoroTable.originalTable();
        FileStore store = fileStoreTable.store();
        boolean isPrimaryTable = !fileStoreTable.primaryKeys().isEmpty();
        int maxLevel = CoreOptions.fromMap((Map)fileStoreTable.options()).numLevels() - 1;
        try {
            List compactSnapshots = Streams.stream((Iterator)store.snapshotManager().snapshots()).filter(s -> s.commitKind() == Snapshot.CommitKind.COMPACT).collect(Collectors.toList());
            total = compactSnapshots.size();
            processInfoList = compactSnapshots.stream().sorted(Comparator.comparing(Snapshot::id).reversed()).skip(offset).limit(limit).map(s -> {
                OptimizingProcessInfo optimizingProcessInfo = new OptimizingProcessInfo();
                optimizingProcessInfo.setProcessId(s.id());
                optimizingProcessInfo.setCatalogName(tableIdentifier.getCatalog());
                optimizingProcessInfo.setDbName(tableIdentifier.getDatabase());
                optimizingProcessInfo.setTableName(tableIdentifier.getTableName());
                optimizingProcessInfo.setStatus(OptimizingProcess.Status.SUCCESS);
                optimizingProcessInfo.setFinishTime(s.timeMillis());
                FilesStatisticsBuilder inputBuilder = new FilesStatisticsBuilder();
                FilesStatisticsBuilder outputBuilder = new FilesStatisticsBuilder();
                ManifestFile manifestFile = store.manifestFileFactory().create();
                ManifestList manifestList = store.manifestListFactory().create();
                List manifestFileMetas = s.deltaManifests(manifestList);
                boolean hasMaxLevels = false;
                long minCreateTime = Long.MAX_VALUE;
                long maxCreateTime = Long.MIN_VALUE;
                HashSet<Integer> buckets = new HashSet<Integer>();
                for (ManifestFileMeta manifestFileMeta : manifestFileMetas) {
                    List compactManifestEntries = manifestFile.read(manifestFileMeta.fileName());
                    for (ManifestEntry compactManifestEntry : compactManifestEntries) {
                        if (compactManifestEntry.file().level() == maxLevel) {
                            hasMaxLevels = true;
                        }
                        buckets.add(compactManifestEntry.bucket());
                        if (compactManifestEntry.kind() == FileKind.DELETE) {
                            inputBuilder.addFile(compactManifestEntry.file().fileSize());
                            continue;
                        }
                        minCreateTime = Math.min(minCreateTime, compactManifestEntry.file().creationTimeEpochMillis());
                        maxCreateTime = Math.max(maxCreateTime, compactManifestEntry.file().creationTimeEpochMillis());
                        outputBuilder.addFile(compactManifestEntry.file().fileSize());
                    }
                }
                if (isPrimaryTable && hasMaxLevels) {
                    optimizingProcessInfo.setOptimizingType(OptimizingType.FULL);
                } else {
                    optimizingProcessInfo.setOptimizingType(OptimizingType.MINOR);
                }
                optimizingProcessInfo.setSuccessTasks(buckets.size());
                optimizingProcessInfo.setTotalTasks(buckets.size());
                optimizingProcessInfo.setStartTime(minCreateTime);
                optimizingProcessInfo.setDuration(s.timeMillis() - minCreateTime);
                optimizingProcessInfo.setInputFiles(inputBuilder.build());
                optimizingProcessInfo.setOutputFiles(outputBuilder.build());
                optimizingProcessInfo.setSummary(Collections.emptyMap());
                return optimizingProcessInfo;
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Pair.of(processInfoList, (Object)total);
    }

    @Override
    public List<OptimizingTaskInfo> getOptimizingTaskInfos(AmoroTable<?> amoroTable, long processId) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    private AmoroSnapshotsOfTable getSnapshotsOfTable(FileStore<?> store, Snapshot snapshot) {
        HashMap<String, String> summary = new HashMap<String, String>();
        summary.put("commitUser", snapshot.commitUser());
        summary.put("commitIdentifier", String.valueOf(snapshot.commitIdentifier()));
        if (snapshot.watermark() != null) {
            summary.put("watermark", String.valueOf(snapshot.watermark()));
        }
        if (snapshot.totalRecordCount() != null) {
            summary.put("total-records", String.valueOf(snapshot.totalRecordCount()));
        }
        if (snapshot.deltaRecordCount() != null) {
            summary.put("delta-records", String.valueOf(snapshot.deltaRecordCount()));
        }
        if (snapshot.changelogRecordCount() != null) {
            summary.put("changelog-records", String.valueOf(snapshot.changelogRecordCount()));
        }
        AmoroSnapshotsOfTable deltaSnapshotsOfTable = this.manifestListInfo(store, snapshot, (m, s) -> s.deltaManifests(m));
        int deltaFileCount = deltaSnapshotsOfTable.getFileCount();
        int dataFileCount = this.manifestListInfo(store, snapshot, (m, s) -> s.dataManifests(m)).getFileCount();
        int changeLogFileCount = this.manifestListInfo(store, snapshot, (m, s) -> s.changelogManifests(m)).getFileCount();
        summary.put("delta-files", String.valueOf(deltaFileCount));
        summary.put("data-files", String.valueOf(dataFileCount));
        summary.put("changelogs", String.valueOf(changeLogFileCount));
        Map<String, String> recordsSummaryForChat = PaimonTableDescriptor.extractSummary(summary, "total-records", "delta-records", "changelog-records");
        deltaSnapshotsOfTable.setRecordsSummaryForChart(recordsSummaryForChat);
        Map<String, String> filesSummaryForChat = PaimonTableDescriptor.extractSummary(summary, "delta-files", "data-files", "changelogs");
        deltaSnapshotsOfTable.setFilesSummaryForChart(filesSummaryForChat);
        deltaSnapshotsOfTable.setSummary(summary);
        return deltaSnapshotsOfTable;
    }

    @NotNull
    private static Map<String, String> extractSummary(Map<String, String> summary, String ... keys) {
        HashSet<String> keySet = new HashSet<String>(Arrays.asList(keys));
        return summary.entrySet().stream().filter(e -> keySet.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public List<TagOrBranchInfo> getTableTags(AmoroTable<?> amoroTable) {
        FileStoreTable table = this.getTable(amoroTable);
        SortedMap tags = table.tagManager().tags();
        ArrayList<TagOrBranchInfo> tagOrBranchInfos = new ArrayList<TagOrBranchInfo>();
        tags.forEach((snapshot, tagList) -> {
            for (String tagName : tagList) {
                tagOrBranchInfos.add(new TagOrBranchInfo(tagName, snapshot.id(), 0, 0L, 0L, "tag"));
            }
        });
        return tagOrBranchInfos;
    }

    @Override
    public List<TagOrBranchInfo> getTableBranches(AmoroTable<?> amoroTable) {
        return ImmutableList.of((Object)TagOrBranchInfo.MAIN_BRANCH);
    }

    private AmoroSnapshotsOfTable manifestListInfo(FileStore<?> store, Snapshot snapshot, BiFunction<ManifestList, Snapshot, List<ManifestFileMeta>> biFunction) {
        ManifestList manifestList = store.manifestListFactory().create();
        ManifestFile manifestFile = store.manifestFileFactory().create();
        List<ManifestFileMeta> manifestFileMetas = biFunction.apply(manifestList, snapshot);
        int fileCount = 0;
        long fileSize = 0L;
        for (ManifestFileMeta manifestFileMeta : manifestFileMetas) {
            List manifestEntries = manifestFile.read(manifestFileMeta.fileName());
            for (ManifestEntry entry : manifestEntries) {
                if (entry.kind() == FileKind.ADD) {
                    fileSize += entry.file().fileSize();
                    ++fileCount;
                    continue;
                }
                fileSize -= entry.file().fileSize();
                --fileCount;
            }
        }
        Long totalRecordCount = snapshot.totalRecordCount();
        return new AmoroSnapshotsOfTable(String.valueOf(snapshot.id()), fileCount, fileSize, totalRecordCount == null ? 0L : totalRecordCount, snapshot.timeMillis(), snapshot.commitKind().toString(), snapshot.commitKind() == Snapshot.CommitKind.COMPACT ? CommitMetaProducer.OPTIMIZE.name() : CommitMetaProducer.INGESTION.name(), new HashMap<String, String>());
    }

    private String partitionString(BinaryRow partition, Integer bucket, FileStorePathFactory fileStorePathFactory) {
        String partitionString = fileStorePathFactory.getPartitionString(partition);
        return partitionString + "/bucket-" + bucket;
    }

    private String fullFilePath(FileStore<?> store, ManifestEntry manifestEntry) {
        return store.pathFactory().createDataFilePathFactory(manifestEntry.partition(), manifestEntry.bucket()).toPath(manifestEntry.file().fileName()).toString();
    }

    private FileStoreTable getTable(AmoroTable<?> amoroTable) {
        return (FileStoreTable)amoroTable.originalTable();
    }
}

