/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.component.reverser;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.amoro.server.dashboard.component.reverser.PaimonTypeToSparkType;
import org.apache.amoro.server.dashboard.component.reverser.TableMetaExtract;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.table.DataTable;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.RowType;

public class PaimonTableMetaExtract
implements TableMetaExtract<DataTable> {
    @Override
    public List<TableMetaExtract.InternalTableMeta> extractTable(DataTable table) {
        SchemaManager schemaManager = new SchemaManager(table.fileIO(), table.location());
        List tableSchemas = schemaManager.listAll();
        return tableSchemas.stream().sorted((o1, o2) -> Long.compare(o1.timeMillis(), o2.timeMillis())).map(schema -> new TableMetaExtract.InternalTableMeta(schema.timeMillis(), this.transform(schema.fields()), schema.options())).collect(Collectors.toList());
    }

    private List<TableMetaExtract.InternalSchema> transform(List<DataField> fields) {
        return this.transform(null, new ArrayList<String>(), (DataType)new RowType(fields));
    }

    private List<TableMetaExtract.InternalSchema> transform(Integer parent, List<String> parentName, DataType type) {
        ArrayList<TableMetaExtract.InternalSchema> result = new ArrayList<TableMetaExtract.InternalSchema>();
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            for (DataField field : rowType.getFields()) {
                ArrayList name = Lists.newArrayList(parentName);
                name.add(field.name());
                DataType fieldType = field.type();
                result.add(new TableMetaExtract.InternalSchema(field.id(), parent, this.formatName(name), this.dateTypeToSparkString(fieldType), field.description(), !field.type().isNullable()));
                result.addAll(this.transform(field.id(), name, field.type()));
            }
        } else if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            ArrayList name = Lists.newArrayList(parentName);
            name.add("element");
            DataType elementType = arrayType.getElementType();
            result.addAll(this.transform(parent, name, elementType));
        } else if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            ArrayList keyName = Lists.newArrayList(parentName);
            keyName.add("key");
            DataType keyType = mapType.getKeyType();
            result.addAll(this.transform(parent, keyName, keyType));
            ArrayList valueName = Lists.newArrayList(parentName);
            valueName.add("value");
            DataType valueType = mapType.getValueType();
            result.addAll(this.transform(parent, valueName, valueType));
        }
        return result;
    }

    private String formatName(List<String> names) {
        return String.join((CharSequence)".", names);
    }

    private String dateTypeToSparkString(DataType dataType) {
        return PaimonTypeToSparkType.fromPaimonType(dataType).catalogString();
    }
}

