/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.controller;

import io.javalin.http.Context;
import java.io.Serializable;
import java.util.Map;
import org.apache.amoro.api.config.Configurations;
import org.apache.amoro.server.AmoroManagementConf;
import org.apache.amoro.server.dashboard.response.OkResponse;

public class LoginController {
    private final String adminUser;
    private final String adminPassword;

    public LoginController(Configurations serviceConfig) {
        this.adminUser = (String)serviceConfig.get(AmoroManagementConf.ADMIN_USERNAME);
        this.adminPassword = (String)serviceConfig.get(AmoroManagementConf.ADMIN_PASSWORD);
    }

    public void getCurrent(Context ctx) {
        SessionInfo user = (SessionInfo)ctx.sessionAttribute("user");
        ctx.json(OkResponse.of(user));
    }

    public void login(Context ctx) {
        Map bodyParams = (Map)ctx.bodyAsClass(Map.class);
        String user = (String)bodyParams.get("user");
        String pwd = (String)bodyParams.get("password");
        if (!this.adminUser.equals(user) || !this.adminPassword.equals(pwd)) {
            throw new RuntimeException("bad user " + user + " or password!");
        }
        ctx.sessionAttribute("user", (Object)new SessionInfo(this.adminUser, System.currentTimeMillis() + ""));
        ctx.json(OkResponse.of("success"));
    }

    public void logout(Context ctx) {
        ctx.removeCookie("JSESSIONID");
        ctx.json(OkResponse.ok());
    }

    static class SessionInfo
    implements Serializable {
        String userName;
        String loginTime;

        public SessionInfo(String username, String loginTime) {
            this.userName = username;
            this.loginTime = loginTime;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getLoginTime() {
            return this.loginTime;
        }

        public void setLoginTime(String loginTime) {
            this.loginTime = loginTime;
        }
    }
}

