/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.controller;

import io.javalin.http.Context;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.amoro.server.dashboard.model.LatestSessionInfo;
import org.apache.amoro.server.dashboard.model.SessionInfo;
import org.apache.amoro.server.dashboard.model.SqlExample;
import org.apache.amoro.server.dashboard.model.SqlResult;
import org.apache.amoro.server.dashboard.response.OkResponse;
import org.apache.amoro.server.terminal.TerminalManager;

public class TerminalController {
    private final TerminalManager terminalManager;

    public TerminalController(TerminalManager terminalManager) {
        this.terminalManager = terminalManager;
    }

    public void getExamples(Context ctx) {
        List examples = Arrays.stream(SqlExample.values()).map(SqlExample::getName).collect(Collectors.toList());
        ctx.json(OkResponse.of(examples));
    }

    public void getSqlExamples(Context ctx) {
        String exampleName = ctx.pathParam("exampleName");
        for (SqlExample example : SqlExample.values()) {
            if (!example.getName().equals(exampleName)) continue;
            ctx.json(OkResponse.of(example.getSql()));
            return;
        }
        throw new IllegalArgumentException("can not get example name : " + exampleName);
    }

    public void executeScript(Context ctx) {
        String catalog = ctx.pathParam("catalog");
        Map bodyParams = (Map)ctx.bodyAsClass(Map.class);
        String sql = (String)bodyParams.get("sql");
        String terminalId = ctx.cookie("JSESSIONID");
        if (terminalId == null) {
            terminalId = UUID.randomUUID().toString();
        }
        String sessionId = this.terminalManager.executeScript(terminalId, catalog, sql);
        ctx.json(OkResponse.of(new SessionInfo(sessionId)));
    }

    public void getLogs(Context ctx) {
        String sessionId = (String)ctx.pathParamAsClass("sessionId", String.class).get();
        ctx.json(OkResponse.of(this.terminalManager.getExecutionLog(sessionId)));
    }

    public void getSqlResult(Context ctx) {
        String sessionId = (String)ctx.pathParamAsClass("sessionId", String.class).get();
        List<SqlResult> results = this.terminalManager.getExecutionResults(sessionId);
        ctx.json(OkResponse.of(results));
    }

    public void stopSql(Context ctx) {
        String sessionId = (String)ctx.pathParamAsClass("sessionId", String.class).get();
        this.terminalManager.cancelExecution(sessionId);
        ctx.json(OkResponse.ok());
    }

    public void getLatestInfo(Context ctx) {
        String terminalId = ctx.cookie("JSESSIONID");
        LatestSessionInfo sessionInfo = this.terminalManager.getLastSessionInfo(terminalId);
        ctx.json(OkResponse.of(sessionInfo));
    }
}

