/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.amoro.api.resource.Resource;
import org.apache.amoro.server.manager.AbstractResourceContainer;
import org.apache.amoro.server.manager.ExecUtil;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalOptimizerContainer
extends AbstractResourceContainer {
    private static final Logger LOG = LoggerFactory.getLogger(LocalOptimizerContainer.class);
    public static final String JOB_MEMORY_PROPERTY = "memory";

    @Override
    protected Map<String, String> doScaleOut(Resource resource) {
        String startUpArgs = this.buildOptimizerStartupArgsString(resource);
        try {
            String exportCmd = String.format(" export OPTIMIZER_LOG_DIR_NAME=\"optimizer-%s-%s\" ", resource.getGroupName(), resource.getResourceId());
            String startUpCommand = exportCmd + " && " + startUpArgs;
            String[] cmd = new String[]{"/bin/sh", "-c", startUpCommand};
            LOG.info("Starting local optimizer using command : {}", (Object)startUpCommand);
            ExecUtil.exec(cmd, new ArrayList<String>());
            return Collections.emptyMap();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to scale out optimizer.", e);
        }
    }

    @Override
    protected String buildOptimizerStartupArgsString(Resource resource) {
        String jobMemoryStr = resource.getRequiredProperty(JOB_MEMORY_PROPERTY);
        Preconditions.checkArgument((boolean)jobMemoryStr.matches("\\d+"), (String)"Invalid memory value: %s, must be a number.", (Object)jobMemoryStr);
        long memoryPerThread = Long.parseLong(jobMemoryStr);
        long memory = memoryPerThread * (long)resource.getThreadCount();
        return String.format("%s/bin/optimizer.sh start %s %s", this.amsHome, memory, super.buildOptimizerStartupArgsString(resource));
    }

    public void releaseOptimizer(Resource resource) {
        String[] finalCmd;
        String cmd;
        long jobId = Long.parseLong(resource.getRequiredProperty("job-id"));
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            cmd = "taskkill /PID " + jobId + " /F ";
            finalCmd = new String[]{"cmd", "/c", cmd};
        } else {
            cmd = "kill -9 " + jobId;
            finalCmd = new String[]{"/bin/sh", "-c", cmd};
        }
        try {
            Runtime runtime = Runtime.getRuntime();
            LOG.info("Stopping optimizer using command:{}", (Object)cmd);
            runtime.exec(finalCmd);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to release optimizer.", e);
        }
    }
}

