/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.optimizing.scan;

import org.apache.amoro.server.optimizing.scan.TableFileScanHelper;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;

public class IcebergTableFileScanHelper
implements TableFileScanHelper {
    private final Table table;
    private Expression partitionFilter = Expressions.alwaysTrue();
    private final long snapshotId;

    public IcebergTableFileScanHelper(Table table, long snapshotId) {
        this.table = table;
        this.snapshotId = snapshotId;
    }

    @Override
    public CloseableIterable<TableFileScanHelper.FileScanResult> scan() {
        if (this.snapshotId == -1L) {
            return CloseableIterable.empty();
        }
        return CloseableIterable.transform((CloseableIterable)((TableScan)this.table.newScan().useSnapshot(this.snapshotId).filter(this.partitionFilter)).planFiles(), this::buildFileScanResult);
    }

    protected TableFileScanHelper.FileScanResult buildFileScanResult(FileScanTask fileScanTask) {
        return new TableFileScanHelper.FileScanResult((DataFile)fileScanTask.file(), Lists.newArrayList((Iterable)fileScanTask.deletes()));
    }

    @Override
    public TableFileScanHelper withPartitionFilter(Expression partitionFilter) {
        this.partitionFilter = partitionFilter;
        return this;
    }
}

