/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table.executor;

import org.apache.amoro.AmoroTable;
import org.apache.amoro.api.config.TableConfiguration;
import org.apache.amoro.server.optimizing.OptimizingProcess;
import org.apache.amoro.server.optimizing.plan.OptimizingEvaluator;
import org.apache.amoro.server.table.TableManager;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.server.table.executor.BaseTableExecutor;
import org.apache.amoro.table.MixedTable;

public class TableRuntimeRefreshExecutor
extends BaseTableExecutor {
    private final long interval;

    public TableRuntimeRefreshExecutor(TableManager tableRuntimes, int poolSize, long interval) {
        super(tableRuntimes, poolSize);
        this.interval = interval;
    }

    @Override
    protected boolean enabled(TableRuntime tableRuntime) {
        return true;
    }

    @Override
    protected long getNextExecutingTime(TableRuntime tableRuntime) {
        return Math.min((long)tableRuntime.getOptimizingConfig().getMinorLeastInterval() * 4L / 5L, this.interval);
    }

    private void tryEvaluatingPendingInput(TableRuntime tableRuntime, MixedTable table) {
        OptimizingEvaluator evaluator;
        if (tableRuntime.isOptimizingEnabled() && !tableRuntime.getOptimizingStatus().isProcessing() && (evaluator = new OptimizingEvaluator(tableRuntime, table)).isNecessary()) {
            OptimizingEvaluator.PendingInput pendingInput = evaluator.getPendingInput();
            this.logger.debug("{} optimizing is necessary and get pending input {}", (Object)tableRuntime.getTableIdentifier(), (Object)pendingInput);
            tableRuntime.setPendingInput(pendingInput);
        }
    }

    @Override
    public void handleConfigChanged(TableRuntime tableRuntime, TableConfiguration originalConfig) {
        OptimizingProcess optimizingProcess;
        if (originalConfig.getOptimizingConfig().isEnabled() && !tableRuntime.getTableConfiguration().getOptimizingConfig().isEnabled() && (optimizingProcess = tableRuntime.getOptimizingProcess()) != null && optimizingProcess.getStatus() == OptimizingProcess.Status.RUNNING) {
            optimizingProcess.close();
        }
    }

    @Override
    public void execute(TableRuntime tableRuntime) {
        try {
            long lastOptimizedSnapshotId = tableRuntime.getLastOptimizedSnapshotId();
            long lastOptimizedChangeSnapshotId = tableRuntime.getLastOptimizedChangeSnapshotId();
            AmoroTable<?> table = this.loadTable(tableRuntime);
            tableRuntime.refresh(table);
            MixedTable mixedTable = (MixedTable)table.originalTable();
            if (mixedTable.isKeyedTable() && (lastOptimizedSnapshotId != tableRuntime.getCurrentSnapshotId() || lastOptimizedChangeSnapshotId != tableRuntime.getCurrentChangeSnapshotId()) || mixedTable.isUnkeyedTable() && lastOptimizedSnapshotId != tableRuntime.getCurrentSnapshotId()) {
                this.tryEvaluatingPendingInput(tableRuntime, mixedTable);
            }
        }
        catch (Throwable throwable) {
            this.logger.error("Refreshing table {} failed.", (Object)tableRuntime.getTableIdentifier(), (Object)throwable);
        }
    }
}

