/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.connector.source;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.state.CheckpointListener;
import org.apache.flink.api.connector.source.ReaderOutput;
import org.apache.flink.api.connector.source.SourceEvent;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.core.io.InputStatus;

@Public
public interface SourceReader<T, SplitT extends SourceSplit>
extends AutoCloseable,
CheckpointListener {
    public void start();

    public InputStatus pollNext(ReaderOutput<T> var1) throws Exception;

    public List<SplitT> snapshotState(long var1);

    public CompletableFuture<Void> isAvailable();

    public void addSplits(List<SplitT> var1);

    public void notifyNoMoreSplits();

    default public void handleSourceEvents(SourceEvent sourceEvent) {
    }

    @Override
    default public void notifyCheckpointComplete(long checkpointId) throws Exception {
    }

    @PublicEvolving
    default public void pauseOrResumeSplits(Collection<String> splitsToPause, Collection<String> splitsToResume) {
        throw new UnsupportedOperationException("This source reader does not support pausing or resuming splits which can lead to unaligned splits.\nUnaligned splits are splits where the output watermarks of the splits have diverged more than the allowed limit.\nIt is highly discouraged to use unaligned source splits, as this leads to unpredictable\nwatermark alignment if there is more than a single split per reader. It is recommended to implement pausing splits\nfor this source. At your own risk, you can allow unaligned source splits by setting the\nconfiguration parameter `pipeline.watermark-alignment.allow-unaligned-source-splits' to true.\nBeware that this configuration parameter will be dropped in a future Flink release.");
    }
}

