/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.AbstractSubtaskHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.JobVertexIdPathParameter;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptDetailsInfo;
import org.apache.flink.runtime.rest.messages.job.SubtaskMessageParameters;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.Preconditions;

public class SubtaskCurrentAttemptDetailsHandler
extends AbstractSubtaskHandler<SubtaskExecutionAttemptDetailsInfo, SubtaskMessageParameters> {
    private final MetricFetcher metricFetcher;

    public SubtaskCurrentAttemptDetailsHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, SubtaskExecutionAttemptDetailsInfo, SubtaskMessageParameters> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor, MetricFetcher metricFetcher) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders, executionGraphCache, executor);
        this.metricFetcher = (MetricFetcher)Preconditions.checkNotNull((Object)metricFetcher);
    }

    @Override
    protected SubtaskExecutionAttemptDetailsInfo handleRequest(HandlerRequest<EmptyRequestBody> request, AccessExecutionVertex executionVertex) throws RestHandlerException {
        AccessExecution execution = executionVertex.getCurrentExecutionAttempt();
        JobID jobID = (JobID)request.getPathParameter(JobIDPathParameter.class);
        JobVertexID jobVertexID = (JobVertexID)request.getPathParameter(JobVertexIdPathParameter.class);
        Collection attempts = executionVertex.getCurrentExecutions();
        ArrayList<SubtaskExecutionAttemptDetailsInfo> otherConcurrentAttempts = null;
        if (attempts.size() > 1) {
            otherConcurrentAttempts = new ArrayList<SubtaskExecutionAttemptDetailsInfo>();
            for (AccessExecution attempt : attempts) {
                if (attempt.getAttemptNumber() == execution.getAttemptNumber()) continue;
                otherConcurrentAttempts.add(SubtaskExecutionAttemptDetailsInfo.create(attempt, this.metricFetcher, jobID, jobVertexID, null));
            }
        }
        return SubtaskExecutionAttemptDetailsInfo.create(execution, this.metricFetcher, jobID, jobVertexID, otherConcurrentAttempts);
    }
}

