/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.impl.DirectoryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DirectoryPolicyImpl
implements DirectoryPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryPolicyImpl.class);
    public static final String UNKNOWN_MARKER_POLICY = "Unknown policy in fs.s3a.directory.marker.retention: ";
    private static final Set<DirectoryPolicy.MarkerPolicy> AVAILABLE_POLICIES = EnumSet.of(DirectoryPolicy.MarkerPolicy.Delete);
    public static final DirectoryPolicy DELETE = new DirectoryPolicyImpl(DirectoryPolicy.MarkerPolicy.Delete);
    private final DirectoryPolicy.MarkerPolicy markerPolicy;

    public DirectoryPolicyImpl(DirectoryPolicy.MarkerPolicy markerPolicy) {
        this.markerPolicy = markerPolicy;
    }

    @Override
    public boolean keepDirectoryMarkers(Path path) {
        return false;
    }

    @Override
    public DirectoryPolicy.MarkerPolicy getMarkerPolicy() {
        return this.markerPolicy;
    }

    @Override
    public String describe() {
        return this.markerPolicy.getOptionName();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DirectoryMarkerRetention{");
        sb.append("policy='").append(this.markerPolicy.getOptionName()).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean hasPathCapability(Path path, String capability) {
        switch (capability) {
            case "fs.s3a.capability.directory.marker.aware": {
                return true;
            }
            case "fs.s3a.capability.directory.marker.policy.keep": 
            case "fs.s3a.capability.directory.marker.action.delete": {
                return true;
            }
            case "fs.s3a.capability.directory.marker.policy.delete": 
            case "fs.s3a.capability.directory.marker.policy.authoritative": 
            case "fs.s3a.capability.directory.marker.action.keep": {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown capability " + capability);
    }

    public static DirectoryPolicy getDirectoryPolicy(Configuration conf) {
        String option;
        switch (option = conf.getTrimmed("fs.s3a.directory.marker.retention", "delete").toLowerCase(Locale.ENGLISH)) {
            case "delete": {
                LOG.debug("Directory markers will be deleted");
                break;
            }
            case "keep": 
            case "authoritative": {
                LOG.info("Directory marker policy \"{}\" is unsupported, using \"delete\"", (Object)option);
                break;
            }
            default: {
                throw new IllegalArgumentException(UNKNOWN_MARKER_POLICY + option);
            }
        }
        return DELETE;
    }

    public static Set<DirectoryPolicy.MarkerPolicy> availablePolicies() {
        return AVAILABLE_POLICIES;
    }
}

