/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.hive.optimizing.plan;

import java.util.List;
import java.util.Map;
import org.apache.amoro.ServerTableIdentifier;
import org.apache.amoro.config.OptimizingConfig;
import org.apache.amoro.data.DataFileType;
import org.apache.amoro.data.PrimaryKeyedFile;
import org.apache.amoro.hive.optimizing.MixedHiveRewriteExecutorFactory;
import org.apache.amoro.hive.utils.HiveTableUtil;
import org.apache.amoro.optimizing.OptimizingInputProperties;
import org.apache.amoro.optimizing.plan.CommonPartitionEvaluator;
import org.apache.amoro.optimizing.plan.MixedIcebergPartitionPlan;
import org.apache.amoro.optimizing.plan.PartitionEvaluator;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.table.MixedTable;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.util.Pair;

public class MixedHivePartitionPlan
extends MixedIcebergPartitionPlan {
    private final String hiveLocation;
    private long maxSequence = 0L;
    private String customHiveSubdirectory;

    public MixedHivePartitionPlan(ServerTableIdentifier identifier, MixedTable table, OptimizingConfig config, Pair<Integer, StructLike> partition, String hiveLocation, long planTime, long lastMinorOptimizingTime, long lastFullOptimizingTime) {
        super(identifier, table, config, partition, planTime, lastMinorOptimizingTime, lastFullOptimizingTime);
        this.hiveLocation = hiveLocation;
    }

    public boolean addFile(DataFile dataFile, List<ContentFile<?>> deletes) {
        if (!super.addFile(dataFile, deletes)) {
            return false;
        }
        long sequenceNumber = dataFile.dataSequenceNumber();
        if (sequenceNumber > this.maxSequence) {
            this.maxSequence = sequenceNumber;
        }
        return true;
    }

    protected void beforeSplit() {
        super.beforeSplit();
        if (this.evaluator().isFullOptimizing() && this.moveFiles2CurrentHiveLocation()) {
            Preconditions.checkArgument((boolean)this.reservedDeleteFiles.isEmpty(), (Object)"delete files should be empty");
            this.rewriteDataFiles.entrySet().removeIf(entry -> this.evaluator().inHiveLocation((ContentFile)entry.getKey()));
            this.rewritePosDataFiles.entrySet().removeIf(entry -> this.evaluator().inHiveLocation((ContentFile)entry.getKey()));
        }
    }

    private boolean moveFiles2CurrentHiveLocation() {
        return this.evaluator().isFullNecessary() && !this.config.isFullRewriteAllFiles() && !this.evaluator().anyDeleteExist();
    }

    protected MixedHivePartitionEvaluator evaluator() {
        return (MixedHivePartitionEvaluator)super.evaluator();
    }

    protected CommonPartitionEvaluator buildEvaluator() {
        return new MixedHivePartitionEvaluator(this.identifier, this.config, (Pair<Integer, StructLike>)this.partition, this.partitionProperties, this.hiveLocation, this.planTime, this.isKeyedTable(), this.lastMinorOptimizingTime, this.lastFullOptimizingTime);
    }

    protected OptimizingInputProperties buildTaskProperties() {
        OptimizingInputProperties properties = super.buildTaskProperties();
        properties.setExecutorFactoryImpl(MixedHiveRewriteExecutorFactory.class.getName());
        if (this.moveFiles2CurrentHiveLocation()) {
            properties.needMoveFile2HiveLocation();
        } else if (this.evaluator().isFullNecessary()) {
            properties.setOutputDir(this.constructCustomHiveSubdirectory());
        }
        return properties;
    }

    private String constructCustomHiveSubdirectory() {
        if (this.customHiveSubdirectory == null) {
            this.customHiveSubdirectory = this.isKeyedTable() ? HiveTableUtil.newHiveSubdirectory(this.maxSequence) : HiveTableUtil.newHiveSubdirectory();
        }
        return this.customHiveSubdirectory;
    }

    public static class MixedHivePartitionEvaluator
    extends MixedIcebergPartitionPlan.MixedIcebergPartitionEvaluator {
        private final String hiveLocation;
        private final boolean reachHiveRefreshInterval;
        private boolean filesNotInHiveLocation = false;

        public MixedHivePartitionEvaluator(ServerTableIdentifier identifier, OptimizingConfig config, Pair<Integer, StructLike> partition, Map<String, String> partitionProperties, String hiveLocation, long planTime, boolean keyedTable, long lastMinorOptimizingTime, long lastFullOptimizingTime) {
            super(identifier, config, partition, partitionProperties, planTime, keyedTable, lastMinorOptimizingTime, lastFullOptimizingTime);
            this.hiveLocation = hiveLocation;
            String optimizedTime = partitionProperties.get("transient-time");
            long lastHiveOptimizedTime = optimizedTime == null ? 0L : (long)Integer.parseInt(optimizedTime) * 1000L;
            this.reachHiveRefreshInterval = config.getHiveRefreshInterval() >= 0L && planTime - lastHiveOptimizedTime > config.getHiveRefreshInterval();
        }

        public boolean addFile(DataFile dataFile, List<ContentFile<?>> deletes) {
            if (!super.addFile(dataFile, deletes)) {
                return false;
            }
            if (!this.filesNotInHiveLocation && !this.inHiveLocation((ContentFile<?>)dataFile)) {
                this.filesNotInHiveLocation = true;
            }
            return true;
        }

        protected boolean isFragmentFile(DataFile dataFile) {
            PrimaryKeyedFile file = (PrimaryKeyedFile)dataFile;
            if (file.type() == DataFileType.BASE_FILE) {
                return dataFile.fileSizeInBytes() <= this.fragmentSize && !this.inHiveLocation((ContentFile<?>)dataFile);
            }
            if (file.type() == DataFileType.INSERT_FILE) {
                return true;
            }
            throw new IllegalStateException("unexpected file type " + file.type() + " of " + file);
        }

        protected boolean isUndersizedSegmentFile(DataFile dataFile) {
            return !this.inHiveLocation((ContentFile<?>)dataFile) && super.isUndersizedSegmentFile(dataFile);
        }

        public boolean isFullNecessary() {
            if (!this.reachFullInterval() && !this.reachHiveRefreshInterval()) {
                return false;
            }
            return this.fragmentFileCount > this.getBaseSplitCount() || this.hasNewHiveData();
        }

        protected boolean isFullOptimizing() {
            return this.reachFullInterval() || this.reachHiveRefreshInterval();
        }

        protected boolean hasNewHiveData() {
            return this.anyDeleteExist() || this.hasChangeFiles || this.filesNotInHiveLocation;
        }

        protected boolean reachHiveRefreshInterval() {
            return this.reachHiveRefreshInterval;
        }

        public boolean fileShouldRewrite(DataFile dataFile, List<ContentFile<?>> deletes) {
            if (this.isFullOptimizing()) {
                return this.fileShouldFullOptimizing(dataFile, deletes);
            }
            return !this.inHiveLocation((ContentFile<?>)dataFile) && super.fileShouldRewrite(dataFile, deletes);
        }

        protected boolean fileShouldFullOptimizing(DataFile dataFile, List<ContentFile<?>> deleteFiles) {
            return true;
        }

        public PartitionEvaluator.Weight getWeight() {
            return new MixedIcebergPartitionPlan.MixedIcebergPartitionEvaluator.Weight(this.getCost(), this.hasChangeFiles && this.reachBaseRefreshInterval() || this.hasNewHiveData() && this.reachHiveRefreshInterval());
        }

        private boolean inHiveLocation(ContentFile<?> file) {
            return file.path().toString().contains(this.hiveLocation);
        }
    }
}

