/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.hbase;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.hbase.Counter;

class PartitionCache {
    private Map<ObjectPair<String, String>, TrieValue> cache;
    private final int maxSize;
    private int cacheSize;
    private Counter misses;
    private Counter hits;
    private Counter overflows;

    PartitionCache(int max, Counter hits, Counter misses, Counter overflows) {
        this.maxSize = max;
        this.cache = new HashMap<ObjectPair<String, String>, TrieValue>();
        this.cacheSize = 0;
        this.hits = hits;
        this.misses = misses;
        this.overflows = overflows;
    }

    void put(String dbName, String tableName, Partition part) {
        if (this.cacheSize < this.maxSize) {
            ObjectPair key = new ObjectPair((Object)dbName, (Object)tableName);
            TrieValue entry = this.cache.get(key);
            if (entry == null) {
                entry = new TrieValue(false);
                this.cache.put((ObjectPair<String, String>)key, entry);
            }
            entry.map.put(part.getValues(), part);
            ++this.cacheSize;
        } else {
            this.overflows.incr();
        }
    }

    void put(String dbName, String tableName, List<Partition> parts, boolean allForTable) {
        if (this.cacheSize + parts.size() < this.maxSize) {
            ObjectPair key = new ObjectPair((Object)dbName, (Object)tableName);
            TrieValue entry = this.cache.get(key);
            if (entry == null) {
                entry = new TrieValue(allForTable);
                this.cache.put((ObjectPair<String, String>)key, entry);
            }
            for (Partition part : parts) {
                entry.map.put(part.getValues(), part);
            }
            this.cacheSize += parts.size();
        } else {
            this.overflows.incr();
        }
    }

    Collection<Partition> getAllForTable(String dbName, String tableName) {
        TrieValue entry = this.cache.get(new ObjectPair((Object)dbName, (Object)tableName));
        if (entry != null && entry.hasAllPartitionsForTable) {
            this.hits.incr();
            return entry.map.values();
        }
        this.misses.incr();
        return null;
    }

    Partition get(String dbName, String tableName, List<String> partVals) {
        TrieValue entry = this.cache.get(new ObjectPair((Object)dbName, (Object)tableName));
        if (entry != null) {
            this.hits.incr();
            return entry.map.get(partVals);
        }
        this.misses.incr();
        return null;
    }

    void remove(String dbName, String tableName) {
        ObjectPair key = new ObjectPair((Object)dbName, (Object)tableName);
        TrieValue entry = this.cache.get(key);
        if (entry != null) {
            this.cacheSize -= entry.map.size();
            this.cache.remove(key);
        }
    }

    void remove(String dbName, String tableName, List<String> partVals) {
        ObjectPair key = new ObjectPair((Object)dbName, (Object)tableName);
        TrieValue entry = this.cache.get(key);
        if (entry != null && entry.map.remove(partVals) != null) {
            --this.cacheSize;
            entry.hasAllPartitionsForTable = false;
        }
    }

    void flush() {
        this.cache.clear();
        this.cacheSize = 0;
    }

    static class TrieValue {
        boolean hasAllPartitionsForTable;
        Map<List<String>, Partition> map;

        TrieValue(boolean hasAll) {
            this.hasAllPartitionsForTable = hasAll;
            this.map = new HashMap<List<String>, Partition>();
        }
    }
}

