/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.requests;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.iceberg.MetadataUpdate;
import org.apache.iceberg.MetadataUpdateParser;
import org.apache.iceberg.UpdateRequirement;
import org.apache.iceberg.UpdateRequirementParser;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.catalog.TableIdentifierParser;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.util.JsonUtil;

public class UpdateTableRequestParser {
    private static final String IDENTIFIER = "identifier";
    private static final String REQUIREMENTS = "requirements";
    private static final String UPDATES = "updates";

    private UpdateTableRequestParser() {
    }

    public static String toJson(UpdateTableRequest request) {
        return UpdateTableRequestParser.toJson(request, false);
    }

    public static String toJson(UpdateTableRequest request, boolean pretty) {
        return JsonUtil.generate(gen -> UpdateTableRequestParser.toJson(request, gen), pretty);
    }

    public static void toJson(UpdateTableRequest request, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument((null != request ? 1 : 0) != 0, (Object)"Invalid update table request: null");
        gen.writeStartObject();
        if (null != request.identifier()) {
            gen.writeFieldName(IDENTIFIER);
            TableIdentifierParser.toJson(request.identifier(), gen);
        }
        gen.writeArrayFieldStart(REQUIREMENTS);
        for (UpdateRequirement updateRequirement : request.requirements()) {
            UpdateRequirementParser.toJson(updateRequirement, gen);
        }
        gen.writeEndArray();
        gen.writeArrayFieldStart(UPDATES);
        for (MetadataUpdate metadataUpdate : request.updates()) {
            MetadataUpdateParser.toJson(metadataUpdate, gen);
        }
        gen.writeEndArray();
        gen.writeEndObject();
    }

    public static UpdateTableRequest fromJson(String json) {
        return JsonUtil.parse(json, UpdateTableRequestParser::fromJson);
    }

    public static UpdateTableRequest fromJson(JsonNode json) {
        Preconditions.checkArgument((null != json ? 1 : 0) != 0, (Object)"Cannot parse update table request from null object");
        TableIdentifier identifier = null;
        ArrayList requirements = Lists.newArrayList();
        ArrayList updates = Lists.newArrayList();
        if (json.hasNonNull(IDENTIFIER)) {
            identifier = TableIdentifierParser.fromJson(JsonUtil.get(IDENTIFIER, json));
        }
        if (json.hasNonNull(REQUIREMENTS)) {
            JsonNode requirementsNode = JsonUtil.get(REQUIREMENTS, json);
            Preconditions.checkArgument((boolean)requirementsNode.isArray(), (String)"Cannot parse requirements from non-array: %s", (Object)requirementsNode);
            requirementsNode.forEach(req -> requirements.add(UpdateRequirementParser.fromJson(req)));
        }
        if (json.hasNonNull(UPDATES)) {
            JsonNode updatesNode = JsonUtil.get(UPDATES, json);
            Preconditions.checkArgument((boolean)updatesNode.isArray(), (String)"Cannot parse metadata updates from non-array: %s", (Object)updatesNode);
            updatesNode.forEach(update -> updates.add(MetadataUpdateParser.fromJson(update)));
        }
        return UpdateTableRequest.create(identifier, requirements, updates);
    }
}

