/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive.cli;

import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.apache.kyuubi.shade.com.google.common.primitives.Booleans;
import org.apache.kyuubi.shade.com.google.common.primitives.Bytes;
import org.apache.kyuubi.shade.com.google.common.primitives.Doubles;
import org.apache.kyuubi.shade.com.google.common.primitives.Ints;
import org.apache.kyuubi.shade.com.google.common.primitives.Longs;
import org.apache.kyuubi.shade.com.google.common.primitives.Shorts;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TColumn;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TTypeId;

public class ColumnBuffer
extends AbstractList<Object> {
    private final TTypeId type;
    private BitSet nulls;
    private int size;
    private boolean[] boolVars;
    private byte[] byteVars;
    private short[] shortVars;
    private int[] intVars;
    private long[] longVars;
    private double[] doubleVars;
    private List<String> stringVars;
    private List<ByteBuffer> binaryVars;
    private static final byte[] MASKS = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};

    public ColumnBuffer(TColumn colValues) {
        if (colValues.isSetBoolVal()) {
            this.type = TTypeId.BOOLEAN_TYPE;
            this.nulls = ColumnBuffer.toBitset(colValues.getBoolVal().getNulls());
            this.boolVars = Booleans.toArray(colValues.getBoolVal().getValues());
            this.size = this.boolVars.length;
        } else if (colValues.isSetByteVal()) {
            this.type = TTypeId.TINYINT_TYPE;
            this.nulls = ColumnBuffer.toBitset(colValues.getByteVal().getNulls());
            this.byteVars = Bytes.toArray(colValues.getByteVal().getValues());
            this.size = this.byteVars.length;
        } else if (colValues.isSetI16Val()) {
            this.type = TTypeId.SMALLINT_TYPE;
            this.nulls = ColumnBuffer.toBitset(colValues.getI16Val().getNulls());
            this.shortVars = Shorts.toArray(colValues.getI16Val().getValues());
            this.size = this.shortVars.length;
        } else if (colValues.isSetI32Val()) {
            this.type = TTypeId.INT_TYPE;
            this.nulls = ColumnBuffer.toBitset(colValues.getI32Val().getNulls());
            this.intVars = Ints.toArray(colValues.getI32Val().getValues());
            this.size = this.intVars.length;
        } else if (colValues.isSetI64Val()) {
            this.type = TTypeId.BIGINT_TYPE;
            this.nulls = ColumnBuffer.toBitset(colValues.getI64Val().getNulls());
            this.longVars = Longs.toArray(colValues.getI64Val().getValues());
            this.size = this.longVars.length;
        } else if (colValues.isSetDoubleVal()) {
            this.type = TTypeId.DOUBLE_TYPE;
            this.nulls = ColumnBuffer.toBitset(colValues.getDoubleVal().getNulls());
            this.doubleVars = Doubles.toArray(colValues.getDoubleVal().getValues());
            this.size = this.doubleVars.length;
        } else if (colValues.isSetBinaryVal()) {
            this.type = TTypeId.BINARY_TYPE;
            this.nulls = ColumnBuffer.toBitset(colValues.getBinaryVal().getNulls());
            this.binaryVars = colValues.getBinaryVal().getValues();
            this.size = this.binaryVars.size();
        } else if (colValues.isSetStringVal()) {
            this.type = TTypeId.STRING_TYPE;
            this.nulls = ColumnBuffer.toBitset(colValues.getStringVal().getNulls());
            this.stringVars = colValues.getStringVal().getValues();
            this.size = this.stringVars.size();
        } else {
            throw new IllegalStateException("invalid union object");
        }
    }

    public ColumnBuffer(TTypeId type, BitSet nulls, Object values) {
        this.type = type;
        this.nulls = nulls;
        if (type == TTypeId.BOOLEAN_TYPE) {
            this.boolVars = (boolean[])values;
            this.size = this.boolVars.length;
        } else if (type == TTypeId.TINYINT_TYPE) {
            this.byteVars = (byte[])values;
            this.size = this.byteVars.length;
        } else if (type == TTypeId.SMALLINT_TYPE) {
            this.shortVars = (short[])values;
            this.size = this.shortVars.length;
        } else if (type == TTypeId.INT_TYPE) {
            this.intVars = (int[])values;
            this.size = this.intVars.length;
        } else if (type == TTypeId.BIGINT_TYPE) {
            this.longVars = (long[])values;
            this.size = this.longVars.length;
        } else if (type == TTypeId.DOUBLE_TYPE || type == TTypeId.FLOAT_TYPE) {
            this.doubleVars = (double[])values;
            this.size = this.doubleVars.length;
        } else if (type == TTypeId.BINARY_TYPE) {
            this.binaryVars = (List)values;
            this.size = this.binaryVars.size();
        } else if (type == TTypeId.STRING_TYPE) {
            this.stringVars = (List)values;
            this.size = this.stringVars.size();
        } else {
            throw new IllegalStateException("invalid union object");
        }
    }

    private static BitSet toBitset(byte[] nulls) {
        BitSet bitset = new BitSet();
        int bits = nulls.length * 8;
        for (int i = 0; i < bits; ++i) {
            bitset.set(i, (nulls[i / 8] & MASKS[i % 8]) != 0);
        }
        return bitset;
    }

    public ColumnBuffer extractSubset(int end) {
        BitSet subNulls = this.nulls.get(0, end);
        if (this.type == TTypeId.BOOLEAN_TYPE) {
            ColumnBuffer subset = new ColumnBuffer(this.type, subNulls, Arrays.copyOfRange(this.boolVars, 0, end));
            this.boolVars = Arrays.copyOfRange(this.boolVars, end, this.size);
            this.nulls = this.nulls.get(end, this.size);
            this.size = this.boolVars.length;
            return subset;
        }
        if (this.type == TTypeId.TINYINT_TYPE) {
            ColumnBuffer subset = new ColumnBuffer(this.type, subNulls, Arrays.copyOfRange(this.byteVars, 0, end));
            this.byteVars = Arrays.copyOfRange(this.byteVars, end, this.size);
            this.nulls = this.nulls.get(end, this.size);
            this.size = this.byteVars.length;
            return subset;
        }
        if (this.type == TTypeId.SMALLINT_TYPE) {
            ColumnBuffer subset = new ColumnBuffer(this.type, subNulls, Arrays.copyOfRange(this.shortVars, 0, end));
            this.shortVars = Arrays.copyOfRange(this.shortVars, end, this.size);
            this.nulls = this.nulls.get(end, this.size);
            this.size = this.shortVars.length;
            return subset;
        }
        if (this.type == TTypeId.INT_TYPE) {
            ColumnBuffer subset = new ColumnBuffer(this.type, subNulls, Arrays.copyOfRange(this.intVars, 0, end));
            this.intVars = Arrays.copyOfRange(this.intVars, end, this.size);
            this.nulls = this.nulls.get(end, this.size);
            this.size = this.intVars.length;
            return subset;
        }
        if (this.type == TTypeId.BIGINT_TYPE) {
            ColumnBuffer subset = new ColumnBuffer(this.type, subNulls, Arrays.copyOfRange(this.longVars, 0, end));
            this.longVars = Arrays.copyOfRange(this.longVars, end, this.size);
            this.nulls = this.nulls.get(end, this.size);
            this.size = this.longVars.length;
            return subset;
        }
        if (this.type == TTypeId.DOUBLE_TYPE || this.type == TTypeId.FLOAT_TYPE) {
            ColumnBuffer subset = new ColumnBuffer(this.type, subNulls, Arrays.copyOfRange(this.doubleVars, 0, end));
            this.doubleVars = Arrays.copyOfRange(this.doubleVars, end, this.size);
            this.nulls = this.nulls.get(end, this.size);
            this.size = this.doubleVars.length;
            return subset;
        }
        if (this.type == TTypeId.BINARY_TYPE) {
            ColumnBuffer subset = new ColumnBuffer(this.type, subNulls, this.binaryVars.subList(0, end));
            this.binaryVars = this.binaryVars.subList(end, this.binaryVars.size());
            this.nulls = this.nulls.get(end, this.size);
            this.size = this.binaryVars.size();
            return subset;
        }
        if (this.type == TTypeId.STRING_TYPE) {
            ColumnBuffer subset = new ColumnBuffer(this.type, subNulls, this.stringVars.subList(0, end));
            this.stringVars = this.stringVars.subList(end, this.stringVars.size());
            this.nulls = this.nulls.get(end, this.size);
            this.size = this.stringVars.size();
            return subset;
        }
        throw new IllegalStateException("invalid union object");
    }

    public TTypeId getType() {
        return this.type;
    }

    @Override
    public Object get(int index) {
        if (this.nulls.get(index)) {
            return null;
        }
        switch (this.type) {
            case BOOLEAN_TYPE: {
                return this.boolVars[index];
            }
            case TINYINT_TYPE: {
                return this.byteVars[index];
            }
            case SMALLINT_TYPE: {
                return this.shortVars[index];
            }
            case INT_TYPE: {
                return this.intVars[index];
            }
            case BIGINT_TYPE: {
                return this.longVars[index];
            }
            case FLOAT_TYPE: 
            case DOUBLE_TYPE: {
                return this.doubleVars[index];
            }
            case STRING_TYPE: {
                return this.stringVars.get(index);
            }
            case BINARY_TYPE: {
                return this.binaryVars.get(index).array();
            }
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }
}

