/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.temporal.JSTemporalBuiltinOperation;
import com.oracle.truffle.js.builtins.temporal.TemporalCalendarPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.EnumerableOwnPropertyNamesNode;
import com.oracle.truffle.js.nodes.access.GetIteratorNode;
import com.oracle.truffle.js.nodes.access.IteratorCloseNode;
import com.oracle.truffle.js.nodes.access.IteratorStepNode;
import com.oracle.truffle.js.nodes.access.IteratorValueNode;
import com.oracle.truffle.js.nodes.binary.JSIdenticalNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerOrInfinityNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalDateNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalDurationNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendar;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainMonthDay;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainMonthDayObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonth;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonthObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalYearMonthDayRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.TemporalMonth;
import com.oracle.truffle.js.runtime.builtins.temporal.TemporalYear;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.ArrayList;
import java.util.EnumSet;

public class TemporalCalendarPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalCalendarPrototype> {
    public static final TemporalCalendarPrototypeBuiltins BUILTINS = new TemporalCalendarPrototypeBuiltins();

    protected TemporalCalendarPrototypeBuiltins() {
        super(JSTemporalCalendar.PROTOTYPE_NAME, TemporalCalendarPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalCalendarPrototype builtinEnum) {
        switch (builtinEnum) {
            case id: 
            case toString: 
            case toJSON: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarGetterNodeGen.create(context, builtin, builtinEnum, TemporalCalendarPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case mergeFields: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarMergeFieldsNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case fields: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarFieldsNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case dateFromFields: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarDateFromFieldsNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case yearMonthFromFields: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarYearMonthFromFieldsNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
            }
            case monthDayFromFields: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarMonthDayFromFieldsNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
            }
            case dateAdd: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarDateAddNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(4).createArgumentNodes(context));
            }
            case dateUntil: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarDateUntilNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
            }
            case year: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarYearNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case month: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarMonthNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case monthCode: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarMonthCodeNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case day: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarDayNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case dayOfWeek: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarDayOfWeekNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case dayOfYear: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarDayOfYearNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case daysInWeek: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarDaysInWeekNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case weekOfYear: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarWeekOfYearNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case daysInMonth: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarDaysInMonthNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case daysInYear: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarDaysInYearNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case monthsInYear: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarMonthsInYearNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case inLeapYear: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarInLeapYearNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum TemporalCalendarPrototype implements BuiltinEnum<TemporalCalendarPrototype>
    {
        id(0),
        mergeFields(2),
        fields(1),
        dateFromFields(1),
        yearMonthFromFields(1),
        monthDayFromFields(1),
        dateAdd(2),
        dateUntil(2),
        year(1),
        month(1),
        monthCode(1),
        day(1),
        dayOfWeek(1),
        dayOfYear(1),
        weekOfYear(1),
        daysInWeek(1),
        daysInMonth(1),
        daysInYear(1),
        monthsInYear(1),
        inLeapYear(1),
        toString(0),
        toJSON(0);

        private final int length;

        private TemporalCalendarPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return EnumSet.of(id).contains(this);
        }
    }

    public static abstract class JSTemporalCalendarGetterNode
    extends JSBuiltinNode {
        protected final TemporalCalendarPrototype property;

        protected JSTemporalCalendarGetterNode(JSContext context, JSBuiltin builtin, TemporalCalendarPrototype property) {
            super(context, builtin);
            this.property = property;
        }

        @Specialization
        protected Object id(JSTemporalCalendarObject calendar, @Cached JSToStringNode toStringNode) {
            switch (this.property) {
                case id: 
                case toString: {
                    return calendar.getId();
                }
                case toJSON: {
                    return toStringNode.executeString((Object)calendar);
                }
            }
            throw Errors.shouldNotReachHere();
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarMergeFields
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarMergeFields(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject mergeFields(JSTemporalCalendarObject calendar, Object fieldsParam, Object additionalFieldsParam, @Cached JSToObjectNode toObject, @Cached(value="createKeys(getContext())") EnumerableOwnPropertyNamesNode namesNode) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            JSDynamicObject fields = (JSDynamicObject)((Object)toObject.execute(fieldsParam));
            JSDynamicObject additionalFields = (JSDynamicObject)((Object)toObject.execute(additionalFieldsParam));
            return TemporalUtil.defaultMergeFields(this.getContext(), fields, additionalFields, namesNode);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object fieldsParam, Object additionalFieldsParam) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarFields
    extends JSTemporalBuiltinOperation {
        @Node.Child
        private IteratorCloseNode iteratorCloseNode;
        @Node.Child
        private IteratorValueNode getIteratorValueNode;
        @Node.Child
        private IteratorStepNode iteratorStepNode;

        protected void iteratorCloseAbrupt(JSDynamicObject iterator) {
            if (this.iteratorCloseNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.iteratorCloseNode = (IteratorCloseNode)this.insert(IteratorCloseNode.create(this.getContext()));
            }
            this.iteratorCloseNode.executeAbrupt(iterator);
        }

        protected Object getIteratorValue(JSDynamicObject iteratorResult) {
            if (this.getIteratorValueNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getIteratorValueNode = (IteratorValueNode)this.insert(IteratorValueNode.create());
            }
            return this.getIteratorValueNode.execute((Object)iteratorResult);
        }

        protected Object iteratorStep(IteratorRecord iterator) {
            if (this.iteratorStepNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.iteratorStepNode = (IteratorStepNode)this.insert(IteratorStepNode.create());
            }
            return this.iteratorStepNode.execute(iterator);
        }

        protected JSTemporalCalendarFields(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject fields(JSTemporalCalendarObject calendar, Object fieldsParam, @Cached(inline=true) GetIteratorNode getIteratorNode) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            IteratorRecord iter = getIteratorNode.execute(this, fieldsParam);
            ArrayList<TruffleString> fieldNames = new ArrayList<TruffleString>();
            Object next = Boolean.TRUE;
            while (next != Boolean.FALSE) {
                next = this.iteratorStep(iter);
                if (next == Boolean.FALSE) continue;
                Object nextValue = this.getIteratorValue((JSDynamicObject)((Object)next));
                if (!Strings.isTString(nextValue)) {
                    this.iteratorCloseAbrupt(iter.getIterator());
                    throw Errors.createTypeError("string expected");
                }
                TruffleString str = JSRuntime.toString(nextValue);
                if (str != null && Boundaries.listContains(fieldNames, str)) {
                    this.iteratorCloseAbrupt(iter.getIterator());
                    throw Errors.createRangeError("");
                }
                if (!(TemporalConstants.YEAR.equals((Object)str) || TemporalConstants.MONTH.equals((Object)str) || TemporalConstants.MONTH_CODE.equals((Object)str) || TemporalConstants.DAY.equals((Object)str) || TemporalConstants.HOUR.equals((Object)str) || TemporalConstants.MINUTE.equals((Object)str) || TemporalConstants.SECOND.equals((Object)str) || TemporalConstants.MILLISECOND.equals((Object)str) || TemporalConstants.MICROSECOND.equals((Object)str) || TemporalConstants.NANOSECOND.equals((Object)str))) {
                    this.iteratorCloseAbrupt(iter.getIterator());
                    throw Errors.createRangeError("");
                }
                fieldNames.add(str);
            }
            return JSRuntime.createArrayFromList(this.getContext(), this.getRealm(), fieldNames);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object fieldsParam) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarDateFromFields
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarDateFromFields(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object dateFromFields(JSTemporalCalendarObject calendar, Object fields, Object optionsParam, @Cached(value="createSameValue()") JSIdenticalNode identicalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached JSToIntegerOrInfinityNode toIntOrInfinityNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            if (!this.isObject(fields)) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createTypeErrorFieldsNotAnObject();
            }
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            JSTemporalDateTimeRecord result = TemporalUtil.isoDateFromFields((JSDynamicObject)((Object)fields), options, this.getContext(), this.isObjectNode, getOptionNode, toIntOrInfinityNode, identicalNode);
            return JSTemporalPlainDate.create(this.getContext(), result.getYear(), result.getMonth(), result.getDay(), calendar, this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object fields, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarYearMonthFromFields
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarYearMonthFromFields(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object yearMonthFromFields(JSTemporalCalendarObject calendar, Object fields, Object optionsParam, @Cached(value="createSameValue()") JSIdenticalNode identicalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached JSToIntegerOrInfinityNode toIntOrInfinityNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            if (!this.isObject(fields)) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createTypeErrorFieldsNotAnObject();
            }
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            JSTemporalYearMonthDayRecord result = TemporalUtil.isoYearMonthFromFields((JSDynamicObject)((Object)fields), options, this.getContext(), this.isObjectNode, getOptionNode, toIntOrInfinityNode, identicalNode);
            return JSTemporalPlainYearMonth.create(this.getContext(), result.getYear(), result.getMonth(), calendar, result.getDay(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object fields, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarMonthDayFromFields
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarMonthDayFromFields(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object monthDayFromFields(JSTemporalCalendarObject calendar, Object fields, Object optionsParam, @Cached(value="createSameValue()") JSIdenticalNode identicalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached JSToIntegerOrInfinityNode toIntOrInfinityNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            if (!this.isObject(fields)) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createTypeErrorFieldsNotAnObject();
            }
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            JSTemporalYearMonthDayRecord result = TemporalUtil.isoMonthDayFromFields((JSDynamicObject)((Object)fields), options, this.getContext(), this.isObjectNode, getOptionNode, toIntOrInfinityNode, identicalNode);
            return JSTemporalPlainMonthDay.create(this.getContext(), result.getMonth(), result.getDay(), calendar, result.getYear(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object fields, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarDateAdd
    extends JSTemporalBuiltinOperation {
        protected final ConditionProfile needConstrain = ConditionProfile.create();

        protected JSTemporalCalendarDateAdd(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object dateAdd(JSTemporalCalendarObject calendar, Object dateObj, Object durationObj, Object optionsParam, @Cached(value="create(getContext())") ToTemporalDurationNode toTemporalDurationNode, @Cached(value="createKeys(getContext())") EnumerableOwnPropertyNamesNode namesNode, @Cached(value="create(getContext())") ToTemporalDateNode toTemporalDate, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            JSTemporalPlainDateObject date = toTemporalDate.execute(dateObj, Undefined.instance);
            JSTemporalDurationObject duration = toTemporalDurationNode.execute(durationObj);
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            TemporalUtil.Overflow overflow = TemporalUtil.toTemporalOverflow(options, getOptionNode);
            JSTemporalDurationRecord balanceResult = TemporalUtil.balanceDuration(this.getContext(), namesNode, duration.getDays(), duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getMilliseconds(), duration.getMicroseconds(), duration.getNanoseconds(), TemporalUtil.Unit.DAY);
            JSTemporalDateTimeRecord result = TemporalUtil.addISODate(date.getYear(), date.getMonth(), date.getDay(), this.dtoiConstrain(duration.getYears()), this.dtoiConstrain(duration.getMonths()), this.dtoiConstrain(duration.getWeeks()), this.dtoiConstrain(balanceResult.getDays()), overflow);
            return JSTemporalPlainDate.create(this.getContext(), result.getYear(), result.getMonth(), result.getDay(), calendar, this, errorBranch);
        }

        protected int dtoiConstrain(double d) {
            if (this.needConstrain.profile(JSRuntime.doubleIsRepresentableAsInt(d))) {
                return (int)d;
            }
            return d > 0.0 ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object dateObj, Object durationObj, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarDateUntil
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarDateUntil(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object dateUntil(JSTemporalCalendarObject calendar, Object oneObj, Object twoObj, Object optionsParam, @Cached(value="create(getContext())") ToTemporalDateNode toTemporalDate, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            JSTemporalPlainDateObject one = toTemporalDate.execute(oneObj, Undefined.instance);
            JSTemporalPlainDateObject two = toTemporalDate.execute(twoObj, Undefined.instance);
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            TemporalUtil.Unit largestUnit = JSTemporalCalendarDateUntil.toLargestTemporalUnit(options, TemporalUtil.listTime, TemporalConstants.AUTO, TemporalUtil.Unit.DAY, equalNode, getOptionNode, this, errorBranch);
            JSTemporalDurationRecord result = JSTemporalPlainDate.differenceISODate(one.getYear(), one.getMonth(), one.getDay(), two.getYear(), two.getMonth(), two.getDay(), largestUnit);
            return JSTemporalDuration.createTemporalDuration(this.getContext(), result.getYears(), result.getMonths(), result.getWeeks(), result.getDays(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object oneObj, Object twoObj, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarYear
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarYear(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long year(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached(value="create(getContext())") ToTemporalDateNode toTemporalDate) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            if (JSTemporalPlainDate.isJSTemporalPlainDate(temporalDateLike)) {
                return ((JSTemporalPlainDateObject)temporalDateLike).getYear();
            }
            if (JSTemporalPlainYearMonth.isJSTemporalPlainYearMonth(temporalDateLike)) {
                return ((JSTemporalPlainYearMonthObject)temporalDateLike).getYear();
            }
            JSTemporalPlainDateObject td = toTemporalDate.execute(temporalDateLike, Undefined.instance);
            return td.getYear();
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarMonth
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarMonth(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long month(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached(value="create(getContext())") ToTemporalDateNode toTemporalDate) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            Object dateLike = temporalDateLike;
            if (JSTemporalPlainMonthDay.isJSTemporalPlainMonthDay(dateLike)) {
                throw Errors.createTypeError("PlainMonthDay not expected");
            }
            if (!this.isObject(dateLike) || !JSTemporalPlainDate.isJSTemporalPlainDate(dateLike) && !JSTemporalPlainDateTime.isJSTemporalPlainDateTime(dateLike) && !JSTemporalPlainYearMonth.isJSTemporalPlainYearMonth(dateLike)) {
                dateLike = toTemporalDate.execute(dateLike, Undefined.instance);
            }
            assert (dateLike instanceof TemporalMonth);
            return ((TemporalMonth)dateLike).getMonth();
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarMonthCode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarMonthCode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString monthCode(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached(value="create(getContext())") ToTemporalDateNode toTemporalDate) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            Object dateLike = temporalDateLike;
            if (!(this.isObject(dateLike) && (JSTemporalPlainDate.isJSTemporalPlainDate(dateLike) || JSTemporalPlainDateTime.isJSTemporalPlainDateTime(temporalDateLike) || dateLike instanceof JSTemporalPlainMonthDayObject || JSTemporalPlainYearMonth.isJSTemporalPlainYearMonth(dateLike)))) {
                dateLike = toTemporalDate.execute(dateLike, Undefined.instance);
            }
            return TemporalUtil.isoMonthCode((TemporalMonth)dateLike);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarDay
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarDay(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long day(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached(value="create(getContext())") ToTemporalDateNode toTemporalDate) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            JSDynamicObject tdl = Undefined.instance;
            tdl = !JSTemporalPlainDate.isJSTemporalPlainDate(temporalDateLike) && !JSTemporalPlainDateTime.isJSTemporalPlainDateTime(temporalDateLike) && !JSTemporalPlainMonthDay.isJSTemporalPlainMonthDay(temporalDateLike) ? toTemporalDate.execute(temporalDateLike, Undefined.instance) : (JSDynamicObject)((Object)temporalDateLike);
            return TemporalUtil.isoDay(tdl);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarDayOfWeek
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarDayOfWeek(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long dayOfWeek(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached(value="create(getContext())") ToTemporalDateNode toTemporalDate) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            JSTemporalPlainDateObject date = toTemporalDate.execute(temporalDateLike, Undefined.instance);
            return TemporalUtil.toISODayOfWeek(date.getYear(), date.getMonth(), date.getDay());
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarDayOfYear
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarDayOfYear(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long dayOfYear(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached(value="create(getContext())") ToTemporalDateNode toTemporalDate) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            JSTemporalPlainDateObject date = toTemporalDate.execute(temporalDateLike, Undefined.instance);
            return TemporalUtil.toISODayOfYear(date.getYear(), date.getMonth(), date.getDay());
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarDaysInWeek
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarDaysInWeek(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long daysInWeek(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached(value="create(getContext())") ToTemporalDateNode toTemporalDate) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            toTemporalDate.execute(temporalDateLike, Undefined.instance);
            return 7L;
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarWeekOfYear
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarWeekOfYear(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long weekOfYear(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached(value="create(getContext())") ToTemporalDateNode toTemporalDate) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            JSTemporalPlainDateObject date = toTemporalDate.execute(temporalDateLike, Undefined.instance);
            return TemporalUtil.toISOWeekOfYear(date.getYear(), date.getMonth(), date.getDay());
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarDaysInMonth
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarDaysInMonth(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long daysInMonth(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached(value="create(getContext())") ToTemporalDateNode toTemporalDate) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            Object dateLike = temporalDateLike;
            if (!this.isObject(dateLike) || !JSTemporalPlainDate.isJSTemporalPlainDate(dateLike) && !JSTemporalPlainYearMonth.isJSTemporalPlainYearMonth(temporalDateLike)) {
                dateLike = toTemporalDate.execute(dateLike, Undefined.instance);
            }
            return TemporalUtil.isoDaysInMonth(((TemporalYear)dateLike).getYear(), ((TemporalMonth)dateLike).getMonth());
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarDaysInYear
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarDaysInYear(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected int daysInYear(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached(value="create(getContext())") ToTemporalDateNode toTemporalDate) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            int year = 0;
            if (JSTemporalPlainDate.isJSTemporalPlainDate(temporalDateLike)) {
                year = ((JSTemporalPlainDateObject)temporalDateLike).getYear();
            } else if (JSTemporalPlainYearMonth.isJSTemporalPlainYearMonth(temporalDateLike)) {
                year = ((JSTemporalPlainYearMonthObject)temporalDateLike).getYear();
            } else {
                JSTemporalPlainDateObject dateLike = toTemporalDate.execute(temporalDateLike, Undefined.instance);
                year = dateLike.getYear();
            }
            return TemporalUtil.isoDaysInYear(year);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarMonthsInYear
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarMonthsInYear(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long monthsInYear(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached(value="create(getContext())") ToTemporalDateNode toTemporalDate) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            if (!JSTemporalPlainDate.isJSTemporalPlainDate(temporalDateLike) && !JSTemporalPlainYearMonth.isJSTemporalPlainYearMonth(temporalDateLike)) {
                toTemporalDate.execute(temporalDateLike, Undefined.instance);
            }
            return 12L;
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarInLeapYear
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarInLeapYear(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean inLeapYear(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached(value="create(getContext())") ToTemporalDateNode toTemporalDate) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            int year = 0;
            if (JSTemporalPlainDate.isJSTemporalPlainDate(temporalDateLike)) {
                year = ((JSTemporalPlainDateObject)temporalDateLike).getYear();
            } else if (JSTemporalPlainYearMonth.isJSTemporalPlainYearMonth(temporalDateLike)) {
                year = ((JSTemporalPlainYearMonthObject)temporalDateLike).getYear();
            } else {
                JSTemporalPlainDateObject dateLike = toTemporalDate.execute(temporalDateLike, Undefined.instance);
                year = dateLike.getYear();
            }
            return TemporalUtil.isISOLeapYear(year);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }
}

