/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.util.Utf8;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.hash.Hasher;
import org.apache.iceberg.relocated.com.google.common.hash.Hashing;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class PartitionData
implements IndexedRecord,
StructLike,
SpecificData.SchemaConstructable,
Serializable {
    private final Types.StructType partitionType;
    private final int size;
    private final Object[] data;
    private final String stringSchema;
    private transient Schema schema;

    static Schema partitionDataSchema(Types.StructType partitionType) {
        return AvroSchemaUtil.convert(partitionType, PartitionData.class.getName());
    }

    PartitionData(Schema schema) {
        this.partitionType = AvroSchemaUtil.convert(schema).asNestedType().asStructType();
        this.size = this.partitionType.fields().size();
        this.data = new Object[this.size];
        this.stringSchema = schema.toString();
        this.schema = schema;
    }

    public PartitionData(Types.StructType partitionType) {
        for (Types.NestedField field : partitionType.fields()) {
            Preconditions.checkArgument((boolean)field.type().isPrimitiveType(), (String)"Partitions cannot contain nested types: %s", (Object)field.type());
        }
        this.partitionType = partitionType;
        this.size = partitionType.fields().size();
        this.data = new Object[this.size];
        this.schema = PartitionData.partitionDataSchema(partitionType);
        this.stringSchema = this.schema.toString();
    }

    private PartitionData(PartitionData toCopy) {
        this.partitionType = toCopy.partitionType;
        this.size = toCopy.size;
        this.data = PartitionData.copyData(toCopy.partitionType, toCopy.data);
        this.stringSchema = toCopy.stringSchema;
        this.schema = toCopy.schema;
    }

    private PartitionData(PartitionData toCopy, StructLike partition) {
        this.partitionType = toCopy.partitionType;
        this.size = toCopy.size;
        this.data = PartitionData.copyData(this.partitionType, partition);
        this.stringSchema = toCopy.stringSchema;
        this.schema = toCopy.schema;
    }

    public Types.StructType getPartitionType() {
        return this.partitionType;
    }

    public Schema getSchema() {
        if (this.schema == null) {
            this.schema = new Schema.Parser().parse(this.stringSchema);
        }
        return this.schema;
    }

    public Type getType(int pos) {
        return ((Types.NestedField)this.partitionType.fields().get(pos)).type();
    }

    public void clear() {
        Arrays.fill(this.data, null);
    }

    public int size() {
        return this.size;
    }

    public <T> T get(int pos, Class<T> javaClass) {
        Object value = this.get(pos);
        if (value == null || javaClass.isInstance(value)) {
            return javaClass.cast(value);
        }
        throw new IllegalArgumentException(String.format("Wrong class, expected %s, but was %s, for object: %s", javaClass.getName(), value.getClass().getName(), value));
    }

    public Object get(int pos) {
        if (pos >= this.data.length) {
            return null;
        }
        if (this.data[pos] instanceof byte[]) {
            return ByteBuffer.wrap((byte[])this.data[pos]);
        }
        return this.data[pos];
    }

    public <T> void set(int pos, T value) {
        this.data[pos] = PartitionData.toInternalValue(value);
    }

    public void put(int i, Object v) {
        this.set(i, v);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PartitionData{");
        for (int i = 0; i < this.data.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(((Types.NestedField)this.partitionType.fields().get(i)).name()).append("=").append(this.data[i]);
        }
        sb.append("}");
        return sb.toString();
    }

    public PartitionData copy() {
        return new PartitionData(this);
    }

    public PartitionData copyFor(StructLike partition) {
        return new PartitionData(this, partition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartitionData)) {
            return false;
        }
        PartitionData that = (PartitionData)o;
        return this.partitionType.equals((Object)that.partitionType) && Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        Hasher hasher = Hashing.goodFastHash((int)32).newHasher();
        Stream.of(this.data).map(Objects::hashCode).forEach(arg_0 -> ((Hasher)hasher).putInt(arg_0));
        this.partitionType.fields().stream().map(Objects::hashCode).forEach(arg_0 -> ((Hasher)hasher).putInt(arg_0));
        return hasher.hash().hashCode();
    }

    public static Object[] copyData(Types.StructType type, Object[] data) {
        List fields = type.fields();
        Object[] copy = new Object[data.length];
        block5: for (int i = 0; i < data.length; ++i) {
            if (data[i] == null) {
                copy[i] = null;
                continue;
            }
            Types.NestedField field = (Types.NestedField)fields.get(i);
            switch (field.type().typeId()) {
                case STRUCT: 
                case LIST: 
                case MAP: {
                    throw new IllegalArgumentException("Unsupported type in partition data: " + type);
                }
                case BINARY: 
                case FIXED: {
                    byte[] buffer = (byte[])data[i];
                    copy[i] = Arrays.copyOf(buffer, buffer.length);
                    continue block5;
                }
                case STRING: {
                    copy[i] = data[i].toString();
                    continue block5;
                }
                default: {
                    copy[i] = data[i];
                }
            }
        }
        return copy;
    }

    private static Object[] copyData(Types.StructType type, StructLike partition) {
        List fields = type.fields();
        Object[] data = new Object[fields.size()];
        for (int pos = 0; pos < fields.size(); ++pos) {
            Types.NestedField field = (Types.NestedField)fields.get(pos);
            Class javaClass = field.type().typeId().javaClass();
            data[pos] = PartitionData.toInternalValue(partition.get(pos, javaClass));
        }
        return data;
    }

    private static Object toInternalValue(Object value) {
        if (value instanceof Utf8) {
            return value.toString();
        }
        if (value instanceof ByteBuffer) {
            ByteBuffer buffer = (ByteBuffer)value;
            byte[] bytes = new byte[buffer.remaining()];
            buffer.duplicate().get(bytes);
            return bytes;
        }
        return value;
    }
}

