/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.generic.IndexedRecord;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.IndexedStructLike;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

class V2Metadata {
    static final Schema MANIFEST_LIST_SCHEMA = new Schema(new Types.NestedField[]{ManifestFile.PATH, ManifestFile.LENGTH, ManifestFile.SPEC_ID, ManifestFile.MANIFEST_CONTENT.asRequired(), ManifestFile.SEQUENCE_NUMBER.asRequired(), ManifestFile.MIN_SEQUENCE_NUMBER.asRequired(), ManifestFile.SNAPSHOT_ID.asRequired(), ManifestFile.ADDED_FILES_COUNT.asRequired(), ManifestFile.EXISTING_FILES_COUNT.asRequired(), ManifestFile.DELETED_FILES_COUNT.asRequired(), ManifestFile.ADDED_ROWS_COUNT.asRequired(), ManifestFile.EXISTING_ROWS_COUNT.asRequired(), ManifestFile.DELETED_ROWS_COUNT.asRequired(), ManifestFile.PARTITION_SUMMARIES});

    private V2Metadata() {
    }

    static Schema entrySchema(Types.StructType partitionType) {
        return V2Metadata.wrapFileSchema(V2Metadata.fileType(partitionType));
    }

    static Schema wrapFileSchema(Types.StructType fileSchema) {
        return new Schema(new Types.NestedField[]{ManifestEntry.STATUS, ManifestEntry.SNAPSHOT_ID, ManifestEntry.SEQUENCE_NUMBER, ManifestEntry.FILE_SEQUENCE_NUMBER, Types.NestedField.required((int)2, (String)"data_file", (Type)fileSchema)});
    }

    static Types.StructType fileType(Types.StructType partitionType) {
        return Types.StructType.of((Types.NestedField[])new Types.NestedField[]{DataFile.CONTENT.asRequired(), DataFile.FILE_PATH, DataFile.FILE_FORMAT, Types.NestedField.required((int)102, (String)"partition", (Type)partitionType, (String)"Partition data tuple, schema based on the partition spec"), DataFile.RECORD_COUNT, DataFile.FILE_SIZE, DataFile.COLUMN_SIZES, DataFile.VALUE_COUNTS, DataFile.NULL_VALUE_COUNTS, DataFile.NAN_VALUE_COUNTS, DataFile.LOWER_BOUNDS, DataFile.UPPER_BOUNDS, DataFile.KEY_METADATA, DataFile.SPLIT_OFFSETS, DataFile.EQUALITY_IDS, DataFile.SORT_ORDER_ID});
    }

    static class IndexedDataFile<F>
    implements ContentFile<F>,
    IndexedRecord {
        private final org.apache.avro.Schema avroSchema;
        private final IndexedStructLike partitionWrapper;
        private ContentFile<F> wrapped = null;

        IndexedDataFile(Types.StructType partitionType) {
            this.avroSchema = AvroSchemaUtil.convert(V2Metadata.fileType(partitionType), "data_file");
            this.partitionWrapper = new IndexedStructLike(this.avroSchema.getField("partition").schema());
        }

        IndexedDataFile<F> wrap(ContentFile<?> file) {
            this.wrapped = file;
            return this;
        }

        public org.apache.avro.Schema getSchema() {
            return this.avroSchema;
        }

        public Object get(int pos) {
            switch (pos) {
                case 0: {
                    return this.wrapped.content().id();
                }
                case 1: {
                    return this.wrapped.path().toString();
                }
                case 2: {
                    return this.wrapped.format() != null ? this.wrapped.format().toString() : null;
                }
                case 3: {
                    return this.partitionWrapper.wrap(this.wrapped.partition());
                }
                case 4: {
                    return this.wrapped.recordCount();
                }
                case 5: {
                    return this.wrapped.fileSizeInBytes();
                }
                case 6: {
                    return this.wrapped.columnSizes();
                }
                case 7: {
                    return this.wrapped.valueCounts();
                }
                case 8: {
                    return this.wrapped.nullValueCounts();
                }
                case 9: {
                    return this.wrapped.nanValueCounts();
                }
                case 10: {
                    return this.wrapped.lowerBounds();
                }
                case 11: {
                    return this.wrapped.upperBounds();
                }
                case 12: {
                    return this.wrapped.keyMetadata();
                }
                case 13: {
                    return this.wrapped.splitOffsets();
                }
                case 14: {
                    return this.wrapped.equalityFieldIds();
                }
                case 15: {
                    return this.wrapped.sortOrderId();
                }
            }
            throw new IllegalArgumentException("Unknown field ordinal: " + pos);
        }

        public void put(int i, Object v) {
            throw new UnsupportedOperationException("Cannot modify IndexedDataFile wrapper via put");
        }

        public Long pos() {
            return null;
        }

        public int specId() {
            return this.wrapped.specId();
        }

        public FileContent content() {
            return this.wrapped.content();
        }

        public CharSequence path() {
            return this.wrapped.path();
        }

        public FileFormat format() {
            return this.wrapped.format();
        }

        public StructLike partition() {
            return this.wrapped.partition();
        }

        public long recordCount() {
            return this.wrapped.recordCount();
        }

        public long fileSizeInBytes() {
            return this.wrapped.fileSizeInBytes();
        }

        public Map<Integer, Long> columnSizes() {
            return this.wrapped.columnSizes();
        }

        public Map<Integer, Long> valueCounts() {
            return this.wrapped.valueCounts();
        }

        public Map<Integer, Long> nullValueCounts() {
            return this.wrapped.nullValueCounts();
        }

        public Map<Integer, Long> nanValueCounts() {
            return this.wrapped.nanValueCounts();
        }

        public Map<Integer, ByteBuffer> lowerBounds() {
            return this.wrapped.lowerBounds();
        }

        public Map<Integer, ByteBuffer> upperBounds() {
            return this.wrapped.upperBounds();
        }

        public ByteBuffer keyMetadata() {
            return this.wrapped.keyMetadata();
        }

        public List<Long> splitOffsets() {
            return this.wrapped.splitOffsets();
        }

        public List<Integer> equalityFieldIds() {
            return this.wrapped.equalityFieldIds();
        }

        public Integer sortOrderId() {
            return this.wrapped.sortOrderId();
        }

        public Long dataSequenceNumber() {
            return this.wrapped.dataSequenceNumber();
        }

        public Long fileSequenceNumber() {
            return this.wrapped.fileSequenceNumber();
        }

        public F copy() {
            throw new UnsupportedOperationException("Cannot copy IndexedDataFile wrapper");
        }

        public F copyWithStats(Set<Integer> requestedColumnIds) {
            throw new UnsupportedOperationException("Cannot copy IndexedDataFile wrapper");
        }

        public F copyWithoutStats() {
            throw new UnsupportedOperationException("Cannot copy IndexedDataFile wrapper");
        }
    }

    static class IndexedManifestEntry<F extends ContentFile<F>>
    implements ManifestEntry<F>,
    IndexedRecord {
        private final org.apache.avro.Schema avroSchema;
        private final Long commitSnapshotId;
        private final IndexedDataFile<?> fileWrapper;
        private ManifestEntry<F> wrapped = null;

        IndexedManifestEntry(Long commitSnapshotId, Types.StructType partitionType) {
            this.avroSchema = AvroSchemaUtil.convert(V2Metadata.entrySchema(partitionType), "manifest_entry");
            this.commitSnapshotId = commitSnapshotId;
            this.fileWrapper = new IndexedDataFile(partitionType);
        }

        public IndexedManifestEntry<F> wrap(ManifestEntry<F> entry) {
            this.wrapped = entry;
            return this;
        }

        public org.apache.avro.Schema getSchema() {
            return this.avroSchema;
        }

        public void put(int i, Object v) {
            throw new UnsupportedOperationException("Cannot modify IndexedManifestEntry wrapper via put");
        }

        public Object get(int i) {
            switch (i) {
                case 0: {
                    return this.wrapped.status().id();
                }
                case 1: {
                    return this.wrapped.snapshotId();
                }
                case 2: {
                    if (this.wrapped.dataSequenceNumber() == null) {
                        Preconditions.checkState((this.wrapped.snapshotId() == null || this.wrapped.snapshotId().equals(this.commitSnapshotId) ? 1 : 0) != 0, (String)"Found unassigned sequence number for an entry from snapshot: %s", (Object)this.wrapped.snapshotId());
                        Preconditions.checkState((this.wrapped.status() == ManifestEntry.Status.ADDED ? 1 : 0) != 0, (Object)"Only entries with status ADDED can have null sequence number");
                        return null;
                    }
                    return this.wrapped.dataSequenceNumber();
                }
                case 3: {
                    return this.wrapped.fileSequenceNumber();
                }
                case 4: {
                    return this.fileWrapper.wrap((ContentFile<?>)this.wrapped.file());
                }
            }
            throw new UnsupportedOperationException("Unknown field ordinal: " + i);
        }

        @Override
        public ManifestEntry.Status status() {
            return this.wrapped.status();
        }

        @Override
        public Long snapshotId() {
            return this.wrapped.snapshotId();
        }

        @Override
        public void setSnapshotId(long snapshotId) {
            this.wrapped.setSnapshotId(snapshotId);
        }

        @Override
        public Long dataSequenceNumber() {
            return this.wrapped.dataSequenceNumber();
        }

        @Override
        public void setDataSequenceNumber(long dataSequenceNumber) {
            this.wrapped.setDataSequenceNumber(dataSequenceNumber);
        }

        @Override
        public Long fileSequenceNumber() {
            return this.wrapped.fileSequenceNumber();
        }

        @Override
        public void setFileSequenceNumber(long fileSequenceNumber) {
            this.wrapped.setFileSequenceNumber(fileSequenceNumber);
        }

        @Override
        public F file() {
            return this.wrapped.file();
        }

        @Override
        public ManifestEntry<F> copy() {
            return this.wrapped.copy();
        }

        @Override
        public ManifestEntry<F> copyWithoutStats() {
            return this.wrapped.copyWithoutStats();
        }
    }

    static class IndexedManifestFile
    implements ManifestFile,
    IndexedRecord {
        private static final org.apache.avro.Schema AVRO_SCHEMA = AvroSchemaUtil.convert(MANIFEST_LIST_SCHEMA, "manifest_file");
        private final long commitSnapshotId;
        private final long sequenceNumber;
        private ManifestFile wrapped = null;

        IndexedManifestFile(long commitSnapshotId, long sequenceNumber) {
            this.commitSnapshotId = commitSnapshotId;
            this.sequenceNumber = sequenceNumber;
        }

        public ManifestFile wrap(ManifestFile file) {
            this.wrapped = file;
            return this;
        }

        public org.apache.avro.Schema getSchema() {
            return AVRO_SCHEMA;
        }

        public void put(int i, Object v) {
            throw new UnsupportedOperationException("Cannot modify IndexedManifestFile wrapper via put");
        }

        public Object get(int pos) {
            switch (pos) {
                case 0: {
                    return this.wrapped.path();
                }
                case 1: {
                    return this.wrapped.length();
                }
                case 2: {
                    return this.wrapped.partitionSpecId();
                }
                case 3: {
                    return this.wrapped.content().id();
                }
                case 4: {
                    if (this.wrapped.sequenceNumber() == -1L) {
                        Preconditions.checkState((this.commitSnapshotId == this.wrapped.snapshotId() ? 1 : 0) != 0, (String)"Found unassigned sequence number for a manifest from snapshot: %s", (Object)this.wrapped.snapshotId());
                        return this.sequenceNumber;
                    }
                    return this.wrapped.sequenceNumber();
                }
                case 5: {
                    if (this.wrapped.minSequenceNumber() == -1L) {
                        Preconditions.checkState((this.commitSnapshotId == this.wrapped.snapshotId() ? 1 : 0) != 0, (String)"Found unassigned sequence number for a manifest from snapshot: %s", (Object)this.wrapped.snapshotId());
                        return this.sequenceNumber;
                    }
                    return this.wrapped.minSequenceNumber();
                }
                case 6: {
                    return this.wrapped.snapshotId();
                }
                case 7: {
                    return this.wrapped.addedFilesCount();
                }
                case 8: {
                    return this.wrapped.existingFilesCount();
                }
                case 9: {
                    return this.wrapped.deletedFilesCount();
                }
                case 10: {
                    return this.wrapped.addedRowsCount();
                }
                case 11: {
                    return this.wrapped.existingRowsCount();
                }
                case 12: {
                    return this.wrapped.deletedRowsCount();
                }
                case 13: {
                    return this.wrapped.partitions();
                }
                case 14: {
                    return this.wrapped.keyMetadata();
                }
            }
            throw new UnsupportedOperationException("Unknown field ordinal: " + pos);
        }

        public String path() {
            return this.wrapped.path();
        }

        public long length() {
            return this.wrapped.length();
        }

        public int partitionSpecId() {
            return this.wrapped.partitionSpecId();
        }

        public ManifestContent content() {
            return this.wrapped.content();
        }

        public long sequenceNumber() {
            return this.wrapped.sequenceNumber();
        }

        public long minSequenceNumber() {
            return this.wrapped.minSequenceNumber();
        }

        public Long snapshotId() {
            return this.wrapped.snapshotId();
        }

        public boolean hasAddedFiles() {
            return this.wrapped.hasAddedFiles();
        }

        public Integer addedFilesCount() {
            return this.wrapped.addedFilesCount();
        }

        public Long addedRowsCount() {
            return this.wrapped.addedRowsCount();
        }

        public boolean hasExistingFiles() {
            return this.wrapped.hasExistingFiles();
        }

        public Integer existingFilesCount() {
            return this.wrapped.existingFilesCount();
        }

        public Long existingRowsCount() {
            return this.wrapped.existingRowsCount();
        }

        public boolean hasDeletedFiles() {
            return this.wrapped.hasDeletedFiles();
        }

        public Integer deletedFilesCount() {
            return this.wrapped.deletedFilesCount();
        }

        public Long deletedRowsCount() {
            return this.wrapped.deletedRowsCount();
        }

        public List<ManifestFile.PartitionFieldSummary> partitions() {
            return this.wrapped.partitions();
        }

        public ByteBuffer keyMetadata() {
            return this.wrapped.keyMetadata();
        }

        public ManifestFile copy() {
            return this.wrapped.copy();
        }
    }
}

