/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import javax.ws.rs.core.Response;
import org.apache.iceberg.rest.responses.ErrorResponse;

public class IcebergRestUtils {
    private IcebergRestUtils() {
    }

    public static <T> Response ok(T t) {
        return Response.status((Response.Status)Response.Status.OK).entity(t).type("application/json").build();
    }

    public static Response okWithoutContent() {
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    public static Response noContent() {
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public static Response notExists() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    public static Response errorResponse(Exception ex, int httpStatus) {
        ErrorResponse errorResponse = ErrorResponse.builder().responseCode(Integer.valueOf(httpStatus)).withType(ex.getClass().getSimpleName()).withMessage(ex.getMessage()).withStackTrace((Throwable)ex).build();
        return Response.status((int)httpStatus).entity((Object)errorResponse).type("application/json").build();
    }

    public static Instant calculateNewTimestamp(Instant currentTimestamp, int hours) {
        LocalDateTime currentDateTime = LocalDateTime.ofInstant(currentTimestamp, ZoneId.systemDefault());
        LocalDateTime nextHourDateTime = hours > 0 ? currentDateTime.plusHours(hours) : currentDateTime.minusHours(-hours);
        return nextHourDateTime.atZone(ZoneId.systemDefault()).toInstant();
    }
}

