/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.iceberg.common.ops.IcebergTableOps;
import org.apache.gravitino.iceberg.service.IcebergObjectMapper;
import org.apache.gravitino.iceberg.service.IcebergRestUtils;
import org.apache.gravitino.iceberg.service.metrics.IcebergMetricsManager;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.ReportMetricsRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/{prefix:([^/]*/)?}namespaces/{namespace}/tables")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IcebergTableOperations {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergTableOperations.class);
    private IcebergTableOps icebergTableOps;
    private IcebergMetricsManager icebergMetricsManager;
    private ObjectMapper icebergObjectMapper;
    @Context
    private HttpServletRequest httpRequest;

    @Inject
    public IcebergTableOperations(IcebergTableOps icebergTableOps, IcebergMetricsManager icebergMetricsManager) {
        this.icebergTableOps = icebergTableOps;
        this.icebergObjectMapper = IcebergObjectMapper.getInstance();
        this.icebergMetricsManager = icebergMetricsManager;
    }

    @GET
    @Produces(value={"application/json"})
    @Timed(name="list-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-table", absolute=true)
    public Response listTable(@PathParam(value="namespace") String namespace) {
        return IcebergRestUtils.ok(this.icebergTableOps.listTable(RESTUtil.decodeNamespace((String)namespace)));
    }

    @POST
    @Produces(value={"application/json"})
    @Timed(name="create-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="create-table", absolute=true)
    public Response createTable(@PathParam(value="namespace") String namespace, CreateTableRequest createTableRequest) {
        LOG.info("Create Iceberg table, namespace: {}, create table request: {}", (Object)namespace, (Object)createTableRequest);
        return IcebergRestUtils.ok(this.icebergTableOps.createTable(RESTUtil.decodeNamespace((String)namespace), createTableRequest));
    }

    @POST
    @Path(value="{table}")
    @Produces(value={"application/json"})
    @Timed(name="update-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="update-table", absolute=true)
    public Response updateTable(@PathParam(value="namespace") String namespace, @PathParam(value="table") String table, UpdateTableRequest updateTableRequest) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Update Iceberg table, namespace: {}, table: {}, updateTableRequest: {}", new Object[]{namespace, table, this.SerializeUpdateTableRequest(updateTableRequest)});
        }
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)RESTUtil.decodeNamespace((String)namespace), (String)table);
        return IcebergRestUtils.ok(this.icebergTableOps.updateTable(tableIdentifier, updateTableRequest));
    }

    @DELETE
    @Path(value="{table}")
    @Produces(value={"application/json"})
    @Timed(name="drop-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="drop-table", absolute=true)
    public Response dropTable(@PathParam(value="namespace") String namespace, @PathParam(value="table") String table, @DefaultValue(value="false") @QueryParam(value="purgeRequested") boolean purgeRequested) {
        LOG.info("Drop Iceberg table, namespace: {}, table: {}, purgeRequested: {}", new Object[]{namespace, table, purgeRequested});
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)RESTUtil.decodeNamespace((String)namespace), (String)table);
        if (purgeRequested) {
            this.icebergTableOps.purgeTable(tableIdentifier);
        } else {
            this.icebergTableOps.dropTable(tableIdentifier);
        }
        return IcebergRestUtils.noContent();
    }

    @GET
    @Path(value="{table}")
    @Produces(value={"application/json"})
    @Timed(name="load-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="load-table", absolute=true)
    public Response loadTable(@PathParam(value="namespace") String namespace, @PathParam(value="table") String table, @DefaultValue(value="all") @QueryParam(value="snapshots") String snapshots) {
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)RESTUtil.decodeNamespace((String)namespace), (String)table);
        return IcebergRestUtils.ok(this.icebergTableOps.loadTable(tableIdentifier));
    }

    @HEAD
    @Path(value="{table}")
    @Produces(value={"application/json"})
    @Timed(name="table-exists.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="table-exits", absolute=true)
    public Response tableExists(@PathParam(value="namespace") String namespace, @PathParam(value="table") String table) {
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)RESTUtil.decodeNamespace((String)namespace), (String)table);
        if (this.icebergTableOps.tableExists(tableIdentifier)) {
            return IcebergRestUtils.okWithoutContent();
        }
        return IcebergRestUtils.notExists();
    }

    @POST
    @Path(value="{table}/metrics")
    @Produces(value={"application/json"})
    @Timed(name="report-table-metrics.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="report-table-metrics", absolute=true)
    public Response reportTableMetrics(@PathParam(value="namespace") String namespace, @PathParam(value="table") String table, ReportMetricsRequest request) {
        this.icebergMetricsManager.recordMetric(request.report());
        return IcebergRestUtils.noContent();
    }

    private String SerializeUpdateTableRequest(UpdateTableRequest updateTableRequest) {
        try {
            return this.icebergObjectMapper.writeValueAsString((Object)updateTableRequest);
        }
        catch (JsonProcessingException e) {
            LOG.warn("Serialize update table request failed", (Throwable)e);
            return updateTableRequest.toString();
        }
    }
}

