/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.vti;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.vti.RestrictedVTI;
import org.apache.derby.vti.Restriction;
import org.apache.derby.vti.VTITemplate;

public class ForeignTableVTI
extends VTITemplate
implements RestrictedVTI {
    private static HashMap _connections = new HashMap();
    private String _foreignSchemaName;
    private String _foreignTableName;
    private String _connectionURL;
    private String[] _columnNames;
    private Restriction _restriction;
    private int[] _columnNumberMap;
    private PreparedStatement _foreignPreparedStatement;
    private ResultSet _foreignResultSet;

    protected ForeignTableVTI(String string, String string2, String string3) {
        this._foreignSchemaName = string;
        this._foreignTableName = string2;
        this._connectionURL = string3;
    }

    public static ForeignTableVTI readForeignTable(String string, String string2, String string3) {
        return new ForeignTableVTI(string, string2, string3);
    }

    public void close() throws SQLException {
        if (!this.isClosed()) {
            this._foreignSchemaName = null;
            this._foreignTableName = null;
            this._connectionURL = null;
            this._columnNames = null;
            this._restriction = null;
            this._columnNumberMap = null;
            if (this._foreignResultSet != null) {
                this._foreignResultSet.close();
            }
            if (this._foreignPreparedStatement != null) {
                this._foreignPreparedStatement.close();
            }
            this._foreignResultSet = null;
            this._foreignPreparedStatement = null;
        }
    }

    public boolean next() throws SQLException {
        if (!this.isClosed() && this._foreignResultSet == null) {
            this._foreignPreparedStatement = ForeignTableVTI.prepareStatement(ForeignTableVTI.getForeignConnection(this._connectionURL), this.makeQuery());
            this._foreignResultSet = this._foreignPreparedStatement.executeQuery();
        }
        return this._foreignResultSet.next();
    }

    public boolean isClosed() {
        return this._connectionURL == null;
    }

    public boolean wasNull() throws SQLException {
        return this._foreignResultSet.wasNull();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this._foreignResultSet.getMetaData();
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        return this._foreignResultSet.getAsciiStream(this.mapColumnNumber(n));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this._foreignResultSet.getBigDecimal(this.mapColumnNumber(n));
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this._foreignResultSet.getBigDecimal(this.mapColumnNumber(n), n2);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        return this._foreignResultSet.getBinaryStream(this.mapColumnNumber(n));
    }

    public Blob getBlob(int n) throws SQLException {
        return this._foreignResultSet.getBlob(this.mapColumnNumber(n));
    }

    public boolean getBoolean(int n) throws SQLException {
        return this._foreignResultSet.getBoolean(this.mapColumnNumber(n));
    }

    public byte getByte(int n) throws SQLException {
        return this._foreignResultSet.getByte(this.mapColumnNumber(n));
    }

    public byte[] getBytes(int n) throws SQLException {
        return this._foreignResultSet.getBytes(this.mapColumnNumber(n));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        return this._foreignResultSet.getCharacterStream(this.mapColumnNumber(n));
    }

    public Clob getClob(int n) throws SQLException {
        return this._foreignResultSet.getClob(this.mapColumnNumber(n));
    }

    public Date getDate(int n) throws SQLException {
        return this._foreignResultSet.getDate(this.mapColumnNumber(n));
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this._foreignResultSet.getDate(this.mapColumnNumber(n), calendar);
    }

    public double getDouble(int n) throws SQLException {
        return this._foreignResultSet.getDouble(this.mapColumnNumber(n));
    }

    public float getFloat(int n) throws SQLException {
        return this._foreignResultSet.getFloat(this.mapColumnNumber(n));
    }

    public int getInt(int n) throws SQLException {
        return this._foreignResultSet.getInt(this.mapColumnNumber(n));
    }

    public long getLong(int n) throws SQLException {
        return this._foreignResultSet.getLong(this.mapColumnNumber(n));
    }

    public Object getObject(int n) throws SQLException {
        return this._foreignResultSet.getObject(this.mapColumnNumber(n));
    }

    public short getShort(int n) throws SQLException {
        return this._foreignResultSet.getShort(this.mapColumnNumber(n));
    }

    public String getString(int n) throws SQLException {
        return this._foreignResultSet.getString(this.mapColumnNumber(n));
    }

    public Time getTime(int n) throws SQLException {
        return this._foreignResultSet.getTime(this.mapColumnNumber(n));
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this._foreignResultSet.getTime(this.mapColumnNumber(n), calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this._foreignResultSet.getTimestamp(this.mapColumnNumber(n));
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this._foreignResultSet.getTimestamp(this.mapColumnNumber(n), calendar);
    }

    public void initScan(String[] stringArray, Restriction restriction) throws SQLException {
        this._columnNames = stringArray;
        this._restriction = restriction;
        int n = this._columnNames.length;
        this._columnNumberMap = new int[n];
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            if (stringArray[i] == null) continue;
            this._columnNumberMap[i] = n2++;
        }
    }

    private static Connection getForeignConnection(String string) throws SQLException {
        Connection connection = (Connection)_connections.get(string);
        if (connection == null && (connection = DriverManager.getConnection(string)) != null) {
            _connections.put(string, connection);
        }
        return connection;
    }

    private String makeQuery() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select ");
        int n = this._columnNames.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string2 = this._columnNames[i];
            if (string2 == null) continue;
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            ++n2;
            stringBuilder.append(ForeignTableVTI.delimitedID(string2));
        }
        stringBuilder.append("\nfrom ");
        stringBuilder.append(ForeignTableVTI.delimitedID(this._foreignSchemaName));
        stringBuilder.append('.');
        stringBuilder.append(ForeignTableVTI.delimitedID(this._foreignTableName));
        if (this._restriction != null && (string = this._restriction.toSQL()) != null && (string = string.trim()).length() != 0) {
            stringBuilder.append("\nwhere " + string);
        }
        return stringBuilder.toString();
    }

    private static String delimitedID(String string) {
        return IdUtil.normalToDelimited(string);
    }

    private static PreparedStatement prepareStatement(Connection connection, String string) throws SQLException {
        return connection.prepareStatement(string);
    }

    private int mapColumnNumber(int n) {
        return this._columnNumberMap[n - 1];
    }
}

