/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.metalake;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.gravitino.Metalake;
import org.apache.gravitino.MetalakeChange;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.exceptions.MetalakeAlreadyExistsException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.metalake.MetalakeDispatcher;

public class MetalakeNormalizeDispatcher
implements MetalakeDispatcher {
    private static final Set<String> RESERVED_WORDS = ImmutableSet.of((Object)"system");
    private static final String METALAKE_NAME_PATTERN = "^\\w[\\w]{0,63}$";
    private final MetalakeDispatcher dispatcher;

    public MetalakeNormalizeDispatcher(MetalakeDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public Metalake[] listMetalakes() {
        return this.dispatcher.listMetalakes();
    }

    @Override
    public Metalake loadMetalake(NameIdentifier ident) throws NoSuchMetalakeException {
        return this.dispatcher.loadMetalake(ident);
    }

    @Override
    public boolean metalakeExists(NameIdentifier ident) {
        return this.dispatcher.metalakeExists(ident);
    }

    @Override
    public Metalake createMetalake(NameIdentifier ident, String comment, Map<String, String> properties) throws MetalakeAlreadyExistsException {
        this.validateMetalakeName(ident.name());
        return this.dispatcher.createMetalake(ident, comment, properties);
    }

    @Override
    public Metalake alterMetalake(NameIdentifier ident, MetalakeChange ... changes) throws NoSuchMetalakeException, IllegalArgumentException {
        Arrays.stream(changes).forEach(change -> {
            if (change instanceof MetalakeChange.RenameMetalake) {
                this.validateMetalakeName(((MetalakeChange.RenameMetalake)change).getNewName());
            }
        });
        return this.dispatcher.alterMetalake(ident, changes);
    }

    @Override
    public boolean dropMetalake(NameIdentifier ident) {
        return this.dispatcher.dropMetalake(ident);
    }

    private void validateMetalakeName(String name) {
        if (RESERVED_WORDS.contains(name)) {
            throw new IllegalArgumentException("The metalake name '" + name + "' is reserved.");
        }
        if (!name.matches(METALAKE_NAME_PATTERN)) {
            throw new IllegalArgumentException("The metalake name '" + name + "' is illegal.");
        }
    }
}

