/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.proto;

import java.util.Collection;
import java.util.List;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.meta.GroupEntity;
import org.apache.gravitino.proto.AuditInfoSerDe;
import org.apache.gravitino.proto.Group;
import org.apache.gravitino.proto.ProtoSerDe;

public class GroupEntitySerDe
implements ProtoSerDe<GroupEntity, Group> {
    @Override
    public Group serialize(GroupEntity groupEntity) {
        Group.Builder builder = Group.newBuilder().setId(groupEntity.id().longValue()).setName(groupEntity.name()).setAuditInfo(new AuditInfoSerDe().serialize(groupEntity.auditInfo()));
        if (this.isCollectionNotEmpty(groupEntity.roles())) {
            builder.addAllRoleNames(groupEntity.roles());
        }
        if (this.isCollectionNotEmpty(groupEntity.roleIds())) {
            builder.addAllRoleIds(groupEntity.roleIds());
        }
        return builder.build();
    }

    @Override
    public GroupEntity deserialize(Group group, Namespace namespace) {
        GroupEntity.Builder builder = GroupEntity.builder().withId(group.getId()).withName(group.getName()).withNamespace(namespace).withAuditInfo(new AuditInfoSerDe().deserialize(group.getAuditInfo(), namespace));
        if (group.getRoleNamesCount() > 0) {
            builder.withRoleNames((List<String>)group.getRoleNamesList());
        }
        if (group.getRoleIdsCount() > 0) {
            builder.withRoleIds(group.getRoleIdsList());
        }
        return builder.build();
    }

    private boolean isCollectionNotEmpty(Collection collection) {
        return collection != null && !collection.isEmpty();
    }
}

