/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.proto;

import org.apache.gravitino.Namespace;
import org.apache.gravitino.meta.TopicEntity;
import org.apache.gravitino.proto.AuditInfoSerDe;
import org.apache.gravitino.proto.ProtoSerDe;
import org.apache.gravitino.proto.Topic;

public class TopicEntitySerDe
implements ProtoSerDe<TopicEntity, Topic> {
    @Override
    public Topic serialize(TopicEntity topicEntity) {
        Topic.Builder builder = Topic.newBuilder().setId(topicEntity.id().longValue()).setName(topicEntity.name()).setAuditInfo(new AuditInfoSerDe().serialize(topicEntity.auditInfo()));
        if (topicEntity.comment() != null) {
            builder.setComment(topicEntity.comment());
        }
        if (topicEntity.properties() != null && !topicEntity.properties().isEmpty()) {
            builder.putAllProperties(topicEntity.properties());
        }
        return builder.build();
    }

    @Override
    public TopicEntity deserialize(Topic p, Namespace namespace) {
        TopicEntity.Builder builder = TopicEntity.builder().withId(p.getId()).withName(p.getName()).withNamespace(namespace).withAuditInfo(new AuditInfoSerDe().deserialize(p.getAuditInfo(), namespace));
        if (p.hasComment()) {
            builder.withComment(p.getComment());
        }
        if (p.getPropertiesCount() > 0) {
            builder.withProperties(p.getPropertiesMap());
        }
        return builder.build();
    }
}

