/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.SecurableObjectBaseSQLProvider;
import org.apache.gravitino.storage.relational.po.SecurableObjectPO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class SecurableObjectSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, SecurableObjectBaseSQLProvider> METALAKE_META_SQL_PROVIDER_MAP = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new SecurableObjectMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new SecurableObjectH2Provider());

    public static SecurableObjectBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return METALAKE_META_SQL_PROVIDER_MAP.get((Object)jdbcBackendType);
    }

    public static String batchInsertSecurableObjects(@Param(value="securableObjects") List<SecurableObjectPO> securableObjectPOs) {
        return SecurableObjectSQLProviderFactory.getProvider().batchInsertSecurableObjects(securableObjectPOs);
    }

    public static String batchSoftDeleteSecurableObjects(@Param(value="securableObjects") List<SecurableObjectPO> securableObjectPOs) {
        return SecurableObjectSQLProviderFactory.getProvider().batchSoftDeleteSecurableObjects(securableObjectPOs);
    }

    public static String softDeleteSecurableObjectsByRoleId(@Param(value="roleId") Long roleId) {
        return SecurableObjectSQLProviderFactory.getProvider().softDeleteSecurableObjectsByRoleId(roleId);
    }

    public static String softDeleteRoleMetasByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return SecurableObjectSQLProviderFactory.getProvider().softDeleteRoleMetasByMetalakeId(metalakeId);
    }

    public static String listSecurableObjectsByRoleId(@Param(value="roleId") Long roleId) {
        return SecurableObjectSQLProviderFactory.getProvider().listSecurableObjectsByRoleId(roleId);
    }

    public static String deleteSecurableObjectsByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return SecurableObjectSQLProviderFactory.getProvider().deleteSecurableObjectsByLegacyTimeline(legacyTimeline, limit);
    }

    static class SecurableObjectH2Provider
    extends SecurableObjectBaseSQLProvider {
        SecurableObjectH2Provider() {
        }
    }

    static class SecurableObjectMySQLProvider
    extends SecurableObjectBaseSQLProvider {
        SecurableObjectMySQLProvider() {
        }
    }
}

