/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.TagMetadataObjectRelBaseSQLProvider;
import org.apache.gravitino.storage.relational.po.TagMetadataObjectRelPO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class TagMetadataObjectRelSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, TagMetadataObjectRelBaseSQLProvider> METALAKE_META_SQL_PROVIDER_MAP = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new TagMetadataObjectRelMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new TagMetadataObjectRelH2Provider());

    public static TagMetadataObjectRelBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return METALAKE_META_SQL_PROVIDER_MAP.get((Object)jdbcBackendType);
    }

    public static String listTagPOsByMetadataObjectIdAndType(@Param(value="metadataObjectId") Long metadataObjectId, @Param(value="metadataObjectType") String metadataObjectType) {
        return TagMetadataObjectRelSQLProviderFactory.getProvider().listTagPOsByMetadataObjectIdAndType(metadataObjectId, metadataObjectType);
    }

    public static String getTagPOsByMetadataObjectAndTagName(@Param(value="metadataObjectId") Long metadataObjectId, @Param(value="metadataObjectType") String metadataObjectType, @Param(value="tagName") String tagName) {
        return TagMetadataObjectRelSQLProviderFactory.getProvider().getTagPOsByMetadataObjectAndTagName(metadataObjectId, metadataObjectType, tagName);
    }

    public static String listTagMetadataObjectRelsByMetalakeAndTagName(@Param(value="metalakeName") String metalakeName, @Param(value="tagName") String tagName) {
        return TagMetadataObjectRelSQLProviderFactory.getProvider().listTagMetadataObjectRelsByMetalakeAndTagName(metalakeName, tagName);
    }

    public static String batchInsertTagMetadataObjectRels(@Param(value="tagRels") List<TagMetadataObjectRelPO> tagRelPOs) {
        return TagMetadataObjectRelSQLProviderFactory.getProvider().batchInsertTagMetadataObjectRels(tagRelPOs);
    }

    public static String batchDeleteTagMetadataObjectRelsByTagIdsAndMetadataObject(@Param(value="metadataObjectId") Long metadataObjectId, @Param(value="metadataObjectType") String metadataObjectType, @Param(value="tagIds") List<Long> tagIds) {
        return TagMetadataObjectRelSQLProviderFactory.getProvider().batchDeleteTagMetadataObjectRelsByTagIdsAndMetadataObject(metadataObjectId, metadataObjectType, tagIds);
    }

    public static String softDeleteTagMetadataObjectRelsByMetalakeAndTagName(@Param(value="metalakeName") String metalakeName, @Param(value="tagName") String tagName) {
        return TagMetadataObjectRelSQLProviderFactory.getProvider().softDeleteTagMetadataObjectRelsByMetalakeAndTagName(metalakeName, tagName);
    }

    public static String softDeleteTagMetadataObjectRelsByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return TagMetadataObjectRelSQLProviderFactory.getProvider().softDeleteTagMetadataObjectRelsByMetalakeId(metalakeId);
    }

    public static String deleteTagEntityRelsByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return TagMetadataObjectRelSQLProviderFactory.getProvider().deleteTagEntityRelsByLegacyTimeline(legacyTimeline, limit);
    }

    static class TagMetadataObjectRelH2Provider
    extends TagMetadataObjectRelBaseSQLProvider {
        TagMetadataObjectRelH2Provider() {
        }
    }

    static class TagMetadataObjectRelMySQLProvider
    extends TagMetadataObjectRelBaseSQLProvider {
        TagMetadataObjectRelMySQLProvider() {
        }
    }
}

