/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.provider.ducument;

import com.usthe.sureness.matcher.PathTreeProvider;
import com.usthe.sureness.matcher.SurenessLoadDataException;
import com.usthe.sureness.provider.ducument.DocumentResourceAccess;
import com.usthe.sureness.provider.ducument.DocumentResourceEntity;
import com.usthe.sureness.util.SurenessCommonUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentPathTreeProvider
implements PathTreeProvider {
    private static final Logger logger = LoggerFactory.getLogger(DocumentPathTreeProvider.class);
    private DocumentResourceEntity entity;

    @Override
    public Set<String> providePathData() {
        try {
            List<String> resource;
            if (this.entity == null) {
                this.entity = DocumentResourceAccess.loadConfig();
            }
            HashSet<String> resourceSet = (resource = this.entity.getResourceRole()) != null ? new HashSet<String>(resource) : new HashSet();
            return SurenessCommonUtil.attachContextPath(this.getContextPath(), resourceSet);
        }
        catch (IOException e) {
            logger.error("load config data from yaml file error: ", (Throwable)e);
            throw new SurenessLoadDataException(e.getMessage());
        }
    }

    @Override
    public Set<String> provideExcludedResource() {
        try {
            List<String> resource;
            if (this.entity == null) {
                this.entity = DocumentResourceAccess.loadConfig();
            }
            HashSet<String> resourceSet = (resource = this.entity.getExcludedResource()) != null ? new HashSet<String>(resource) : new HashSet();
            return SurenessCommonUtil.attachContextPath(this.getContextPath(), resourceSet);
        }
        catch (IOException e) {
            logger.error("load config data from yaml file error: ", (Throwable)e);
            throw new SurenessLoadDataException(e.getMessage());
        }
    }
}

