/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.subject.support;

import com.usthe.sureness.subject.PrincipalMap;
import com.usthe.sureness.subject.SubjectSum;
import java.util.Collection;
import java.util.List;

public class SurenessSubjectSum
implements SubjectSum {
    private static final long serialVersionUID = 1L;
    private String principal;
    private PrincipalMap principalMap;
    private List<String> roles;
    private String targetResource;

    private SurenessSubjectSum(Builder builder) {
        this.principal = builder.principal;
        this.principalMap = builder.principalMap;
        this.roles = builder.roles;
        this.targetResource = builder.targetResource;
    }

    @Override
    public Object getPrincipal() {
        return this.principal;
    }

    @Override
    public PrincipalMap getPrincipalMap() {
        return this.principalMap;
    }

    @Override
    public boolean hasRole(String var1) {
        return this.roles.contains(var1);
    }

    @Override
    public boolean hasAllRoles(Collection<String> var1) {
        return this.roles.containsAll(var1);
    }

    @Override
    public Object getRoles() {
        return this.roles;
    }

    @Override
    public Object getTargetResource() {
        return this.targetResource;
    }

    public String toString() {
        return "SurenessSubjectSum{principal='" + this.principal + '\'' + ", principalMap=" + this.principalMap + ", roles=" + this.roles + ", targetResource='" + this.targetResource + '\'' + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String principal;
        private PrincipalMap principalMap;
        private List<String> roles;
        private String targetResource;

        public Builder setPrincipal(String principal) {
            this.principal = principal;
            return this;
        }

        public Builder setPrincipalMap(PrincipalMap principalMap) {
            this.principalMap = principalMap;
            return this;
        }

        public Builder setTargetResource(String targetResource) {
            this.targetResource = targetResource;
            return this;
        }

        public Builder setRoles(List<String> roles) {
            this.roles = roles;
            return this;
        }

        public SurenessSubjectSum build() {
            return new SurenessSubjectSum(this);
        }
    }
}

