/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.util;

import com.usthe.sureness.subject.Subject;
import com.usthe.sureness.subject.SubjectSum;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurenessContextHolder {
    private static final Logger logger = LoggerFactory.getLogger(SurenessContextHolder.class);
    public static final String SUBJECT_KEY = "SUBJECT_KEY";
    private static final ThreadLocal<Map<Object, Object>> RESOURCES = InheritableThreadLocal.withInitial(() -> new HashMap(8));

    public static void clear() {
        if (RESOURCES.get() != null) {
            RESOURCES.get().clear();
        }
        RESOURCES.remove();
    }

    public static void bind(Object key, Object value) {
        SurenessContextHolder.internalPut(key, value);
    }

    public static void unbind(Object key) {
        if (key != null) {
            SurenessContextHolder.internalRemove(key);
        }
    }

    public static Object getBind(Object key) {
        if (key == null) {
            return null;
        }
        return SurenessContextHolder.internalGet(key);
    }

    public static void bindSubject(SubjectSum subjectSum) {
        SurenessContextHolder.internalPut(SUBJECT_KEY, subjectSum);
    }

    public static void bindSubject(Subject subject) {
        if (subject != null) {
            SurenessContextHolder.internalPut(SUBJECT_KEY, subject.generateSubjectSummary());
        }
    }

    public static void unbindSubject() {
        SurenessContextHolder.internalRemove(SUBJECT_KEY);
    }

    public static SubjectSum getBindSubject() {
        return (SubjectSum)SurenessContextHolder.internalGet(SUBJECT_KEY);
    }

    private static void internalPut(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        if (value == null) {
            SurenessContextHolder.internalRemove(key);
        } else {
            SurenessContextHolder.ensureResourcesInitialized();
            RESOURCES.get().put(key, value);
        }
    }

    private static Object internalGet(Object key) {
        Map<Object, Object> perThreadResources;
        if (logger.isTraceEnabled()) {
            logger.trace("get() - in thread [{}]", (Object)Thread.currentThread().getName());
        }
        return (perThreadResources = RESOURCES.get()) != null ? perThreadResources.get(key) : null;
    }

    private static void internalRemove(Object key) {
        Map<Object, Object> perThreadResources = RESOURCES.get();
        if (perThreadResources != null) {
            perThreadResources.remove(key);
        }
    }

    private static void ensureResourcesInitialized() {
        if (RESOURCES.get() == null) {
            RESOURCES.set(new HashMap(8));
        }
    }
}

