/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java17.internal;

import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.RecordedEventHandler;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.ThreadGrouper;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import jdk.jfr.consumer.RecordedEvent;

public abstract class AbstractThreadDispatchingHandler
implements RecordedEventHandler {
    private final Map<String, Consumer<RecordedEvent>> perThread = new HashMap<String, Consumer<RecordedEvent>>();
    private final ThreadGrouper grouper;

    protected AbstractThreadDispatchingHandler(ThreadGrouper grouper) {
        this.grouper = grouper;
    }

    @Override
    public abstract String getEventName();

    public abstract Consumer<RecordedEvent> createPerThreadSummarizer(String var1);

    @Override
    public void accept(RecordedEvent ev) {
        String groupedName = this.grouper.groupedName(ev);
        if (groupedName != null) {
            this.perThread.computeIfAbsent(groupedName, this::createPerThreadSummarizer).accept(ev);
        }
    }
}

