/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.rpc.limit;

import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.limiter.AbstractPartitionedLimiter;
import com.netflix.concurrency.limits.limiter.BlockingLimiter;
import io.greptime.rpc.limit.RequestLimitCtx;
import java.time.Duration;

public class RequestLimiterBuilder
extends AbstractPartitionedLimiter.Builder<RequestLimiterBuilder, RequestLimitCtx> {
    private boolean blockOnLimit = true;
    private long blockTimeoutMillis;

    public static RequestLimiterBuilder newBuilder() {
        return new RequestLimiterBuilder();
    }

    public RequestLimiterBuilder partitionByMethod() {
        return (RequestLimiterBuilder)super.partitionResolver(RequestLimitCtx::partitionKey);
    }

    public RequestLimiterBuilder blockOnLimit(boolean blockOnLimit, long blockTimeoutMillis) {
        this.blockOnLimit = blockOnLimit;
        this.blockTimeoutMillis = blockTimeoutMillis;
        return this;
    }

    public Limiter<RequestLimitCtx> build() {
        return this.blockOnLimit ? BlockingLimiter.wrap((Limiter)super.build(), (Duration)Duration.ofMillis(this.blockTimeoutMillis)) : super.build();
    }

    protected RequestLimiterBuilder self() {
        return this;
    }
}

